/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.ErrorConsts;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.IoStreamException;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ByteBasedPNameTable;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ByteBasedScanner;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.PName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ReaderConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.DataUtil;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlCharTypes;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public abstract class StreamScanner
extends ByteBasedScanner {
    protected InputStream _in;
    protected byte[] _inputBuffer;
    protected final XmlCharTypes _charTypes;
    protected final ByteBasedPNameTable _symbols;
    protected int[] _quadBuffer = new int[32];

    public StreamScanner(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n2, int n3) {
        super(readerConfig);
        this._charTypes = readerConfig.getCharTypes();
        this._symbols = readerConfig.getBBSymbols();
        this._in = inputStream;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateBBSymbols(this._symbols);
        }
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullBBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected abstract int handleEntityInText(boolean var1) throws XMLStreamException;

    protected abstract String parsePublicId(byte var1) throws XMLStreamException;

    protected abstract String parseSystemId(byte var1) throws XMLStreamException;

    @Override
    public final int nextFromProlog(boolean bl2) throws XMLStreamException {
        byte by2;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        this.setStartLocation();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.setStartLocation();
                return -1;
            }
            if ((by2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 60) break;
            if (by2 == 32) continue;
            if (by2 == 10) {
                this.markLF();
                continue;
            }
            if (by2 == 13) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    this.setStartLocation();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (by2 == 9) continue;
            this.reportPrologUnexpChar(bl2, this.decodeCharForError(by2), null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((by2 = this._inputBuffer[this._inputPtr++]) == 33) {
            return this.handlePrologDeclStart(bl2);
        }
        if (by2 == 63) {
            return this.handlePIStart();
        }
        if (by2 == 47 || !bl2) {
            this.reportPrologUnexpElement(bl2, by2);
        }
        return this.handleStartElement(by2);
    }

    @Override
    public final int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                return this._nextEntity();
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            return this._nextEntity();
        }
        this.setStartLocation();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.setStartLocation();
            return -1;
        }
        byte by2 = this._inputBuffer[this._inputPtr];
        if (by2 == 60) {
            ++this._inputPtr;
            byte by3 = by2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (by2 == 33) {
                return this.handleCommentOrCdataStart();
            }
            if (by2 == 63) {
                return this.handlePIStart();
            }
            if (by2 == 47) {
                return this.handleEndElement();
            }
            return this.handleStartElement(by2);
        }
        if (by2 == 38) {
            ++this._inputPtr;
            int n2 = this.handleEntityInText(false);
            if (n2 == 0) {
                this._currToken = 9;
                return 9;
            }
            this._tmpChar = -n2;
        } else {
            this._tmpChar = by2 & 0xFF;
        }
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._currToken = 4;
        return 4;
    }

    protected int _nextEntity() {
        this._textBuilder.resetWithEmpty();
        this._currToken = 9;
        return 9;
    }

    private final int handlePrologDeclStart(boolean bl2) throws XMLStreamException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by2 = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) == 45) {
                if (this._cfgLazyParsing) {
                    this._tokenIncomplete = true;
                } else {
                    this.finishComment();
                }
                this._currToken = 5;
                return 5;
            }
        } else if (by2 == 68 && bl2) {
            this.handleDtdStart();
            if (!this._cfgLazyParsing && this._tokenIncomplete) {
                this.finishDTD(true);
                this._tokenIncomplete = false;
            }
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(bl2, this.decodeCharForError(by2), " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private final int handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        byte by2 = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(by2);
        by2 = this.skipInternalWs(false, null);
        if (by2 == 80) {
            this.matchAsciiKeyword("PUBLIC");
            by2 = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(by2);
            by2 = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(by2);
            by2 = this.skipInternalWs(false, null);
        } else if (by2 == 83) {
            this.matchAsciiKeyword("SYSTEM");
            by2 = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(by2);
            by2 = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (by2 == 62) {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return 11;
        }
        if (by2 != 91) {
            String string = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(this.decodeCharForError(by2), string);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
        return 11;
    }

    private final int handleCommentOrCdataStart() throws XMLStreamException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by2 = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) != 45) {
                this.reportTreeUnexpChar(this.decodeCharForError(by2), " (expected '-' for COMMENT)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishComment();
            }
            this._currToken = 5;
            return 5;
        }
        if (by2 == 91) {
            this._currToken = 12;
            for (int i2 = 0; i2 < 6; ++i2) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((by2 = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i2)) continue;
                int n2 = this.decodeCharForError(by2);
                this.reportTreeUnexpChar(n2, " (expected '" + "CDATA[".charAt(i2) + "' for CDATA section)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishCData();
            }
            return 12;
        }
        this.reportTreeUnexpChar(this.decodeCharForError(by2), " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    private final int handlePIStart() throws XMLStreamException {
        int n2;
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte by2 = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(by2);
        String string = this._tokenName.getLocalName();
        if (string.length() == 3 && string.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) {
            while (true) {
                if (n2 == 10) {
                    this.markLF();
                } else if (n2 == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (n2 != 32 && n2 != 9) {
                    this.throwInvalidSpace(n2);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((n2 = this._inputBuffer[this._inputPtr] & 0xFF) > 32) break;
                ++this._inputPtr;
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishPI();
            }
        } else {
            if (n2 != 63) {
                this.reportMissingPISpace(this.decodeCharForError((byte)n2));
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) != 62) {
                this.reportMissingPISpace(this.decodeCharForError(by2));
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    protected final int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte by2 = this._inputBuffer[this._inputPtr++];
        int n2 = 0;
        if (by2 == 120) {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((by2 = this._inputBuffer[this._inputPtr++]) != 59) {
                    n2 <<= 4;
                    byte by3 = by2;
                    if (by3 <= 57 && by3 >= 48) {
                        n2 += by3 - 48;
                    } else if (by3 >= 97 && by3 <= 102) {
                        n2 += 10 + (by3 - 97);
                    } else if (by3 >= 65 && by3 <= 70) {
                        n2 += 10 + (by3 - 65);
                    } else {
                        this.throwUnexpectedChar(this.decodeCharForError(by2), "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (n2 <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (by2 != 59) {
                byte by4 = by2;
                if (by4 <= 57 && by4 >= 48) {
                    if ((n2 = n2 * 10 + (by4 - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(this.decodeCharForError(by2), "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                by2 = this._inputBuffer[this._inputPtr++];
            }
        }
        this.verifyXmlChar(n2);
        return n2;
    }

    protected abstract int handleStartElement(byte var1) throws XMLStreamException;

    protected final int handleEndElement() throws XMLStreamException {
        int n2;
        int n3;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        int n4 = this._tokenName.sizeInQuads();
        if (this._inputEnd - this._inputPtr < (n4 << 2) + 1) {
            return this.handleEndElementSlow(n4);
        }
        int n5 = this._inputPtr;
        byte[] byArray = this._inputBuffer;
        --n4;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = byArray[n5] << 24 | (byArray[n5 + 1] & 0xFF) << 16 | (byArray[n5 + 2] & 0xFF) << 8 | byArray[n5 + 3] & 0xFF;
            n5 += 4;
            if (n2 == this._tokenName.getQuad(n3)) continue;
            this._inputPtr = n5;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        n3 = this._tokenName.getQuad(n4);
        if ((n2 = byArray[n5++] & 0xFF) != n3 && (n2 = n2 << 8 | byArray[n5++] & 0xFF) != n3 && (n2 = n2 << 8 | byArray[n5++] & 0xFF) != n3 && (n2 = n2 << 8 | byArray[n5++] & 0xFF) != n3) {
            this._inputPtr = n5;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int n6 = this._inputBuffer[n5] & 0xFF;
        this._inputPtr = n5 + 1;
        while (n6 <= 32) {
            if (n6 == 10) {
                this.markLF();
            } else if (n6 == 13) {
                byte by2;
                byte by3 = by2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by2 != 10) {
                    this.markLF(this._inputPtr - 1);
                    n6 = by2 & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (n6 != 32 && n6 != 9) {
                this.throwInvalidSpace(n6);
            }
            n6 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (n6 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)n6), " expected space or closing '>'");
        }
        return 2;
    }

    private final int handleEndElementSlow(int n2) throws XMLStreamException {
        block14: {
            int n3;
            int n4;
            int n5;
            --n2;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = 0;
                for (n3 = 0; n3 < 4; ++n3) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    n4 = n4 << 8 | this._inputBuffer[this._inputPtr++] & 0xFF;
                }
                if (n4 == this._tokenName.getQuad(n5)) continue;
                this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
            }
            n5 = this._tokenName.getQuad(n2);
            n4 = 0;
            n3 = 0;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((n4 = n4 << 8 | this._inputBuffer[this._inputPtr++] & 0xFF) == n5) break block14;
            } while (++n3 <= 3);
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int n6 = this._inputBuffer[this._inputPtr++];
        while (n6 <= 32) {
            if (n6 == 10) {
                this.markLF();
            } else if (n6 == 13) {
                byte by2;
                byte by3 = by2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (by2 != 10) {
                    this.markLF(this._inputPtr - 1);
                    n6 = by2 & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (n6 != 32 && n6 != 9) {
                this.throwInvalidSpace(n6);
            }
            n6 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (n6 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)n6), " expected space or closing '>'");
        }
        return 2;
    }

    protected final PName parsePName(byte by2) throws XMLStreamException {
        int n2;
        if (this._inputEnd - this._inputPtr < 8) {
            return this.parsePNameSlow(by2);
        }
        int n3 = by2 & 0xFF;
        if (n3 < 65) {
            this.throwUnexpectedChar(n3, "; expected a name start character");
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, 1);
        }
        n3 = n3 << 8 | n2;
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, 2);
        }
        n3 = n3 << 8 | n2;
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, 3);
        }
        n3 = n3 << 8 | n2;
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, 4);
        }
        return this.parsePNameMedium(n2, n3);
    }

    protected PName parsePNameMedium(int n2, int n3) throws XMLStreamException {
        int n4 = n2;
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, n4, 1);
        }
        n4 = n4 << 8 | n2;
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, n4, 2);
        }
        n4 = n4 << 8 | n2;
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, n4, 3);
        }
        n4 = n4 << 8 | n2;
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n2 < 45 || n2 > 58 || n2 == 47)) {
            return this.findPName(n3, n4, 4);
        }
        int[] nArray = this._quadBuffer;
        nArray[0] = n3;
        nArray[1] = n4;
        return this.parsePNameLong(n2, nArray);
    }

    protected final PName parsePNameLong(int n2, int[] nArray) throws XMLStreamException {
        int n3 = 2;
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n2, nArray, n3, 1);
            }
            n2 = n2 << 8 | n4;
            n4 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n2, nArray, n3, 2);
            }
            n2 = n2 << 8 | n4;
            n4 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n2, nArray, n3, 3);
            }
            n2 = n2 << 8 | n4;
            n4 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n2, nArray, n3, 4);
            }
            if (n3 >= nArray.length) {
                nArray = DataUtil.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n3] = n2;
            ++n3;
            n2 = n4;
        }
    }

    protected final PName parsePNameSlow(byte by2) throws XMLStreamException {
        int n2 = by2 & 0xFF;
        if (n2 < 65) {
            this.throwUnexpectedChar(n2, "; expected a name start character");
        }
        int[] nArray = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n5 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (n5 < 45 || n5 > 58 || n5 == 47)) {
                return this.findPName(n2, 1, n4, n3, nArray);
            }
            n2 = n2 << 8 | n5;
            n5 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n5 < 65 && (n5 < 45 || n5 > 58 || n5 == 47)) {
                return this.findPName(n2, 2, n4, n3, nArray);
            }
            n2 = n2 << 8 | n5;
            n5 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n5 < 65 && (n5 < 45 || n5 > 58 || n5 == 47)) {
                return this.findPName(n2, 3, n4, n3, nArray);
            }
            n2 = n2 << 8 | n5;
            n5 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (n5 < 65 && (n5 < 45 || n5 > 58 || n5 == 47)) {
                return this.findPName(n2, 4, n4, n3, nArray);
            }
            if (n3 == 0) {
                n4 = n2;
            } else if (n3 == 1) {
                nArray[0] = n4;
                nArray[1] = n2;
            } else {
                if (n3 >= nArray.length) {
                    this._quadBuffer = nArray = DataUtil.growArrayBy(nArray, nArray.length);
                }
                nArray[n3] = n2;
            }
            ++n3;
            n2 = n5;
        }
    }

    private final PName findPName(int n2, int n3) throws XMLStreamException {
        --this._inputPtr;
        int n4 = ByteBasedPNameTable.calcHash(n2);
        PName pName = this._symbols.findSymbol(n4, n2, 0);
        if (pName == null) {
            this._quadBuffer[0] = n2;
            pName = this.addPName(n4, this._quadBuffer, 1, n3);
        }
        return pName;
    }

    private final PName findPName(int n2, int n3, int n4) throws XMLStreamException {
        --this._inputPtr;
        int n5 = ByteBasedPNameTable.calcHash(n2, n3);
        PName pName = this._symbols.findSymbol(n5, n2, n3);
        if (pName == null) {
            this._quadBuffer[0] = n2;
            this._quadBuffer[1] = n3;
            pName = this.addPName(n5, this._quadBuffer, 2, n4);
        }
        return pName;
    }

    private final PName findPName(int n2, int[] nArray, int n3, int n4) throws XMLStreamException {
        --this._inputPtr;
        if (n3 >= nArray.length) {
            nArray = DataUtil.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n3++] = n2;
        int n5 = ByteBasedPNameTable.calcHash(nArray, n3);
        PName pName = this._symbols.findSymbol(n5, nArray, n3);
        if (pName == null) {
            pName = this.addPName(n5, nArray, n3, n4);
        }
        return pName;
    }

    private final PName findPName(int n2, int n3, int n4, int n5, int[] nArray) throws XMLStreamException {
        if (n5 <= 1) {
            if (n5 == 0) {
                return this.findPName(n2, n3);
            }
            return this.findPName(n4, n2, n3);
        }
        return this.findPName(n2, nArray, n5, n3);
    }

    protected final PName addPName(int n2, int[] nArray, int n3, int n4) throws XMLStreamException {
        return this.addUTFPName(this._symbols, this._charTypes, n2, nArray, n3, n4);
    }

    protected byte skipInternalWs(boolean bl2, String string) throws XMLStreamException {
        byte by2;
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n2 = (by2 = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) {
            if (!bl2) {
                return by2;
            }
            this.reportTreeUnexpChar(this.decodeCharForError(by2), " (expected white space " + string + ")");
        }
        do {
            if (by2 == 10) {
                this.markLF();
            } else if (by2 == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (by2 != 32 && by2 != 9) {
                this.throwInvalidSpace(by2);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while (((by2 = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
        return by2;
    }

    private final void matchAsciiKeyword(String string) throws XMLStreamException {
        int n2 = string.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            byte by2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) == (byte)string.charAt(i2)) continue;
            this.reportTreeUnexpChar(this.decodeCharForError(by2), " (expected '" + string.charAt(i2) + "' for " + string + " keyword)");
        }
    }

    protected final int checkInTreeIndentation(int n2) throws XMLStreamException {
        int n3;
        int n4;
        byte by2;
        if (n2 == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((by2 = this._inputBuffer[this._inputPtr]) != 32 && by2 != 9) {
            if (by2 == 60 && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != 33) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n5 = n4 = by2 == 32 ? 32 : 8;
        for (n3 = 1; n3 <= n4; ++n3) {
            byte by3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((by3 = this._inputBuffer[this._inputPtr]) != by2) {
                if (by3 != 60 || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == 33) break;
                this._textBuilder.resetWithIndentation(n3, (char)by2);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] cArray = this._textBuilder.resetWithEmpty();
        cArray[0] = 10;
        char c2 = (char)by2;
        for (int i2 = 1; i2 <= n3; ++i2) {
            cArray[i2] = c2;
        }
        this._textBuilder.setCurrentLength(++n3);
        return n3;
    }

    protected final int checkPrologIndentation(int n2) throws XMLStreamException {
        int n3;
        if (n2 == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        byte by2 = this._inputBuffer[this._inputPtr];
        if (by2 != 32 && by2 != 9) {
            if (by2 == 60) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n4 = 1;
        int n5 = n3 = by2 == 32 ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == by2) {
            ++this._inputPtr;
            if (++n4 < n3) continue;
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            char c2 = (char)by2;
            for (int i2 = 1; i2 <= n4; ++i2) {
                cArray[i2] = c2;
            }
            this._textBuilder.setCurrentLength(++n4);
            return n4;
        }
        this._textBuilder.resetWithIndentation(n4, (char)by2);
        return -1;
    }

    @Override
    protected final boolean loadMore() throws XMLStreamException {
        this._pastBytesOrChars += (long)this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        try {
            int n2 = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n2 < 1) {
                this._inputEnd = 0;
                if (n2 == 0) {
                    this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = n2;
            return true;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected final byte nextByte(int n2) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(n2));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte nextByte() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final byte loadOne(int n2) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(n2));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadAndRetain(int n2) throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this._pastBytesOrChars += (long)this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int n3 = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n3);
        this._inputPtr = 0;
        this._inputEnd = n3;
        try {
            do {
                int n4;
                int n5;
                if ((n5 = this._in.read(this._inputBuffer, this._inputEnd, n4 = this._inputBuffer.length - this._inputEnd)) < 1) {
                    if (n5 == 0) {
                        this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + n4);
                    }
                    return false;
                }
                this._inputEnd += n5;
            } while (this._inputEnd < n2);
            return true;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }
}

