/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.ErrorConsts;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WriterConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.XmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlCharTypes;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlChars;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.typed.AsciiValueEncoder;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public abstract class ByteXmlWriter
extends XmlWriter {
    static final int DEFAULT_FULL_BUFFER_SIZE = 4000;
    static final int DEFAULT_COPY_BUFFER_SIZE = 1000;
    static final int SMALL_WRITE = 250;
    static final byte BYTE_SPACE = 32;
    static final byte BYTE_COLON = 58;
    static final byte BYTE_SEMICOLON = 59;
    static final byte BYTE_LBRACKET = 91;
    static final byte BYTE_RBRACKET = 93;
    static final byte BYTE_QMARK = 63;
    static final byte BYTE_EQ = 61;
    static final byte BYTE_SLASH = 47;
    static final byte BYTE_HASH = 35;
    static final byte BYTE_HYPHEN = 45;
    static final byte BYTE_LT = 60;
    static final byte BYTE_GT = 62;
    static final byte BYTE_AMP = 38;
    static final byte BYTE_QUOT = 34;
    static final byte BYTE_APOS = 39;
    static final byte BYTE_A = 97;
    static final byte BYTE_G = 103;
    static final byte BYTE_L = 108;
    static final byte BYTE_M = 109;
    static final byte BYTE_O = 111;
    static final byte BYTE_P = 112;
    static final byte BYTE_Q = 113;
    static final byte BYTE_S = 115;
    static final byte BYTE_T = 116;
    static final byte BYTE_U = 117;
    static final byte BYTE_X = 120;
    static final byte[] BYTES_CDATA_START = ByteXmlWriter.getAscii("<![CDATA[");
    static final byte[] BYTES_CDATA_END = ByteXmlWriter.getAscii("]]>");
    static final byte[] BYTES_COMMENT_START = ByteXmlWriter.getAscii("<!--");
    static final byte[] BYTES_COMMENT_END = ByteXmlWriter.getAscii("-->");
    static final byte[] BYTES_XMLDECL_START = ByteXmlWriter.getAscii("<?xml version='");
    static final byte[] BYTES_XMLDECL_ENCODING = ByteXmlWriter.getAscii(" encoding='");
    static final byte[] BYTES_XMLDECL_STANDALONE = ByteXmlWriter.getAscii(" standalone='");
    protected OutputStream _out;
    protected byte[] _outputBuffer;
    protected int _outputPtr;
    protected final int _outputBufferLen;
    protected int _surrogate = 0;
    protected final XmlCharTypes _charTypes;

    protected ByteXmlWriter(WriterConfig writerConfig, OutputStream outputStream, XmlCharTypes xmlCharTypes) {
        super(writerConfig);
        this._out = outputStream;
        this._outputBuffer = writerConfig.allocFullBBuffer(4000);
        this._outputBufferLen = this._outputBuffer.length;
        this._outputPtr = 0;
        this._charTypes = xmlCharTypes;
    }

    @Override
    protected final int getOutputPtr() {
        return this._outputPtr;
    }

    @Override
    public final WName constructName(String string) throws XMLStreamException {
        this.verifyNameComponent(string);
        return this.doConstructName(string);
    }

    @Override
    public WName constructName(String string, String string2) throws XMLStreamException {
        this.verifyNameComponent(string);
        this.verifyNameComponent(string2);
        return this.doConstructName(string, string2);
    }

    protected abstract WName doConstructName(String var1) throws XMLStreamException;

    protected abstract WName doConstructName(String var1, String var2) throws XMLStreamException;

    protected void verifyNameComponent(String string) throws XMLStreamException {
        int n2;
        int n3;
        if (string == null || string.length() == 0) {
            this.reportNwfName(ErrorConsts.WERR_NAME_EMPTY);
        }
        int n4 = string.charAt(0);
        int n5 = string.length();
        if (n4 >= 55296 && n4 <= 57343) {
            if (n4 >= 56320) {
                this.reportNwfName("Illegal surrogate pairing in name: first character (" + XmlChars.getCharDesc(n4) + ") not valid surrogate first character");
            }
            if (n5 < 2) {
                this.reportNwfName("Illegal surrogate pairing in name: incomplete surrogate (missing second half)");
            }
            n4 = this.calcSurrogate(n4, string.charAt(1), " in name");
            n3 = 2;
        } else {
            n3 = 1;
        }
        if (!XmlChars.is10NameStartChar(n4)) {
            this.reportNwfName("Invalid name start character " + XmlChars.getCharDesc(n4) + " (name \"" + string + "\")");
        }
        if (n4 > (n2 = this.getHighestEncodable())) {
            this.reportNwfName("Illegal name start character " + XmlChars.getCharDesc(n4) + " (name \"" + string + "\"): can not be expressed using effective encoding (" + this._config.getActualEncoding() + ")");
        }
        while (n3 < n5) {
            n4 = string.charAt(n3);
            if (n4 >= 55296 && n4 <= 57343) {
                if (n4 >= 56320) {
                    this.reportNwfName("Illegal surrogate pairing in name: character at #" + n3 + " (" + XmlChars.getCharDesc(n4) + ") not valid surrogate first character");
                }
                if (++n3 >= n5) {
                    this.reportNwfName("Illegal surrogate pairing in name: name ends with incomplete surrogate pair");
                }
                n4 = this.calcSurrogate(n4, string.charAt(n3), " in name");
            }
            if (n4 > n2) {
                this.reportNwfName("Illegal name character " + XmlChars.getCharDesc(n4) + " (name \"" + string + "\", index #" + n3 + "): can not be expressed using effective encoding (" + this._config.getActualEncoding() + ")");
            }
            if (!XmlChars.is10NameChar(n4)) {
                this.reportNwfName("Invalid name character " + XmlChars.getCharDesc(n4) + ") in name (\"" + string + "\"), index #" + n3);
            }
            ++n3;
        }
    }

    protected abstract void outputSurrogates(int var1, int var2) throws IOException, XMLStreamException;

    protected abstract void output2ByteChar(int var1) throws IOException, XMLStreamException;

    protected abstract int outputStrictMultiByteChar(int var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    protected abstract int outputMultiByteChar(int var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    @Override
    public void _releaseBuffers() {
        super._releaseBuffers();
        if (this._outputBuffer != null) {
            this._config.freeFullBBuffer(this._outputBuffer);
            this._outputBuffer = null;
        }
        if (this._copyBuffer != null) {
            this._config.freeFullCBuffer(this._copyBuffer);
            this._copyBuffer = null;
        }
    }

    @Override
    public void _closeTarget(boolean bl2) throws IOException {
        if (this._out != null && bl2) {
            this._out.close();
            this._out = null;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this._out != null) {
            this.flushBuffer();
            this._out.flush();
        }
    }

    @Override
    public final void writeRaw(String string, int n2, int n3) throws IOException, XMLStreamException {
        while (n3 > 0) {
            char[] cArray = this._copyBuffer;
            int n4 = cArray.length;
            int n5 = n3 < n4 ? n3 : n4;
            string.getChars(n2, n2 + n5, cArray, 0);
            this.writeRaw(cArray, 0, n5);
            n2 += n5;
            n3 -= n5;
        }
    }

    @Override
    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    @Override
    public final void writeStartTagStart(WName wName) throws IOException, XMLStreamException {
        int n2;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n2 = this._outputPtr) + wName.serializedLength() + 1 > this._outputBufferLen) {
            this.writeName((byte)60, wName);
            return;
        }
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = 60;
        n2 += wName.appendBytes(byArray, n2);
        this._outputPtr = n2;
    }

    @Override
    public final void writeStartTagEnd() throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = 62;
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int n2 = this._outputPtr;
        if (n2 + 2 > this._outputBufferLen) {
            this.flushBuffer();
            n2 = this._outputPtr;
        }
        byte[] byArray = this._outputBuffer;
        byArray[n2++] = 47;
        byArray[n2++] = 62;
        this._outputPtr = n2;
    }

    @Override
    public final void writeEndTag(WName wName) throws IOException, XMLStreamException {
        int n2;
        int n3;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n3 = this._outputPtr) + (n2 = wName.serializedLength()) + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (n2 + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                wName.writeBytes(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            n3 = this._outputPtr;
        }
        byte[] byArray = this._outputBuffer;
        byArray[n3++] = 60;
        byArray[n3++] = 47;
        n3 += wName.appendBytes(byArray, n3);
        byArray[n3++] = 62;
        this._outputPtr = n3;
    }

    @Override
    public final void writeAttribute(WName wName, String string) throws IOException, XMLStreamException {
        int n2 = string.length();
        if (n2 > this._copyBufferLen) {
            this.writeLongAttribute(wName, string, n2);
            return;
        }
        char[] cArray = this._copyBuffer;
        if (n2 > 0) {
            string.getChars(0, n2, cArray, 0);
        }
        this.writeAttribute(wName, cArray, 0, n2);
    }

    @Override
    public final void writeAttribute(WName wName, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int n4 = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        if (n4 + wName.serializedLength() >= this._outputBufferLen) {
            this.writeName((byte)32, wName);
            n4 = this._outputPtr;
        } else {
            byArray[n4++] = 32;
            n4 += wName.appendBytes(byArray, n4);
        }
        if (n4 + 3 + n3 > this._outputBufferLen) {
            this._outputPtr = n4;
            this.flushBuffer();
            byArray[this._outputPtr++] = 61;
            byArray[this._outputPtr++] = 34;
            if (this._outputPtr + n3 + 1 > this._outputBufferLen) {
                this.writeAttrValue(cArray, n2, n3);
                this.writeRaw((byte)34);
                return;
            }
            n4 = this._outputPtr;
        } else {
            byArray[n4++] = 61;
            byArray[n4++] = 34;
        }
        if (n3 > 0) {
            n4 = this.fastWriteAttrValue(cArray, n2, n3, byArray, n4);
        }
        byArray[n4++] = 34;
        this._outputPtr = n4;
    }

    protected final int fastWriteAttrValue(char[] cArray, int n2, int n3, byte[] byArray, int n4) throws IOException, XMLStreamException {
        n3 += n2;
        block4: while (n2 < n3) {
            char c2;
            int[] nArray = this._charTypes.ATTR_CHARS;
            while ((c2 = cArray[n2]) < '\u0800' && nArray[c2] == 0) {
                byArray[n4++] = (byte)c2;
                if (++n2 < n3) continue;
                break block4;
            }
            this._outputPtr = n4;
            if ((c2 = cArray[n2++]) < '\u0800') {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                        break;
                    }
                    case 5: {
                        this.output2ByteChar(c2);
                        break;
                    }
                    default: {
                        this.writeAsEntity(c2);
                        break;
                    }
                }
            } else {
                n2 = this.outputMultiByteChar(c2, cArray, n2, n3);
            }
            if (n3 - n2 >= this._outputBufferLen - this._outputPtr) {
                this.flushBuffer();
            }
            n4 = this._outputPtr;
        }
        return n4;
    }

    protected final void writeAttrValue(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, cArray[n2]);
            ++n2;
            --n3;
        }
        n3 += n2;
        block4: while (n2 < n3) {
            char c2;
            int[] nArray = this._charTypes.ATTR_CHARS;
            while ((c2 = cArray[n2]) < '\u0800' && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                if (++n2 < n3) continue;
                break block4;
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 5: {
                        this.output2ByteChar(c2);
                        continue block4;
                    }
                }
                this.writeAsEntity(c2);
                continue;
            }
            n2 = this.outputMultiByteChar(c2, cArray, n2, n3);
        }
    }

    protected final void writeLongAttribute(WName wName, String string, int n2) throws IOException, XMLStreamException {
        this.writeRaw((byte)32);
        int n3 = wName.serializedLength();
        if (this._outputPtr + n3 > this._outputBufferLen) {
            this.flushBuffer();
            if (n3 > this._outputBufferLen) {
                wName.writeBytes(this._out);
            } else {
                this._outputPtr += wName.appendBytes(this._outputBuffer, this._outputPtr);
            }
        } else {
            this._outputPtr += wName.appendBytes(this._outputBuffer, this._outputPtr);
        }
        this.writeRaw((byte)61, (byte)34);
        int n4 = 0;
        while (n2 > 0) {
            char[] cArray = this._copyBuffer;
            int n5 = cArray.length;
            int n6 = n2 < n5 ? n2 : n5;
            string.getChars(n4, n4 + n6, cArray, 0);
            this.writeAttrValue(cArray, 0, n6);
            n4 += n6;
            n2 -= n6;
        }
        this.writeRaw((byte)34);
    }

    protected final void writeName(WName wName) throws IOException {
        int n2 = this._outputPtr;
        int n3 = wName.serializedLength();
        if (n2 + n3 > this._outputBufferLen) {
            this.flushBuffer();
            if (n3 >= this._outputBufferLen) {
                wName.writeBytes(this._out);
                return;
            }
            n2 = this._outputPtr;
        }
        n2 += wName.appendBytes(this._outputBuffer, n2);
        this._outputPtr = n2;
    }

    protected final void writeName(byte by2, WName wName) throws IOException {
        this.flushBuffer();
        int n2 = wName.serializedLength();
        if (n2 >= this._outputBufferLen) {
            this._out.write(by2);
            wName.writeBytes(this._out);
            return;
        }
        int n3 = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        byArray[n3++] = by2;
        n3 += wName.appendBytes(byArray, n3);
        this._outputPtr = n3;
    }

    protected final void writeName(WName wName, byte by2) throws IOException {
        this.flushBuffer();
        if (wName.serializedLength() >= this._outputBufferLen) {
            wName.writeBytes(this._out);
            this._out.write(by2);
            return;
        }
        int n2 = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        n2 += wName.appendBytes(byArray, n2);
        byArray[n2++] = by2;
        this._outputPtr = n2;
    }

    private final void writeAttrNameEqQ(WName wName) throws IOException, XMLStreamException {
        int n2;
        int n3;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n3 = this._outputPtr) + (n2 = wName.serializedLength()) + 3 >= this._outputBufferLen) {
            this.flushBuffer();
            n3 = this._outputPtr;
            if (n3 + n2 + 3 >= this._outputBufferLen) {
                this.writeName((byte)32, wName);
                this.writeRaw((byte)61);
                this.writeRaw((byte)34);
                return;
            }
        }
        byte[] byArray = this._outputBuffer;
        byArray[n3++] = 32;
        n3 += wName.appendBytes(byArray, n3);
        byArray[n3++] = 61;
        byArray[n3++] = 34;
        this._outputPtr = n3;
    }

    @Override
    public int writeCData(String string) throws IOException, XMLStreamException {
        int n2;
        this.writeCDataStart();
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._copyBuffer;
            n2 = cArray.length;
            if (n2 > i2) {
                n2 = i2;
            }
            string.getChars(n3, n3 + n2, cArray, 0);
            int n4 = this.writeCDataContents(cArray, 0, n2);
            if (n4 >= 0) {
                return n3 + n4;
            }
            n3 += n2;
        }
        this.writeCDataEnd();
        return -1;
    }

    @Override
    public int writeCData(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        this.writeCDataStart();
        int n4 = this.writeCDataContents(cArray, n2, n3);
        if (n4 < 0) {
            this.writeCDataEnd();
        }
        return n4;
    }

    protected int writeCDataContents(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        n3 += n2;
        block7: while (n2 < n3) {
            char c2;
            int[] nArray = this._charTypes.OTHER_CHARS;
            while ((c2 = cArray[n2]) < '\u0800' && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                if (++n2 < n3) continue;
                break block7;
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 2: 
                    case 3: {
                        ++this._locRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("CDATA", c2);
                    }
                    case 5: {
                        this.output2ByteChar(c2);
                        continue block7;
                    }
                    case 11: {
                        if (n2 >= n3 || cArray[n2] != ']') break;
                        if (n2 + 1 >= n3 || cArray[n2 + 1] != '>') continue block7;
                        n2 += 2;
                        this.writeRaw((byte)93, (byte)93);
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeRaw((byte)62);
                        continue block7;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                continue;
            }
            n2 = this.outputMultiByteChar(c2, cArray, n2, n3);
        }
        return -1;
    }

    @Override
    public final void writeCharacters(String string) throws IOException, XMLStreamException {
        int n2 = string.length();
        if (n2 > this._copyBufferLen) {
            this.longWriteCharacters(string);
            return;
        }
        if (n2 > 0) {
            char[] cArray = this._copyBuffer;
            string.getChars(0, n2, cArray, 0);
            this.writeCharacters(cArray, 0, n2);
        }
    }

    private final void longWriteCharacters(String string) throws IOException, XMLStreamException {
        int n2;
        int n3 = 0;
        int n4 = string.length();
        char[] cArray = this._copyBuffer;
        do {
            int n5;
            n2 = n4 < (n5 = cArray.length) ? n4 : n5;
            string.getChars(n3, n3 + n2, cArray, 0);
            this.writeCharacters(cArray, 0, n2);
            n3 += n2;
        } while ((n4 -= n2) > 0);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void writeCharacters(char[] var1_1, int var2_2, int var3_3) throws IOException, XMLStreamException {
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, var1_1[var2_2]);
            ++var2_2;
            --var3_3;
        }
        if ((var4_4 = this._outputPtr) + var3_3 > this._outputBufferLen) {
            this.writeSplitCharacters(var1_1, var2_2, var3_3);
            return;
        }
        var3_3 += var2_2;
        block8: while (var2_2 < var3_3) {
            block15: {
                block14: {
                    var5_5 = this._charTypes.TEXT_CHARS;
                    while ((var6_6 = var1_1[var2_2]) < '\u0800') {
                        if (var5_5[var6_6] != 0) {
                            if (var6_6 != '\n') break;
                            ++this._locRowNr;
                        }
                        this._outputBuffer[var4_4++] = (byte)var6_6;
                        if (++var2_2 < var3_3) continue;
                        break block8;
                    }
                    if ((var6_6 = var1_1[var2_2++]) >= '\u0800') break block14;
                    switch (var5_5[var6_6]) {
                        case 1: {
                            this.reportInvalidChar(var6_6);
                        }
                        case 2: {
                            if (!this._config.willEscapeCR()) ** GOTO lbl27
                            this._outputPtr = var4_4;
                            this.writeAsEntity(var6_6);
                            break block15;
lbl27:
                            // 1 sources

                            this._outputBuffer[var4_4++] = (byte)var6_6;
                            ++this._locRowNr;
                            break;
                        }
                        case 3: {
                            break block15;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this._outputPtr = var4_4;
                            this.writeAsEntity(var6_6);
                            break block15;
                        }
                        case 5: {
                            this._outputPtr = var4_4;
                            this.output2ByteChar(var6_6);
                            break block15;
                        }
                        case 11: {
                            if (var2_2 < var3_3 && var1_1[var2_2] != '>') ** GOTO lbl45
                            this._outputPtr = var4_4;
                            this.writeAsEntity(var6_6);
                            break block15;
                        }
lbl45:
                        // 2 sources

                        default: {
                            this._outputBuffer[var4_4++] = (byte)var6_6;
                            break;
                        }
                    }
                    continue;
                }
                this._outputPtr = var4_4;
                var2_2 = this.outputMultiByteChar(var6_6, var1_1, var2_2, var3_3);
            }
            if (var3_3 - var2_2 >= this._outputBufferLen - this._outputPtr) {
                this.flushBuffer();
            }
            var4_4 = this._outputPtr;
        }
        this._outputPtr = var4_4;
    }

    private final void writeSplitCharacters(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        n3 += n2;
        block8: while (n2 < n3) {
            char c2;
            block16: {
                block15: {
                    int[] nArray = this._charTypes.TEXT_CHARS;
                    while ((c2 = cArray[n2]) < '\u0800') {
                        if (nArray[c2] != 0) {
                            if (c2 != '\n') break;
                            ++this._locRowNr;
                        }
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = (byte)c2;
                        if (++n2 < n3) continue;
                        break block8;
                    }
                    if ((c2 = cArray[n2++]) >= '\u0800') break block15;
                    switch (nArray[c2]) {
                        case 1: {
                            this.reportInvalidChar(c2);
                        }
                        case 2: {
                            if (this._config.willEscapeCR()) {
                                this.writeAsEntity(c2);
                                continue block8;
                            }
                            ++this._locRowNr;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this.writeAsEntity(c2);
                            continue block8;
                        }
                        case 5: {
                            this.output2ByteChar(c2);
                            continue block8;
                        }
                        case 11: {
                            if (n2 >= n3 || cArray[n2] == '>') {
                                this.writeAsEntity(c2);
                                continue block8;
                            } else {
                                break;
                            }
                        }
                    }
                    break block16;
                }
                n2 = this.outputMultiByteChar(c2, cArray, n2, n3);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)c2;
        }
    }

    @Override
    public void writeTypedValue(AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        int n2;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (asciiValueEncoder.bufferNeedsFlush(n2 = this._outputBufferLen - this._outputPtr)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = asciiValueEncoder.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flushBuffer();
        }
    }

    @Override
    public final void writeAttribute(WName wName, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        this.writeAttrNameEqQ(wName);
        int n2 = this._outputBufferLen - this._outputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n2)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = asciiValueEncoder.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flushBuffer();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = 34;
    }

    @Override
    public int writeComment(String string) throws IOException, XMLStreamException {
        int n2;
        this.writeCommentStart();
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._copyBuffer;
            n2 = cArray.length;
            int n4 = i2 < n2 ? i2 : n2;
            string.getChars(n3, n3 + n4, cArray, 0);
            int n5 = this.writeCommentContents(cArray, 0, n4);
            if (n5 >= 0) {
                return n3 + n5;
            }
            n3 += n2;
        }
        this.writeCommentEnd();
        return -1;
    }

    protected int writeCommentContents(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        n3 += n2;
        block7: while (n2 < n3) {
            char c2;
            int[] nArray = this._charTypes.OTHER_CHARS;
            while ((c2 = cArray[n2]) < '\u0800' && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                if (++n2 < n3) continue;
                break block7;
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 2: 
                    case 3: {
                        ++this._locRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("comment", c2);
                    }
                    case 5: {
                        this.output2ByteChar(c2);
                        continue block7;
                    }
                    case 13: {
                        if (n2 < n3 && cArray[n2] != '-') break;
                        this.writeRaw((byte)45, (byte)32);
                        continue block7;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                continue;
            }
            n2 = this.outputMultiByteChar(c2, cArray, n2, n3);
        }
        return -1;
    }

    @Override
    public void writeDTD(String string) throws IOException, XMLStreamException {
        this.writeRaw(string, 0, string.length());
    }

    @Override
    public void writeDTD(WName wName, String string, String string2, String string3) throws IOException, XMLStreamException {
    }

    protected int writePIData(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        n3 += n2;
        block7: while (n2 < n3) {
            char c2;
            int[] nArray = this._charTypes.OTHER_CHARS;
            while ((c2 = cArray[n2]) < '\u0800' && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                if (++n2 < n3) continue;
                break block7;
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 2: 
                    case 3: {
                        ++this._locRowNr;
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("processing instruction", c2);
                    }
                    case 5: {
                        this.output2ByteChar(c2);
                        continue block7;
                    }
                    case 12: {
                        if (n2 >= n3 || cArray[n2] != '>') break;
                        return n2;
                    }
                }
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                continue;
            }
            n2 = this.outputMultiByteChar(c2, cArray, n2, n3);
        }
        return -1;
    }

    @Override
    public void writeEntityReference(WName wName) throws IOException, XMLStreamException {
        this.writeRaw((byte)38);
        this.writeName(wName);
        this.writeRaw((byte)59);
    }

    @Override
    public int writePI(WName wName, String string) throws IOException, XMLStreamException {
        this.writeRaw((byte)60, (byte)63);
        this.writeName(wName);
        if (string != null) {
            int n2;
            this.writeRaw((byte)32);
            int n3 = 0;
            for (int i2 = string.length(); i2 > 0; i2 -= n2) {
                char[] cArray = this._copyBuffer;
                n2 = cArray.length;
                if (n2 > i2) {
                    n2 = i2;
                }
                string.getChars(n3, n3 + n2, cArray, 0);
                int n4 = this.writePIData(cArray, 0, n2);
                if (n4 >= 0) {
                    return n3 + n4;
                }
                n3 += n2;
            }
        }
        this.writeRaw((byte)63, (byte)62);
        return -1;
    }

    @Override
    public final void writeSpace(String string) throws IOException, XMLStreamException {
        int n2;
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._copyBuffer;
            int n4 = cArray.length;
            n2 = i2 < n4 ? i2 : n4;
            string.getChars(n3, n3 + n2, cArray, 0);
            this.writeSpace(cArray, 0, n2);
            n3 += n2;
        }
    }

    @Override
    public void writeSpace(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        if (this._surrogate != 0) {
            this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, this._surrogate, n2 - 1);
        }
        n3 += n2;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) > ' ' && (!this._config.isXml11() || c2 != '\u0085' && c2 != '\u2028')) {
                this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, c2, n2 - 1);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)c2;
        }
    }

    @Override
    public void writeXmlDeclaration(String string, String string2, String string3) throws IOException, XMLStreamException {
        this.writeRaw(BYTES_XMLDECL_START);
        this.writeRaw(string, 0, string.length());
        this.writeRaw((byte)39);
        if (string2 != null && string2.length() > 0) {
            this.writeRaw(BYTES_XMLDECL_ENCODING);
            this.writeRaw(string2, 0, string2.length());
            this.writeRaw((byte)39);
        }
        if (string3 != null) {
            this.writeRaw(BYTES_XMLDECL_STANDALONE);
            this.writeRaw(string3, 0, string3.length());
            this.writeRaw((byte)39);
        }
        this.writeRaw((byte)63, (byte)62);
    }

    protected final void writeCDataStart() throws IOException {
        this.writeRaw(BYTES_CDATA_START);
    }

    protected final void writeCDataEnd() throws IOException {
        this.writeRaw(BYTES_CDATA_END);
    }

    protected final void writeCommentStart() throws IOException {
        this.writeRaw(BYTES_COMMENT_START);
    }

    protected final void writeCommentEnd() throws IOException {
        this.writeRaw(BYTES_COMMENT_END);
    }

    protected final void writeRaw(byte by2) throws IOException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = by2;
    }

    protected final void writeRaw(byte by2, byte by3) throws IOException {
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = by2;
        this._outputBuffer[this._outputPtr++] = by3;
    }

    protected final void writeRaw(byte[] byArray) throws IOException {
        this.writeRaw(byArray, 0, byArray.length);
    }

    protected final void writeRaw(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this._surrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        if ((n4 = this._outputPtr) + n3 <= this._outputBufferLen) {
            System.arraycopy(byArray, n2, this._outputBuffer, n4, n3);
            this._outputPtr += n3;
            return;
        }
        if (n4 > 0) {
            this.flush();
            n4 = this._outputPtr;
        }
        if (n3 < 250) {
            System.arraycopy(byArray, n2, this._outputBuffer, n4, n3);
            this._outputPtr += n3;
        } else {
            this._out.write(byArray, n2, n3);
        }
    }

    protected final void throwUnpairedSurrogate() throws IOException {
        int n2 = this._surrogate;
        this._surrogate = 0;
        this.throwUnpairedSurrogate(n2);
    }

    protected final void throwUnpairedSurrogate(int n2) throws IOException {
        this.flush();
        throw new IOException("Unpaired surrogate character (0x" + Integer.toHexString(n2) + ")");
    }

    protected final void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int n2 = this._outputPtr;
            this._locPastChars += n2;
            this._locRowStartOffset -= n2;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, n2);
        }
    }

    protected final void writeAsEntity(int n2) throws IOException {
        int n3 = this._outputPtr;
        byte[] byArray = this._outputBuffer;
        if (n3 + 10 >= byArray.length) {
            this.flushBuffer();
            n3 = this._outputPtr;
        }
        byArray[n3++] = 38;
        if (n2 < 256) {
            if (n2 == 38) {
                byArray[n3++] = 97;
                byArray[n3++] = 109;
                byArray[n3++] = 112;
            } else if (n2 == 60) {
                byArray[n3++] = 108;
                byArray[n3++] = 116;
            } else if (n2 == 62) {
                byArray[n3++] = 103;
                byArray[n3++] = 116;
            } else if (n2 == 39) {
                byArray[n3++] = 97;
                byArray[n3++] = 112;
                byArray[n3++] = 111;
                byArray[n3++] = 115;
            } else if (n2 == 34) {
                byArray[n3++] = 113;
                byArray[n3++] = 117;
                byArray[n3++] = 111;
                byArray[n3++] = 116;
            } else {
                byArray[n3++] = 35;
                byArray[n3++] = 120;
                if (n2 >= 16) {
                    int n4 = n2 >> 4;
                    byArray[n3++] = (byte)(n4 < 10 ? 48 + n4 : 87 + n4);
                    n2 &= 0xF;
                }
                byArray[n3++] = (byte)(n2 < 10 ? 48 + n2 : 87 + n2);
            }
        } else {
            byArray[n3++] = 35;
            byArray[n3++] = 120;
            int n5 = 20;
            int n6 = n3;
            do {
                int n7;
                if ((n7 = n2 >> n5 & 0xF) <= 0 && n3 == n6) continue;
                byArray[n3++] = (byte)(n7 < 10 ? 48 + n7 : 87 + n7);
            } while ((n5 -= 4) > 0);
            byArray[n3++] = (byte)((n2 &= 0xF) < 10 ? 48 + n2 : 87 + n2);
        }
        byArray[n3++] = 59;
        this._outputPtr = n3;
    }

    protected final int calcSurrogate(int n2, int n3, String string) throws XMLStreamException {
        int n4;
        if (n3 < 56320 || n3 > 57343) {
            String string2 = "Incomplete surrogate pair" + string + ": first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3);
            this.reportNwfContent(string2);
        }
        if ((n4 = 65536 + (n2 - 55296 << 10) + (n3 - 56320)) > 0x10FFFF) {
            this.reportInvalidChar(n4);
        }
        return n4;
    }

    protected static final byte[] getAscii(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        ByteXmlWriter.getAscii(string, byArray, 0);
        return byArray;
    }

    protected static final void getAscii(String string, byte[] byArray) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
    }

    protected static final void getAscii(String string, byte[] byArray, int n2) {
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2 + i2] = (byte)string.charAt(i2);
        }
    }
}

