/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.ErrorConsts;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.io.UTF8Writer;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.CharWName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.OutputCharTypes;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WriterConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.XmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlCharTypes;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.typed.AsciiValueEncoder;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;

public final class CharXmlWriter
extends XmlWriter {
    static final int DEFAULT_SMALL_SIZE = 200;
    static final int DEFAULT_FULL_BUFFER_SIZE = 1000;
    protected final int mSmallWriteSize;
    protected Writer _out;
    protected char[] _outputBuffer;
    protected int _outputPtr;
    protected final int _outputBufferLen;
    private final int mEncHighChar;
    private final int mTableCheckEnd;
    final XmlCharTypes mCharTypes;

    public CharXmlWriter(WriterConfig writerConfig, Writer writer) {
        super(writerConfig);
        this._out = writer;
        this._outputBuffer = writerConfig.allocFullCBuffer(1000);
        this._outputBufferLen = this._outputBuffer.length;
        this.mSmallWriteSize = 200;
        this._outputPtr = 0;
        int n2 = CharXmlWriter.guessEncodingBitSize(writerConfig);
        this.mEncHighChar = n2 < 16 ? 1 << n2 : 65534;
        this.mTableCheckEnd = Math.min(256, this.mEncHighChar);
        this.mCharTypes = n2 < 8 ? OutputCharTypes.getAsciiCharTypes() : OutputCharTypes.getLatin1CharTypes();
    }

    @Override
    protected int getOutputPtr() {
        return this._outputPtr;
    }

    @Override
    public int getHighestEncodable() {
        return this.mEncHighChar;
    }

    @Override
    public WName constructName(String string) {
        return new CharWName(string);
    }

    @Override
    public WName constructName(String string, String string2) {
        return new CharWName(string, string2);
    }

    @Override
    public void _releaseBuffers() {
        super._releaseBuffers();
        if (this._outputBuffer != null) {
            this._config.freeFullCBuffer(this._outputBuffer);
            this._outputBuffer = null;
        }
    }

    @Override
    public void _closeTarget(boolean bl2) throws IOException {
        if (this._out != null && (bl2 || this._out instanceof UTF8Writer)) {
            this._out.close();
            this._out = null;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this._out != null) {
            this.flushBuffer();
            this._out.flush();
        }
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        if (this._out == null) {
            return;
        }
        if (n3 < this.mSmallWriteSize) {
            if (this._outputPtr + n3 > this._outputBufferLen) {
                this.flushBuffer();
            }
            System.arraycopy(cArray, n2, this._outputBuffer, this._outputPtr, n3);
            this._outputPtr += n3;
            return;
        }
        int n4 = this._outputPtr;
        if (n4 > 0) {
            if (n4 < this.mSmallWriteSize) {
                int n5 = this.mSmallWriteSize - n4;
                System.arraycopy(cArray, n2, this._outputBuffer, n4, n5);
                this._outputPtr = n4 + n5;
                n3 -= n5;
                n2 += n5;
            }
            this.flushBuffer();
        }
        this._out.write(cArray, n2, n3);
    }

    @Override
    public void writeRaw(String string, int n2, int n3) throws IOException {
        if (this._out == null) {
            return;
        }
        if (n3 < this.mSmallWriteSize) {
            if (this._outputPtr + n3 >= this._outputBufferLen) {
                this.flushBuffer();
            }
            string.getChars(n2, n2 + n3, this._outputBuffer, this._outputPtr);
            this._outputPtr += n3;
            return;
        }
        int n4 = this._outputPtr;
        if (n4 > 0) {
            if (n4 < this.mSmallWriteSize) {
                int n5 = this.mSmallWriteSize - n4;
                string.getChars(n2, n2 + n5, this._outputBuffer, n4);
                this._outputPtr = n4 + n5;
                n3 -= n5;
                n2 += n5;
            }
            this.flushBuffer();
        }
        this._out.write(string, n2, n3);
    }

    public final void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    public final void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    public final void writeCommentStart() throws IOException {
        this.fastWriteRaw("<!--");
    }

    public final void writeCommentEnd() throws IOException {
        this.fastWriteRaw("-->");
    }

    @Override
    public int writeCData(String string) throws IOException, XMLStreamException {
        int n2;
        this.writeCDataStart();
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._copyBuffer;
            int n4 = cArray.length;
            n2 = i2 < n4 ? i2 : n4;
            string.getChars(n3, n3 + n2, cArray, 0);
            int n5 = this.writeCDataContents(cArray, 0, n2);
            if (n5 >= 0) {
                return n3 + n5;
            }
            n3 += n2;
        }
        this.writeCDataEnd();
        return -1;
    }

    @Override
    public int writeCData(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        this.writeCDataStart();
        int n4 = this.writeCDataContents(cArray, n2, n3);
        if (n4 < 0) {
            this.writeCDataEnd();
        }
        return -1;
    }

    private int writeCDataContents(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        n3 += n2;
        int n4 = n2;
        block6: while (n2 < n3) {
            char c2;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            int n5 = this.mTableCheckEnd;
            while ((c2 = cArray[n2]) < n5 && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c2;
                if (++n2 < n3) continue;
                break block6;
            }
            if ((c2 = cArray[n2++]) < n5) {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("CDATA block", c2);
                    }
                    case 17: {
                        if (n2 - n4 < 3 || cArray[n2 - 2] != ']' || cArray[n2 - 3] != ']') break;
                        --n2;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                    }
                }
            } else if (c2 >= this.mEncHighChar) {
                this.reportFailedEscaping("CDATA block", c2);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c2;
        }
        return -1;
    }

    @Override
    public void writeCharacters(String string) throws IOException, XMLStreamException {
        int n2;
        if (this._out == null) {
            return;
        }
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._copyBuffer;
            int n4 = cArray.length;
            n2 = i2 < n4 ? i2 : n4;
            string.getChars(n3, n3 + n2, cArray, 0);
            this.writeCharacters(cArray, 0, n2);
            n3 += n2;
        }
    }

    @Override
    public void writeCharacters(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        n3 += n2;
        block6: while (n2 < n3) {
            char c2;
            block14: {
                block13: {
                    int[] nArray = this.mCharTypes.TEXT_CHARS;
                    int n4 = this.mTableCheckEnd;
                    while ((c2 = cArray[n2]) < n4 && nArray[c2] == 0) {
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = c2;
                        if (++n2 < n3) continue;
                        break block6;
                    }
                    if ((c2 = cArray[n2++]) >= n4) break block13;
                    switch (nArray[c2]) {
                        case 1: {
                            this.reportInvalidChar(c2);
                        }
                        case 11: {
                            if (n2 < n3 && cArray[n2] != '>') break;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this.writeAsEntity(c2);
                            continue block6;
                        }
                        case 2: {
                            if (this._config.willEscapeCR()) {
                                this.writeAsEntity(c2);
                                continue block6;
                            } else {
                                break;
                            }
                        }
                    }
                    break block14;
                }
                if (c2 >= this.mEncHighChar) {
                    this.writeAsEntity(c2);
                    continue;
                }
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c2;
        }
    }

    @Override
    public void writeSpace(String string) throws IOException, XMLStreamException {
        int n2;
        if (this._out == null) {
            return;
        }
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._copyBuffer;
            int n4 = cArray.length;
            n2 = i2 < n4 ? i2 : n4;
            string.getChars(n3, n3 + n2, cArray, 0);
            this.writeSpace(cArray, 0, n2);
            n3 += n2;
        }
    }

    @Override
    public void writeSpace(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        n3 += n2;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) > ' ' && (!this._config.isXml11() || c2 != '\u0085' && c2 != '\u2028')) {
                this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, c2, n2 - 1);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c2;
        }
    }

    @Override
    public int writeComment(String string) throws IOException, XMLStreamException {
        int n2;
        if (this._out == null) {
            return -1;
        }
        this.writeCommentStart();
        int n3 = 0;
        int n4 = -1;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            char[] cArray = this._copyBuffer;
            n2 = cArray.length;
            if (n2 > i2) {
                n2 = i2;
            }
            string.getChars(n3, n3 + n2, cArray, 0);
            n4 = this.writeCommentContents(cArray, 0, n2, false);
            if (n4 >= 0) break;
            n3 += n2;
        }
        if (n4 >= 0) {
            return n3 + n4;
        }
        this.writeCommentEnd();
        return -1;
    }

    private int writeCommentContents(char[] cArray, int n2, int n3, boolean bl2) throws IOException, XMLStreamException {
        n3 += n2;
        block6: while (n2 < n3) {
            char c2;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            int n4 = this.mTableCheckEnd;
            while ((c2 = cArray[n2]) < n4 && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c2;
                if (++n2 < n3) continue;
                break block6;
            }
            if ((c2 = cArray[n2++]) < n4) {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("comment", c2);
                    }
                    case 13: {
                        if (n2 != n3 && cArray[n2] != '-') break;
                        if (!this._config.willFixContent()) {
                            return n2 - 1;
                        }
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = 32;
                    }
                }
            } else if (c2 >= this.mEncHighChar) {
                this.reportFailedEscaping("comment", c2);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c2;
        }
        return -1;
    }

    @Override
    public void writeDTD(String string) throws IOException, XMLStreamException {
        this.writeRaw(string, 0, string.length());
    }

    @Override
    public void writeDTD(WName wName, String string, String string2, String string3) throws IOException, XMLStreamException {
        this.fastWriteRaw("<!DOCTYPE ");
        this.writeName(wName);
        if (string != null) {
            if (string2 != null) {
                this.fastWriteRaw(" PUBLIC \"");
                this.fastWriteRaw(string2);
                this.fastWriteRaw("\" \"");
            } else {
                this.fastWriteRaw(" SYSTEM \"");
            }
            this.fastWriteRaw(string);
            this.fastWriteRaw('\"');
        }
        if (string3 != null && string3.length() > 0) {
            this.fastWriteRaw(' ', '[');
            this.fastWriteRaw(string3);
            this.fastWriteRaw(']');
        }
        this.fastWriteRaw('>');
    }

    @Override
    public void writeEntityReference(WName wName) throws IOException, XMLStreamException {
        this.fastWriteRaw('&');
        this.writeName(wName);
        this.fastWriteRaw(';');
    }

    @Override
    public void writeXmlDeclaration(String string, String string2, String string3) throws IOException, XMLStreamException {
        this.fastWriteRaw("<?xml version='");
        this.fastWriteRaw(string);
        this.fastWriteRaw('\'');
        if (string2 != null && string2.length() > 0) {
            this.fastWriteRaw(" encoding='");
            this.fastWriteRaw(string2);
            this.fastWriteRaw('\'');
        }
        if (string3 != null) {
            this.fastWriteRaw(" standalone='");
            this.fastWriteRaw(string3);
            this.fastWriteRaw('\'');
        }
        this.fastWriteRaw('?', '>');
    }

    @Override
    public int writePI(WName wName, String string) throws IOException, XMLStreamException {
        this.fastWriteRaw('<', '?');
        this.writeName(wName);
        if (string != null && string.length() > 0) {
            int n2;
            int n3 = 0;
            int n4 = -1;
            this.fastWriteRaw(' ');
            for (int i2 = string.length(); i2 > 0; i2 -= n2) {
                char[] cArray = this._copyBuffer;
                n2 = cArray.length;
                if (n2 > i2) {
                    n2 = i2;
                }
                string.getChars(n3, n3 + n2, cArray, 0);
                n4 = this.writePIContents(cArray, 0, n2);
                if (n4 >= 0) break;
                n3 += n2;
            }
            if (n4 >= 0) {
                return n3 + n4;
            }
        }
        this.fastWriteRaw('?', '>');
        return -1;
    }

    private int writePIContents(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        n3 += n2;
        block6: while (n2 < n3) {
            char c2;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            int n4 = this.mTableCheckEnd;
            while ((c2 = cArray[n2]) < n4 && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c2;
                if (++n2 < n3) continue;
                break block6;
            }
            if ((c2 = cArray[n2++]) < n4) {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("processing instruction", c2);
                    }
                    case 12: {
                        if (n2 >= n3 || cArray[n2] != '>') break;
                        return n2;
                    }
                }
            } else if (c2 >= this.mEncHighChar) {
                this.reportFailedEscaping("processing instruction", c2);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c2;
        }
        return -1;
    }

    @Override
    public void writeStartTagStart(WName wName) throws IOException, XMLStreamException {
        int n2 = this._outputPtr;
        int n3 = wName.serializedLength();
        if (n2 + n3 + 1 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            if (n3 >= this._outputBufferLen) {
                this._out.write(60);
                wName.writeChars(this._out);
                return;
            }
            n2 = this._outputPtr;
        }
        char[] cArray = this._outputBuffer;
        cArray[n2++] = 60;
        wName.appendChars(cArray, n2);
        this._outputPtr = n2 + n3;
    }

    @Override
    public void writeStartTagEnd() throws IOException, XMLStreamException {
        this.fastWriteRaw('>');
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int n2 = this._outputPtr;
        if (n2 + 2 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            n2 = this._outputPtr;
        }
        char[] cArray = this._outputBuffer;
        cArray[n2++] = 47;
        cArray[n2++] = 62;
        this._outputPtr = n2;
    }

    @Override
    public void writeEndTag(WName wName) throws IOException, XMLStreamException {
        int n2 = this._outputPtr;
        int n3 = wName.serializedLength();
        if (n2 + n3 + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (n3 + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                wName.writeChars(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            n2 = this._outputPtr;
        }
        char[] cArray = this._outputBuffer;
        cArray[n2++] = 60;
        cArray[n2++] = 47;
        wName.appendChars(cArray, n2);
        n2 += n3;
        cArray[n2++] = 62;
        this._outputPtr = n2;
    }

    @Override
    public void writeAttribute(WName wName, String string) throws IOException, XMLStreamException {
        int n2;
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(wName);
        this.fastWriteRaw('=', '\"');
        int n3 = n2 = string == null ? 0 : string.length();
        if (n2 > 0) {
            this.writeAttrValue(string, n2);
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeAttribute(WName wName, char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(wName);
        this.fastWriteRaw('=', '\"');
        if (n3 > 0) {
            this.writeAttrValue(cArray, n2, n3);
        }
        this.fastWriteRaw('\"');
    }

    private final void writeAttrValue(String string, int n2) throws IOException, XMLStreamException {
        int n3 = 0;
        while (n2 > 0) {
            char[] cArray = this._copyBuffer;
            int n4 = cArray.length;
            int n5 = n2 < n4 ? n2 : n4;
            string.getChars(n3, n3 + n5, cArray, 0);
            this.writeAttrValue(cArray, 0, n5);
            n3 += n5;
            n2 -= n5;
        }
    }

    private final void writeAttrValue(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        if (this._outputPtr + n3 > this._outputBufferLen) {
            this.writeSplitAttrValue(cArray, n2, n3);
            return;
        }
        n3 += n2;
        block5: while (n2 < n3) {
            char c2;
            block11: {
                block10: {
                    int[] nArray = this.mCharTypes.ATTR_CHARS;
                    int n4 = this.mTableCheckEnd;
                    while ((c2 = cArray[n2]) < n4 && nArray[c2] == 0) {
                        this._outputBuffer[this._outputPtr++] = c2;
                        if (++n2 < n3) continue;
                        break block5;
                    }
                    if ((c2 = cArray[n2++]) >= n4) break block10;
                    switch (nArray[c2]) {
                        case 1: {
                            this.reportInvalidChar(c2);
                        }
                        case 4: 
                        case 9: 
                        case 10: 
                        case 14: {
                            break block11;
                        }
                        case 2: 
                        case 3: {
                            break block11;
                        }
                        default: {
                            this._outputBuffer[this._outputPtr++] = c2;
                            break;
                        }
                    }
                    continue;
                }
                if (c2 < this.mEncHighChar) {
                    this._outputBuffer[this._outputPtr++] = c2;
                    continue;
                }
            }
            this.writeAsEntity(c2);
            if (n3 - n2 < this._outputBufferLen - this._outputPtr) continue;
            this.flushBuffer();
        }
    }

    private final void writeSplitAttrValue(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        n3 += n2;
        block5: while (n2 < n3) {
            char c2;
            int[] nArray = this.mCharTypes.ATTR_CHARS;
            int n4 = this.mTableCheckEnd;
            while ((c2 = cArray[n2]) < n4 && nArray[c2] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c2;
                if (++n2 < n3) continue;
                break block5;
            }
            if ((c2 = cArray[n2++]) < n4) {
                switch (nArray[c2]) {
                    case 1: {
                        this.reportInvalidChar(c2);
                    }
                    case 4: 
                    case 9: 
                    case 10: 
                    case 14: {
                        this.writeAsEntity(c2);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        this.writeAsEntity(c2);
                        continue block5;
                    }
                }
            } else if (c2 >= this.mEncHighChar) {
                this.writeAsEntity(c2);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c2;
        }
    }

    @Override
    public void writeTypedValue(AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        int n2 = this._outputBufferLen - this._outputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n2)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = asciiValueEncoder.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flushBuffer();
        }
    }

    @Override
    public final void writeAttribute(WName wName, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(wName);
        this.fastWriteRaw('=', '\"');
        this.writeTypedValue(asciiValueEncoder);
        this.fastWriteRaw('\"');
    }

    private final void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int n2 = this._outputPtr;
            this._locPastChars += n2;
            this._locRowStartOffset -= n2;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, n2);
        }
    }

    protected final void writeName(WName wName) throws IOException {
        int n2 = this._outputPtr;
        int n3 = wName.serializedLength();
        if (n2 + n3 > this._outputBufferLen) {
            this.flushBuffer();
            if (n3 >= this._outputBufferLen) {
                wName.writeChars(this._out);
                return;
            }
            n2 = this._outputPtr;
        }
        wName.appendChars(this._outputBuffer, n2);
        this._outputPtr += n3;
    }

    private final void fastWriteRaw(char c2) throws IOException {
        if (this._outputPtr >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c2;
    }

    private final void fastWriteRaw(char c2, char c3) throws IOException {
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c2;
        this._outputBuffer[this._outputPtr++] = c3;
    }

    private final void fastWriteRaw(String string) throws IOException {
        int n2 = this._outputPtr;
        int n3 = string.length();
        if (n2 + n3 >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            if (n3 > this._outputBufferLen) {
                this.writeRaw(string, 0, string.length());
                return;
            }
            this.flushBuffer();
            n2 = this._outputPtr;
        }
        string.getChars(0, n3, this._outputBuffer, n2);
        this._outputPtr = n2 + n3;
    }

    protected int verifyCDataContent(String string) {
        int n2;
        if (string != null && string.length() >= 3 && (n2 = string.indexOf(93)) >= 0) {
            return string.indexOf("]]>", n2);
        }
        return -1;
    }

    protected int verifyCDataContent(char[] cArray, int n2, int n3) {
        if (cArray != null) {
            n2 += 2;
            while (n2 < n3) {
                char c2 = cArray[n2];
                if (c2 == ']') {
                    ++n2;
                    continue;
                }
                if (c2 == '>' && cArray[n2 - 1] == ']' && cArray[n2 - 2] == ']') {
                    return n2 - 2;
                }
                n2 += 2;
            }
        }
        return -1;
    }

    protected int verifyCommentContent(String string) {
        int n2 = string.indexOf(45);
        if (n2 >= 0 && n2 < string.length() - 1) {
            n2 = string.indexOf("--", n2);
        }
        return n2;
    }

    protected void writeSegmentedCData(String string, int n2) throws IOException {
        int n3 = 0;
        while (n2 >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(string, n3, n2 + 2 - n3);
            this.fastWriteRaw("]]>");
            n3 = n2 + 2;
            n2 = string.indexOf("]]>", n3);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(string, n3, string.length() - n3);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedCData(char[] cArray, int n2, int n3, int n4) throws IOException {
        int n5 = n2 + n3;
        while (n4 >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(cArray, n2, n4 + 2 - n2);
            this.fastWriteRaw("]]>");
            n2 = n4 + 2;
            n4 = this.verifyCDataContent(cArray, n2, n5);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(cArray, n2, n5 - n2);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedComment(String string, int n2) throws IOException {
        int n3 = string.length();
        if (n2 == n3 - 1) {
            this.fastWriteRaw("<!--");
            this.writeRaw(string, 0, string.length());
            this.fastWriteRaw(" -->");
            return;
        }
        this.fastWriteRaw("<!--");
        int n4 = 0;
        while (n2 >= 0) {
            this.writeRaw(string, n4, n2 + 1 - n4);
            this.fastWriteRaw(' ');
            n4 = n2 + 1;
            n2 = string.indexOf("--", n4);
        }
        this.writeRaw(string, n4, n3 - n4);
        if (string.charAt(n3 - 1) == '-') {
            this.fastWriteRaw(' ');
        }
        this.fastWriteRaw("-->");
    }

    protected final void writeAsEntity(int n2) throws IOException {
        int n3 = this._outputPtr;
        char[] cArray = this._outputBuffer;
        if (n3 + 10 >= cArray.length) {
            this.flushBuffer();
            n3 = this._outputPtr;
        }
        cArray[n3++] = 38;
        if (n2 < 256) {
            if (n2 == 38) {
                cArray[n3++] = 97;
                cArray[n3++] = 109;
                cArray[n3++] = 112;
            } else if (n2 == 60) {
                cArray[n3++] = 108;
                cArray[n3++] = 116;
            } else if (n2 == 62) {
                cArray[n3++] = 103;
                cArray[n3++] = 116;
            } else if (n2 == 39) {
                cArray[n3++] = 97;
                cArray[n3++] = 112;
                cArray[n3++] = 111;
                cArray[n3++] = 115;
            } else if (n2 == 34) {
                cArray[n3++] = 113;
                cArray[n3++] = 117;
                cArray[n3++] = 111;
                cArray[n3++] = 116;
            } else {
                cArray[n3++] = 35;
                cArray[n3++] = 120;
                if (n2 >= 16) {
                    int n4 = n2 >> 4;
                    cArray[n3++] = (char)(n4 < 10 ? 48 + n4 : 87 + n4);
                    n2 &= 0xF;
                }
                cArray[n3++] = (char)(n2 < 10 ? 48 + n2 : 87 + n2);
            }
        } else {
            cArray[n3++] = 35;
            cArray[n3++] = 120;
            int n5 = 20;
            int n6 = n3;
            do {
                int n7;
                if ((n7 = n2 >> n5 & 0xF) <= 0 && n3 == n6) continue;
                cArray[n3++] = (char)(n7 < 10 ? 48 + n7 : 87 + n7);
            } while ((n5 -= 4) > 0);
            cArray[n3++] = (char)((n2 &= 0xF) < 10 ? 48 + n2 : 87 + n2);
        }
        cArray[n3++] = 59;
        this._outputPtr = n3;
    }
}

