/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.ByteWName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.OutputCharTypes;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.SingleByteXmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WriterConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class Latin1XmlWriter
extends SingleByteXmlWriter {
    static final int LAST_VALID_CHAR = 255;

    public Latin1XmlWriter(WriterConfig writerConfig, OutputStream outputStream) {
        super(writerConfig, outputStream, OutputCharTypes.getLatin1CharTypes());
    }

    @Override
    public int getHighestEncodable() {
        return 255;
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._out == null || n3 == 0) {
            return;
        }
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, cArray[n2]);
            ++n2;
            --n3;
        }
        n3 += n2;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) > '\u00ff') {
                this.reportFailedEscaping("raw content", c2);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)c2;
        }
    }

    @Override
    protected WName doConstructName(String string) throws XMLStreamException {
        return new ByteWName(string, Latin1XmlWriter.getAscii(string));
    }

    @Override
    protected WName doConstructName(String string, String string2) throws XMLStreamException {
        int n2 = string.length();
        byte[] byArray = new byte[n2 + 1 + string2.length()];
        Latin1XmlWriter.getAscii(string, byArray, 0);
        byArray[n2] = 58;
        Latin1XmlWriter.getAscii(string2, byArray, n2 + 1);
        return new ByteWName(string, string2, byArray);
    }
}

