/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.IoStreamException;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.ByteWName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.ByteXmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.OutputCharTypes;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WriterConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class Utf8XmlWriter
extends ByteXmlWriter {
    public Utf8XmlWriter(WriterConfig writerConfig, OutputStream outputStream) {
        super(writerConfig, outputStream, OutputCharTypes.getUtf8CharTypes());
    }

    @Override
    public int getHighestEncodable() {
        return 0x10FFFF;
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws IOException, XMLStreamException {
        if (this._out == null || n3 == 0) {
            return;
        }
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, cArray[n2]);
            ++n2;
            --n3;
        }
        n3 += n2;
        block0: while (n2 < n3) {
            char c2;
            while ((c2 = cArray[n2]) < '\u0080') {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)c2;
                if (++n2 < n3) continue;
                break block0;
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                this.output2ByteChar(c2);
                continue;
            }
            n2 = this.outputMultiByteChar(c2, cArray, n2, n3);
        }
    }

    @Override
    protected WName doConstructName(String string) throws XMLStreamException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            return new ByteWName(string, byArray);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    @Override
    protected WName doConstructName(String string, String string2) throws XMLStreamException {
        try {
            byte[] byArray = (string + ":" + string2).getBytes("UTF-8");
            return new ByteWName(string, string2, byArray);
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    @Override
    protected final void outputSurrogates(int n2, int n3) throws IOException, XMLStreamException {
        int n4 = this.calcSurrogate(n2, n3, " in content");
        if (this._outputPtr + 4 > this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = (byte)(0xF0 | n4 >> 18);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | n4 >> 12 & 0x3F);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | n4 >> 6 & 0x3F);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | n4 & 0x3F);
    }

    @Override
    protected final void output2ByteChar(int n2) throws IOException, XMLStreamException {
        if (this._outputPtr + 2 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputPtr++] = (byte)(0xC0 | n2 >> 6);
        byArray[this._outputPtr++] = (byte)(0x80 | n2 & 0x3F);
    }

    @Override
    protected final int outputMultiByteChar(int n2, char[] cArray, int n3, int n4) throws IOException, XMLStreamException {
        if (n2 >= 55296) {
            if (n2 <= 57343) {
                if (n3 >= n4) {
                    this._surrogate = n2;
                } else {
                    this.outputSurrogates(n2, cArray[n3]);
                    ++n3;
                }
                return n3;
            }
            if (n2 >= 65534) {
                this.reportInvalidChar(n2);
            }
        }
        if (this._outputPtr + 3 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputPtr++] = (byte)(0xE0 | n2 >> 12);
        byArray[this._outputPtr++] = (byte)(0x80 | n2 >> 6 & 0x3F);
        byArray[this._outputPtr++] = (byte)(0x80 | n2 & 0x3F);
        return n3;
    }

    @Override
    protected final int outputStrictMultiByteChar(int n2, char[] cArray, int n3, int n4) throws IOException, XMLStreamException {
        if (n2 >= 55296) {
            if (n2 <= 57343) {
                if (n3 >= n4) {
                    this._surrogate = n2;
                } else {
                    this.outputSurrogates(n2, cArray[n3]);
                    ++n3;
                }
                return n3;
            }
            if (n2 >= 65534) {
                this.reportInvalidChar(n2);
            }
        }
        if (this._outputPtr + 3 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        byArray[this._outputPtr++] = (byte)(0xE0 | n2 >> 12);
        byArray[this._outputPtr++] = (byte)(0x80 | n2 >> 6 & 0x3F);
        byArray[this._outputPtr++] = (byte)(0x80 | n2 & 0x3F);
        return n3;
    }
}

