/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.sax;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.sax.SAXFeature;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.sax.SAXParserImpl;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.sax.SAXUtil;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.stax.InputFactoryImpl;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    final InputFactoryImpl mStaxFactory = new InputFactoryImpl();

    public static SAXParserFactory newInstance() {
        return new SAXParserFactoryImpl();
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeature sAXFeature = SAXUtil.findStdFeature(string);
        if (sAXFeature != null) {
            Boolean bl2 = SAXUtil.getFixedStdFeatureValue(sAXFeature);
            if (bl2 != null) {
                return bl2;
            }
            switch (sAXFeature) {
                case IS_STANDALONE: {
                    return true;
                }
            }
        }
        SAXUtil.reportUnknownFeature(string);
        return false;
    }

    @Override
    public SAXParser newSAXParser() {
        return new SAXParserImpl(this.mStaxFactory);
    }

    @Override
    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXFeature sAXFeature = SAXUtil.findStdFeature(string);
        if (sAXFeature != null) {
            boolean bl3;
            switch (sAXFeature) {
                case EXTERNAL_GENERAL_ENTITIES: {
                    bl3 = !bl2;
                    break;
                }
                case EXTERNAL_PARAMETER_ENTITIES: {
                    bl3 = !bl2;
                    break;
                }
                case IS_STANDALONE: {
                    bl3 = true;
                    break;
                }
                case LEXICAL_HANDLER_PARAMETER_ENTITIES: {
                    bl3 = true;
                    break;
                }
                case NAMESPACES: {
                    bl3 = bl2;
                    break;
                }
                case NAMESPACE_PREFIXES: {
                    bl3 = !bl2;
                    break;
                }
                case RESOLVE_DTD_URIS: {
                    bl3 = true;
                    break;
                }
                case STRING_INTERNING: {
                    bl3 = true;
                    break;
                }
                case UNICODE_NORMALIZATION_CHECKING: {
                    bl3 = false;
                    break;
                }
                case USE_ATTRIBUTES2: 
                case USE_LOCATOR2: 
                case USE_ENTITY_RESOLVER2: {
                    bl3 = true;
                    break;
                }
                case VALIDATION: {
                    bl3 = !bl2;
                    break;
                }
                case XMLNS_URIS: {
                    bl3 = true;
                    break;
                }
                case XML_1_1: {
                    bl3 = !bl2;
                    break;
                }
                default: {
                    bl3 = false;
                }
            }
            if (!bl3) {
                throw new SAXNotSupportedException("Setting std feature " + (Object)((Object)sAXFeature) + " to " + bl2 + " not supported");
            }
            return;
        }
        SAXUtil.reportUnknownFeature(string);
    }

    @Override
    public void setNamespaceAware(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException("Non-namespace-aware mode not implemented");
        }
        super.setNamespaceAware(bl2);
    }

    @Override
    public void setValidating(boolean bl2) {
        if (bl2) {
            throw new IllegalArgumentException("Validating mode not implemented");
        }
        super.setValidating(bl2);
    }
}

