/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.stax;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.dom.DOMWriterImpl;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.IoStreamException;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.StreamExceptionBase;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.AsciiXmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.CharXmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.Latin1XmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.NonRepairingStreamWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.RepairingStreamWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.Utf8XmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WNameTable;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WriterConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.XmlWriter;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.CharsetNames;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.URLUtil;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.XMLOutputFactory2;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.XMLStreamWriter2;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.io.Stax2Result;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.Stax2EventWriterImpl;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.Stax2WriterAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

public final class OutputFactoryImpl
extends XMLOutputFactory2 {
    protected final WriterConfig _config = new WriterConfig();

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLEventWriter(outputStream, null);
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(outputStream, null, string, false));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(result));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(null, writer, null, false));
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLStreamWriter(outputStream, null);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return this.createSW(outputStream, null, string, false);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createSW(result);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.createSW(null, writer, null, false);
    }

    @Override
    public Object getProperty(String string) {
        return this._config.getProperty(string, true);
    }

    @Override
    public boolean isPropertySupported(String string) {
        return this._config.isPropertySupported(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this._config.setProperty(string, object);
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer, String string) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(null, writer, string, false));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        XMLStreamWriter2 xMLStreamWriter2 = Stax2WriterAdapter.wrapIfNecessary(xMLStreamWriter);
        return new Stax2EventWriterImpl(xMLStreamWriter2);
    }

    @Override
    public XMLStreamWriter2 createXMLStreamWriter(Writer writer, String string) throws XMLStreamException {
        return this.createSW(null, writer, string, false);
    }

    @Override
    public void configureForXmlConformance() {
        this._config.configureForXmlConformance();
    }

    @Override
    public void configureForRobustness() {
        this._config.configureForRobustness();
    }

    @Override
    public void configureForSpeed() {
        this._config.configureForSpeed();
    }

    private XMLStreamWriter2 createSW(OutputStream outputStream, Writer writer, String string, boolean bl2) throws XMLStreamException {
        WNameTable wNameTable;
        XmlWriter xmlWriter;
        WriterConfig writerConfig = this._config.createNonShared();
        if (bl2) {
            writerConfig.doAutoCloseOutput(true);
        }
        if (writer == null) {
            if (string == null) {
                string = "UTF-8";
            } else if (string != "UTF-8" && string != "ISO-8859-1" && string != "US-ASCII") {
                string = CharsetNames.normalize(string);
            }
            writerConfig.setActualEncodingIfNotSet(string);
            try {
                if (string == "UTF-8") {
                    xmlWriter = new Utf8XmlWriter(writerConfig, outputStream);
                    wNameTable = this._config.getUtf8Symbols(xmlWriter);
                }
                if (string == "ISO-8859-1") {
                    xmlWriter = new Latin1XmlWriter(writerConfig, outputStream);
                    wNameTable = this._config.getLatin1Symbols(xmlWriter);
                }
                if (string == "US-ASCII") {
                    xmlWriter = new AsciiXmlWriter(writerConfig, outputStream);
                    wNameTable = this._config.getAsciiSymbols(xmlWriter);
                }
                writer = new OutputStreamWriter(outputStream, string);
                xmlWriter = new CharXmlWriter(writerConfig, writer);
                wNameTable = this._config.getCharSymbols(xmlWriter);
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        } else {
            if (string == null) {
                string = CharsetNames.findEncodingFor(writer);
            }
            if (string != null) {
                writerConfig.setActualEncodingIfNotSet(string);
            }
            xmlWriter = new CharXmlWriter(writerConfig, writer);
            wNameTable = this._config.getCharSymbols(xmlWriter);
        }
        if (writerConfig.willRepairNamespaces()) {
            return new RepairingStreamWriter(writerConfig, xmlWriter, wNameTable);
        }
        return new NonRepairingStreamWriter(writerConfig, xmlWriter, wNameTable);
    }

    private XMLStreamWriter2 createSW(Result result) throws XMLStreamException {
        boolean bl2;
        Result result2;
        OutputStream outputStream = null;
        Writer writer = null;
        String string = null;
        String string2 = null;
        if (result instanceof Stax2Result) {
            result2 = (Stax2Result)result;
            try {
                outputStream = ((Stax2Result)result2).constructOutputStream();
                if (outputStream == null) {
                    writer = ((Stax2Result)result2).constructWriter();
                }
            }
            catch (IOException iOException) {
                throw new StreamExceptionBase(iOException);
            }
            bl2 = true;
        } else if (result instanceof StreamResult) {
            result2 = (StreamResult)result;
            string2 = ((StreamResult)result2).getSystemId();
            outputStream = ((StreamResult)result2).getOutputStream();
            if (outputStream == null) {
                writer = ((StreamResult)result2).getWriter();
            }
            bl2 = false;
        } else if (result instanceof SAXResult) {
            result2 = (SAXResult)result;
            string2 = ((SAXResult)result2).getSystemId();
            if (string2 == null || string2.length() == 0) {
                throw new StreamExceptionBase("Can not create a stream writer for a SAXResult that does not have System Id (support for using SAX input source not implemented)");
            }
            bl2 = true;
        } else {
            if (result instanceof DOMResult) {
                return DOMWriterImpl.createFrom(this._config.createNonShared(), (DOMResult)result);
            }
            throw new IllegalArgumentException("Can not create XMLStreamWriter for Result type " + result.getClass() + " (unrecognized type)");
        }
        if (outputStream != null) {
            return this.createSW(outputStream, null, string, bl2);
        }
        if (writer != null) {
            return this.createSW(null, writer, string, bl2);
        }
        if (string2 != null && string2.length() > 0) {
            bl2 = true;
            try {
                outputStream = URLUtil.outputStreamFromURL(URLUtil.urlFromSystemId(string2));
            }
            catch (IOException iOException) {
                throw new IoStreamException(iOException);
            }
            return this.createSW(outputStream, null, string, bl2);
        }
        throw new StreamExceptionBase("Can not create XMLStreamWriter for passed-in Result -- neither writer, output stream nor system id (to create one) was accessible");
    }
}

