/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.ReaderConfig;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.typed.CharArrayBase64Decoder;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.typed.Base64Variant;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.typed.TypedArrayDecoder;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.typed.TypedXMLStreamException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class TextBuilder {
    static final char[] sNoChars = new char[0];
    static final int DEF_INITIAL_BUFFER_SIZE = 500;
    static final int MAX_SEGMENT_LENGTH = 262144;
    static final int INT_SPACE = 32;
    private final ReaderConfig _config;
    private ArrayList<char[]> _segments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;
    private int _resultLen;
    private char[] _decodeBuffer;
    private int _decodePtr;
    private int _decodeEnd;
    private boolean _isIndentation = false;
    public static final int MAX_INDENT_SPACES = 32;
    public static final int MAX_INDENT_TABS = 8;
    private static final String sIndSpaces = "\n                                 ";
    private static final char[] sIndSpacesArray = "\n                                 ".toCharArray();
    private static final String[] sIndSpacesStrings = new String[sIndSpacesArray.length];
    private static final String sIndTabs = "\n\t\t\t\t\t\t\t\t\t";
    private static final char[] sIndTabsArray = "\n\t\t\t\t\t\t\t\t\t".toCharArray();
    private static final String[] sIndTabsStrings = new String[sIndTabsArray.length];

    private TextBuilder(ReaderConfig readerConfig) {
        this._config = readerConfig;
    }

    public static TextBuilder createRecyclableBuffer(ReaderConfig readerConfig) {
        return new TextBuilder(readerConfig);
    }

    public void recycle(boolean bl2) {
        if (this._config != null && this._currentSegment != null) {
            if (bl2) {
                this._resultString = null;
                this._resultArray = null;
            } else if (this._segmentSize + this._currentSize > 0) {
                return;
            }
            if (this._segments != null && this._segments.size() > 0) {
                this._segments.clear();
                this._segmentSize = 0;
            }
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._config.freeMediumCBuffer(cArray);
        }
    }

    public char[] resetWithEmpty() {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 0;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(0);
        }
        return this._currentSegment;
    }

    public void resetWithIndentation(int n2, char c2) {
        String string;
        int n3;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = -1;
        this._isIndentation = true;
        this._resultLen = n3 = n2 + 1;
        if (c2 == '\t') {
            this._resultArray = sIndTabsArray;
            string = sIndTabsStrings[n2];
            if (string == null) {
                TextBuilder.sIndTabsStrings[n2] = string = sIndTabs.substring(0, n3);
            }
        } else {
            this._resultArray = sIndSpacesArray;
            string = sIndSpacesStrings[n2];
            if (string == null) {
                TextBuilder.sIndSpacesStrings[n2] = string = sIndSpaces.substring(0, n3);
            }
        }
        this._resultString = string;
    }

    public void resetWithChar(char c2) {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 1;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(1);
        }
        this._currentSegment[0] = c2;
    }

    public void resetWithSurrogate(int n2) {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 2;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(2);
        }
        this._currentSegment[0] = (char)(0xD800 | n2 >> 10);
        this._currentSegment[1] = (char)(0xDC00 | n2 & 0x3FF);
    }

    public char[] getBufferWithoutReset() {
        return this._currentSegment;
    }

    public int size() {
        int n2 = this._currentSize;
        if (n2 < 0) {
            return this._resultLen;
        }
        return n2 + this._segmentSize;
    }

    public char[] getTextBuffer() {
        if (this._segments == null || this._segments.size() == 0) {
            if (this._resultArray != null) {
                return this._resultArray;
            }
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else {
                int n2 = this._segmentSize;
                int n3 = this._currentSize;
                if (n2 == 0) {
                    this._resultString = n3 == 0 ? "" : new String(this._currentSegment, 0, n3);
                    return this._resultString;
                }
                StringBuilder stringBuilder = new StringBuilder(n2 + n3);
                if (this._segments != null) {
                    int n4 = this._segments.size();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        char[] cArray = this._segments.get(i2);
                        stringBuilder.append(cArray, 0, cArray.length);
                    }
                }
                stringBuilder.append(this._currentSegment, 0, n3);
                this._resultString = stringBuilder.toString();
            }
        }
        return this._resultString;
    }

    public char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (cArray == null) {
            this._resultArray = cArray = this.buildResultArray();
        }
        return cArray;
    }

    public int contentsToArray(int n2, char[] cArray, int n3, int n4) {
        int n5;
        int n6 = 0;
        if (this._segments != null) {
            int n7 = this._segments.size();
            for (n5 = 0; n5 < n7; ++n5) {
                char[] cArray2 = this._segments.get(n5);
                int n8 = cArray2.length;
                int n9 = n8 - n2;
                if (n9 < 1) {
                    n2 -= n8;
                    continue;
                }
                if (n9 >= n4) {
                    System.arraycopy(cArray2, n2, cArray, n3, n4);
                    return n6 + n4;
                }
                System.arraycopy(cArray2, n2, cArray, n3, n9);
                n6 += n9;
                n3 += n9;
                n4 -= n9;
                n2 = 0;
            }
        }
        if (n4 > 0) {
            n5 = this._currentSize - n2;
            if (n4 > n5) {
                n4 = n5;
            }
            if (n4 > 0) {
                System.arraycopy(this._currentSegment, n2, cArray, n3, n4);
                n6 += n4;
            }
        }
        return n6;
    }

    public int rawContentsTo(Writer writer) throws IOException {
        if (this._resultArray != null) {
            writer.write(this._resultArray);
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            writer.write(this._resultString);
            return this._resultString.length();
        }
        int n2 = 0;
        if (this._segments != null) {
            int n3 = this._segments.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                char[] cArray = this._segments.get(i2);
                writer.write(cArray);
                n2 += cArray.length;
            }
        }
        if (this._currentSize > 0) {
            writer.write(this._currentSegment, 0, this._currentSize);
            n2 += this._currentSize;
        }
        return n2;
    }

    public boolean isAllWhitespace() {
        int n2;
        if (this._isIndentation) {
            return true;
        }
        if (this._segments != null) {
            n2 = this._segments.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                char[] cArray = this._segments.get(i2);
                int n3 = cArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (cArray[i3] <= ' ') continue;
                    return false;
                }
            }
        }
        char[] cArray = this._currentSegment;
        int n4 = this._currentSize;
        for (n2 = 0; n2 < n4; ++n2) {
            if (cArray[n2] <= ' ') continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String string) {
        int n2 = this._segments == null ? 0 : this._segments.size();
        int n3 = string.length() - 1;
        char[] cArray = this._currentSegment;
        int n4 = this._currentSize - 1;
        while (n3 >= 0) {
            if (string.charAt(n3) != cArray[n4]) {
                return false;
            }
            if (--n3 == 0) break;
            if (--n4 >= 0) continue;
            if (--n2 < 0) {
                return false;
            }
            cArray = this._segments.get(n2);
            n4 = cArray.length - 1;
        }
        return true;
    }

    public boolean equalsString(String string) {
        int n2 = string.length();
        if (n2 != this.size()) {
            return false;
        }
        char[] cArray = this._segments == null || this._segments.size() == 0 ? this._currentSegment : this.contentsAsArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public void fireSaxCharacterEvents(ContentHandler contentHandler) throws SAXException {
        if (this._resultArray != null) {
            contentHandler.characters(this._resultArray, 0, this._resultLen);
        } else {
            if (this._segments != null) {
                int n2 = this._segments.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char[] cArray = this._segments.get(i2);
                    contentHandler.characters(cArray, 0, cArray.length);
                }
            }
            if (this._currentSize > 0) {
                contentHandler.characters(this._currentSegment, 0, this._currentSize);
            }
        }
    }

    public void fireSaxSpaceEvents(ContentHandler contentHandler) throws SAXException {
        if (this._resultArray != null) {
            contentHandler.ignorableWhitespace(this._resultArray, 0, this._resultLen);
        } else {
            if (this._segments != null) {
                int n2 = this._segments.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char[] cArray = this._segments.get(i2);
                    contentHandler.ignorableWhitespace(cArray, 0, cArray.length);
                }
            }
            if (this._currentSize > 0) {
                contentHandler.ignorableWhitespace(this._currentSegment, 0, this._currentSize);
            }
        }
    }

    public void fireSaxCommentEvent(LexicalHandler lexicalHandler) throws SAXException {
        if (this._resultArray != null) {
            lexicalHandler.comment(this._resultArray, 0, this._resultLen);
        } else if (this._segments != null && this._segments.size() > 0) {
            char[] cArray = this.contentsAsArray();
            lexicalHandler.comment(cArray, 0, cArray.length);
        } else {
            lexicalHandler.comment(this._currentSegment, 0, this._currentSize);
        }
    }

    public void append(char c2) {
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.expand(1);
        }
        cArray[this._currentSize++] = c2;
    }

    public void appendSurrogate(int n2) {
        this.append((char)(0xD800 | n2 >> 10));
        this.append((char)(0xDC00 | n2 & 0x3FF));
    }

    public void append(char[] cArray, int n2, int n3) {
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n4 = cArray2.length - this._currentSize;
        if (n4 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n3);
            this._currentSize += n3;
        } else {
            if (n4 > 0) {
                System.arraycopy(cArray, n2, cArray2, this._currentSize, n4);
                n2 += n4;
                n3 -= n4;
            }
            this.expand(n3);
            System.arraycopy(cArray, n2, this._currentSegment, 0, n3);
            this._currentSize = n3;
        }
    }

    public void append(String string) {
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n2 = cArray.length - this._currentSize;
        int n3 = string.length();
        if (n2 >= n3) {
            string.getChars(0, n3, cArray, this._currentSize);
            this._currentSize += n3;
        } else {
            if (n2 > 0) {
                string.getChars(0, n2, cArray, this._currentSize);
                n3 -= n2;
            }
            this.expand(n3);
            string.getChars(n2, n2 + n3, this._currentSegment, 0);
            this._currentSize = n3;
        }
    }

    public int getCurrentLength() {
        return this._currentSize;
    }

    public void setCurrentLength(int n2) {
        this._currentSize = n2;
    }

    public char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._segments.add(this._currentSegment);
        int n2 = this._currentSegment.length;
        this._segmentSize += n2;
        char[] cArray = new char[this.calcNewSize(n2)];
        this._currentSize = 0;
        this._currentSegment = cArray;
        return cArray;
    }

    private int calcNewSize(int n2) {
        int n3 = n2 < 8000 ? n2 : n2 >> 1;
        int n4 = n2 + n3;
        return Math.min(n4, 262144);
    }

    public int decodeElements(TypedArrayDecoder typedArrayDecoder, boolean bl2) throws TypedXMLStreamException {
        if (bl2) {
            this.resetForDecode();
        }
        int n2 = this._decodePtr;
        char[] cArray = this._decodeBuffer;
        int n3 = 0;
        int n4 = n2;
        try {
            int n5 = this._decodeEnd;
            block2: while (n2 < n5) {
                int n6;
                while (cArray[n2] <= ' ') {
                    if (++n2 < n5) continue;
                    break block2;
                }
                n4 = n2++;
                while (n2 < n5 && cArray[n2] > ' ') {
                    ++n2;
                }
                ++n3;
                if (typedArrayDecoder.decodeValue(cArray, n4, n6 = n2++)) break;
                this._decodePtr = n2;
            }
            this._decodePtr = n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = new String(cArray, n4, n2 - n4 - 1);
            throw new TypedXMLStreamException(string, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        return n3;
    }

    public void resetForBinaryDecode(Base64Variant base64Variant, CharArrayBase64Decoder charArrayBase64Decoder, boolean bl2) {
        if ((this._segments == null || this._segments.size() == 0) && this._isIndentation) {
            charArrayBase64Decoder.init(base64Variant, bl2, this._resultArray, 0, this._resultArray.length, null);
            return;
        }
        charArrayBase64Decoder.init(base64Variant, bl2, this._currentSegment, 0, this._currentSize, this._segments);
    }

    private final void resetForDecode() {
        this._decodePtr = 0;
        if (this._segments == null || this._segments.size() == 0) {
            if (this._isIndentation) {
                this._decodeBuffer = this._resultArray;
                this._decodeEnd = this._resultArray.length;
            } else {
                this._decodeBuffer = this._currentSegment;
                this._decodeEnd = this._currentSize;
            }
        } else {
            this._decodeBuffer = this.contentsAsArray();
            this._decodeEnd = this._decodeBuffer.length;
        }
    }

    public String toString() {
        this._resultString = null;
        this._resultArray = null;
        return this.contentsAsString();
    }

    private final char[] allocBuffer(int n2) {
        int n3 = Math.max(500, n2);
        char[] cArray = null;
        if (this._config != null && (cArray = this._config.allocMediumCBuffer(n3)) != null) {
            return cArray;
        }
        return new char[n3];
    }

    private void expand(int n2) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._segments.add(cArray);
        int n3 = cArray.length;
        this._segmentSize += n3;
        int n4 = Math.max(n2, this.calcNewSize(n3));
        cArray = new char[n4];
        this._currentSize = 0;
        this._currentSegment = cArray;
    }

    private char[] buildResultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        int n2 = this.size();
        if (n2 < 1) {
            return sNoChars;
        }
        int n3 = 0;
        char[] cArray = new char[n2];
        if (this._segments != null) {
            int n4 = this._segments.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                char[] cArray2 = this._segments.get(i2);
                int n5 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n3, n5);
                n3 += n5;
            }
        }
        System.arraycopy(this._currentSegment, 0, cArray, n3, this._currentSize);
        return cArray;
    }
}

