/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core;

import java.io.Serializable;
import java.nio.charset.Charset;

public class JsonLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_CONTENT_SNIPPET = 500;
    public static final JsonLocation NA = new JsonLocation(null, -1L, -1L, -1, -1);
    protected final long _totalBytes;
    protected final long _totalChars;
    protected final int _lineNr;
    protected final int _columnNr;
    final transient Object _sourceRef;

    public JsonLocation(Object object, long l2, int n2, int n3) {
        this(object, -1L, l2, n2, n3);
    }

    public JsonLocation(Object object, long l2, long l3, int n2, int n3) {
        this._sourceRef = object;
        this._totalBytes = l2;
        this._totalChars = l3;
        this._lineNr = n2;
        this._columnNr = n3;
    }

    public Object getSourceRef() {
        return this._sourceRef;
    }

    public int getLineNr() {
        return this._lineNr;
    }

    public int getColumnNr() {
        return this._columnNr;
    }

    public long getCharOffset() {
        return this._totalChars;
    }

    public long getByteOffset() {
        return this._totalBytes;
    }

    public String sourceDescription() {
        return this._appendSourceDesc(new StringBuilder(100)).toString();
    }

    public int hashCode() {
        int n2 = this._sourceRef == null ? 1 : this._sourceRef.hashCode();
        n2 ^= this._lineNr;
        n2 += this._columnNr;
        n2 ^= (int)this._totalChars;
        return n2 += (int)this._totalBytes;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonLocation)) {
            return false;
        }
        JsonLocation jsonLocation = (JsonLocation)object;
        if (this._sourceRef == null ? jsonLocation._sourceRef != null : !this._sourceRef.equals(jsonLocation._sourceRef)) {
            return false;
        }
        return this._lineNr == jsonLocation._lineNr && this._columnNr == jsonLocation._columnNr && this._totalChars == jsonLocation._totalChars && this.getByteOffset() == jsonLocation.getByteOffset();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("[Source: ");
        this._appendSourceDesc(stringBuilder);
        stringBuilder.append("; line: ");
        stringBuilder.append(this._lineNr);
        stringBuilder.append(", column: ");
        stringBuilder.append(this._columnNr);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected StringBuilder _appendSourceDesc(StringBuilder stringBuilder) {
        int n2;
        Object object = this._sourceRef;
        if (object == null) {
            stringBuilder.append("UNKNOWN");
            return stringBuilder;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String string = clazz.getName();
        if (string.startsWith("java.")) {
            string = clazz.getSimpleName();
        } else if (object instanceof byte[]) {
            string = "byte[]";
        } else if (object instanceof char[]) {
            string = "char[]";
        }
        stringBuilder.append('(').append(string).append(')');
        String string2 = " chars";
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            n2 = charSequence.length();
            n2 -= this._append(stringBuilder, charSequence.subSequence(0, Math.min(n2, 500)).toString());
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            n2 = cArray.length;
            n2 -= this._append(stringBuilder, new String(cArray, 0, Math.min(n2, 500)));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n3 = Math.min(byArray.length, 500);
            this._append(stringBuilder, new String(byArray, 0, n3, Charset.forName("UTF-8")));
            n2 = byArray.length - n3;
            string2 = " bytes";
        } else {
            n2 = 0;
        }
        if (n2 > 0) {
            stringBuilder.append("[truncated ").append(n2).append(string2).append(']');
        }
        return stringBuilder;
    }

    private int _append(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"').append(string).append('\"');
        return string.length();
    }
}

