/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.json;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.Base64Variant;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonLocation;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParseException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.ObjectCodec;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.StreamReadCapability;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.base.ParserBase;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.CharTypes;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.IOContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.json.JsonReadFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.sym.ByteQuadsCanonicalizer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.ByteArrayBuilder;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.JacksonFeatureSet;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;

public class UTF8DataInputJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    private static final int FEAT_MASK_LEADING_ZEROS = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS.getMask();
    private static final int FEAT_MASK_NON_NUM_NUMBERS = JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.getMask();
    private static final int FEAT_MASK_ALLOW_MISSING = JsonParser.Feature.ALLOW_MISSING_VALUES.getMask();
    private static final int FEAT_MASK_ALLOW_SINGLE_QUOTES = JsonParser.Feature.ALLOW_SINGLE_QUOTES.getMask();
    private static final int FEAT_MASK_ALLOW_UNQUOTED_NAMES = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
    private static final int FEAT_MASK_ALLOW_JAVA_COMMENTS = JsonParser.Feature.ALLOW_COMMENTS.getMask();
    private static final int FEAT_MASK_ALLOW_YAML_COMMENTS = JsonParser.Feature.ALLOW_YAML_COMMENTS.getMask();
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected ObjectCodec _objectCodec;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete;
    private int _quad1;
    protected DataInput _inputData;
    protected int _nextByte = -1;

    public UTF8DataInputJsonParser(IOContext iOContext, int n2, DataInput dataInput, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n3) {
        super(iOContext, n2);
        this._objectCodec = objectCodec;
        this._symbols = byteQuadsCanonicalizer;
        this._inputData = dataInput;
        this._nextByte = n3;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return JSON_READ_CAPABILITIES;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) throws IOException {
        return 0;
    }

    @Override
    public Object getInputSource() {
        return this._inputData;
    }

    @Override
    protected void _closeInput() throws IOException {
    }

    @Override
    protected void _releaseBuffers() throws IOException {
        super._releaseBuffers();
        this._symbols.release();
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(this._currToken);
    }

    @Override
    public int getText(Writer writer) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            String string = this._parsingContext.getCurrentName();
            writer.write(string);
            return string.length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return this._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            writer.write(cArray);
            return cArray.length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public int getValueAsInt() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n2) throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 1) == 0) {
                if (this._numTypesValid == 0) {
                    return this._parseIntValue();
                }
                if ((this._numTypesValid & 1) == 0) {
                    this.convertNumberToInt();
                }
            }
            return this._numberInt;
        }
        return super.getValueAsInt(n2);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.size();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName().length();
        }
        if (this._currToken != null) {
            if (this._currToken.isNumeric()) {
                return this._textBuffer.size();
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n2 = this._readBinary(base64Variant, outputStream, byArray);
            return n2;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            int n5;
            if ((n5 = this._inputData.readUnsignedByte()) <= 32) {
                continue;
            }
            int n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n5 == 34) break;
                n6 = this._decodeBase64Escape(base64Variant, n5, 0);
                if (n6 < 0) continue;
            }
            if (n2 > n3) {
                n4 += n2;
                outputStream.write(byArray, 0, n2);
                n2 = 0;
            }
            int n7 = n6;
            n5 = this._inputData.readUnsignedByte();
            n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                n6 = this._decodeBase64Escape(base64Variant, n5, 1);
            }
            n7 = n7 << 6 | n6;
            n5 = this._inputData.readUnsignedByte();
            n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n6 != -2) {
                    if (n5 == 34) {
                        byArray[n2++] = (byte)(n7 >>= 4);
                        if (!base64Variant.usesPadding()) break;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 2);
                }
                if (n6 == -2) {
                    n5 = this._inputData.readUnsignedByte();
                    if (!(base64Variant.usesPaddingChar(n5) || n5 == 92 && this._decodeBase64Escape(base64Variant, n5, 3) == -2)) {
                        throw this.reportInvalidBase64Char(base64Variant, n5, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n2++] = (byte)(n7 >>= 4);
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            n5 = this._inputData.readUnsignedByte();
            n6 = base64Variant.decodeBase64Char(n5);
            if (n6 < 0) {
                if (n6 != -2) {
                    if (n5 == 34) {
                        byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                        byArray[n2++] = (byte)n7;
                        if (!base64Variant.usesPadding()) break;
                        this._handleBase64MissingPadding(base64Variant);
                        break;
                    }
                    n6 = this._decodeBase64Escape(base64Variant, n5, 3);
                }
                if (n6 == -2) {
                    byArray[n2++] = (byte)((n7 >>= 2) >> 8);
                    byArray[n2++] = (byte)n7;
                    continue;
                }
            }
            n7 = n7 << 6 | n6;
            byArray[n2++] = (byte)(n7 >> 16);
            byArray[n2++] = (byte)(n7 >> 8);
            byArray[n2++] = (byte)n7;
        }
        this._tokenIncomplete = false;
        if (n2 > 0) {
            n4 += n2;
            outputStream.write(byArray, 0, n2);
        }
        return n4;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        JsonToken jsonToken;
        int n2;
        if (this._closed) {
            return null;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        this._tokenInputRow = this._currInputRow;
        if (n2 == 93 || n2 == 125) {
            this._closeScope(n2);
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 == 93 || n2 == 125)) {
                this._closeScope(n2);
                return this._currToken;
            }
        }
        if (!this._parsingContext.inObject()) {
            return this._nextTokenNotInObject(n2);
        }
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipColon();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n2);
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken _nextTokenNotInObject(int n2) throws IOException {
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseNegNumber();
                return this._currToken;
            }
            case 46: {
                this._currToken = this._parseFloatThatStartsWithPeriod();
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parsePosNumber(n2);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n2);
        return this._currToken;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public void finishToken() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    @Override
    public String nextFieldName() throws IOException {
        JsonToken jsonToken;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        int n2 = this._skipWS();
        this._binaryValue = null;
        this._tokenInputRow = this._currInputRow;
        if (n2 == 93 || n2 == 125) {
            this._closeScope(n2);
            return null;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
            }
            n2 = this._skipWS();
            if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 == 93 || n2 == 125)) {
                this._closeScope(n2);
                return null;
            }
        }
        if (!this._parsingContext.inObject()) {
            this._nextTokenNotInObject(n2);
            return null;
        }
        String string = this._parseName(n2);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipColon();
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n2) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 46: {
                jsonToken = this._parseFloatThatStartsWithPeriod();
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n2);
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    @Override
    public String nextTextValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    return this._finishAndReturnString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n2) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n2;
    }

    @Override
    public long nextLongValue(long l2) throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l2;
    }

    @Override
    public Boolean nextBooleanValue() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    protected final JsonToken _parseFloatThatStartsWithPeriod() throws IOException {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleUnexpectedValue(46);
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        return this._parseFloat(cArray, 0, 46, false, 0);
    }

    protected JsonToken _parsePosNumber(int n2) throws IOException {
        int n3;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (n2 == 48) {
            n2 = this._handleLeadingZeroes();
            if (n2 <= 57 && n2 >= 48) {
                n3 = 0;
            } else {
                cArray[0] = 48;
                n3 = 1;
            }
        } else {
            cArray[0] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
            n3 = 1;
        }
        int n4 = n3;
        while (n2 <= 57 && n2 >= 48) {
            ++n4;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 46 || n2 == 101 || n2 == 69) {
            return this._parseFloat(cArray, n3, n2, false, n4);
        }
        this._textBuffer.setCurrentLength(n3);
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace();
        } else {
            this._nextByte = n2;
        }
        return this.resetInt(false, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonToken _parseNegNumber() throws IOException {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        cArray[n2++] = 45;
        int n3 = this._inputData.readUnsignedByte();
        cArray[n2++] = (char)n3;
        if (n3 <= 48) {
            if (n3 != 48) return this._handleInvalidNumberStart(n3, true);
            n3 = this._handleLeadingZeroes();
        } else {
            if (n3 > 57) {
                return this._handleInvalidNumberStart(n3, true);
            }
            n3 = this._inputData.readUnsignedByte();
        }
        int n4 = 1;
        while (n3 <= 57 && n3 >= 48) {
            ++n4;
            cArray[n2++] = (char)n3;
            n3 = this._inputData.readUnsignedByte();
        }
        if (n3 == 46 || n3 == 101 || n3 == 69) {
            return this._parseFloat(cArray, n2, n3, true, n4);
        }
        this._textBuffer.setCurrentLength(n2);
        this._nextByte = n3;
        if (!this._parsingContext.inRoot()) return this.resetInt(true, n4);
        this._verifyRootSpace();
        return this.resetInt(true, n4);
    }

    private final int _handleLeadingZeroes() throws IOException {
        int n2 = this._inputData.readUnsignedByte();
        if (n2 < 48 || n2 > 57) {
            return n2;
        }
        if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        while (n2 == 48) {
            n2 = this._inputData.readUnsignedByte();
        }
        return n2;
    }

    private final JsonToken _parseFloat(char[] cArray, int n2, int n3, boolean bl2, int n4) throws IOException {
        int n5 = 0;
        if (n3 == 46) {
            cArray[n2++] = (char)n3;
            while ((n3 = this._inputData.readUnsignedByte()) >= 48 && n3 <= 57) {
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
            }
        }
        int n6 = 0;
        if (n3 == 101 || n3 == 69) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            n3 = this._inputData.readUnsignedByte();
            if (n3 == 45 || n3 == 43) {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
            }
            while (n3 <= 57 && n3 >= 48) {
                ++n6;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
            }
            if (n6 == 0) {
                this.reportUnexpectedNumberChar(n3, "Exponent indicator not followed by a digit");
            }
        }
        this._nextByte = n3;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace();
        }
        this._textBuffer.setCurrentLength(n2);
        return this.resetFloat(bl2, n4, n5, n6);
    }

    private final void _verifyRootSpace() throws IOException {
        int n2 = this._nextByte;
        if (n2 <= 32) {
            this._nextByte = -1;
            if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            return;
        }
        this._reportMissingRootWS(n2);
    }

    protected final String _parseName(int n2) throws IOException {
        if (n2 != 34) {
            return this._handleOddName(n2);
        }
        int[] nArray = _icLatin1;
        int n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] == 0) {
            n2 = this._inputData.readUnsignedByte();
            if (nArray[n2] == 0) {
                n3 = n3 << 8 | n2;
                n2 = this._inputData.readUnsignedByte();
                if (nArray[n2] == 0) {
                    n3 = n3 << 8 | n2;
                    n2 = this._inputData.readUnsignedByte();
                    if (nArray[n2] == 0) {
                        n3 = n3 << 8 | n2;
                        n2 = this._inputData.readUnsignedByte();
                        if (nArray[n2] == 0) {
                            this._quad1 = n3;
                            return this._parseMediumName(n2);
                        }
                        if (n2 == 34) {
                            return this.findName(n3, 4);
                        }
                        return this.parseName(n3, n2, 4);
                    }
                    if (n2 == 34) {
                        return this.findName(n3, 3);
                    }
                    return this.parseName(n3, n2, 3);
                }
                if (n2 == 34) {
                    return this.findName(n3, 2);
                }
                return this.parseName(n3, n2, 2);
            }
            if (n2 == 34) {
                return this.findName(n3, 1);
            }
            return this.parseName(n3, n2, 1);
        }
        if (n3 == 34) {
            return "";
        }
        return this.parseName(0, n3, 0);
    }

    private final String _parseMediumName(int n2) throws IOException {
        int[] nArray = _icLatin1;
        int n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 1);
            }
            return this.parseName(this._quad1, n2, n3, 1);
        }
        n2 = n2 << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 2);
            }
            return this.parseName(this._quad1, n2, n3, 2);
        }
        n2 = n2 << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 3);
            }
            return this.parseName(this._quad1, n2, n3, 3);
        }
        n2 = n2 << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 4);
            }
            return this.parseName(this._quad1, n2, n3, 4);
        }
        return this._parseMediumName2(n3, n2);
    }

    private final String _parseMediumName2(int n2, int n3) throws IOException {
        int[] nArray = _icLatin1;
        int n4 = this._inputData.readUnsignedByte();
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 1);
            }
            return this.parseName(this._quad1, n3, n2, n4, 1);
        }
        n2 = n2 << 8 | n4;
        n4 = this._inputData.readUnsignedByte();
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 2);
            }
            return this.parseName(this._quad1, n3, n2, n4, 2);
        }
        n2 = n2 << 8 | n4;
        n4 = this._inputData.readUnsignedByte();
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 3);
            }
            return this.parseName(this._quad1, n3, n2, n4, 3);
        }
        n2 = n2 << 8 | n4;
        n4 = this._inputData.readUnsignedByte();
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 4);
            }
            return this.parseName(this._quad1, n3, n2, n4, 4);
        }
        return this._parseLongName(n4, n3, n2);
    }

    private final String _parseLongName(int n2, int n3, int n4) throws IOException {
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = n3;
        this._quadBuffer[2] = n4;
        int[] nArray = _icLatin1;
        int n5 = 3;
        while (true) {
            int n6;
            if (nArray[n6 = this._inputData.readUnsignedByte()] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 1);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 1);
            }
            n2 = n2 << 8 | n6;
            n6 = this._inputData.readUnsignedByte();
            if (nArray[n6] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 2);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 2);
            }
            n2 = n2 << 8 | n6;
            n6 = this._inputData.readUnsignedByte();
            if (nArray[n6] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 3);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 3);
            }
            n2 = n2 << 8 | n6;
            n6 = this._inputData.readUnsignedByte();
            if (nArray[n6] != 0) {
                if (n6 == 34) {
                    return this.findName(this._quadBuffer, n5, n2, 4);
                }
                return this.parseEscapedName(this._quadBuffer, n5, n2, n6, 4);
            }
            if (n5 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8DataInputJsonParser._growArrayBy(this._quadBuffer, n5);
            }
            this._quadBuffer[n5++] = n2;
            n2 = n6;
        }
    }

    private final String parseName(int n2, int n3, int n4) throws IOException {
        return this.parseEscapedName(this._quadBuffer, 0, n2, n3, n4);
    }

    private final String parseName(int n2, int n3, int n4, int n5) throws IOException {
        this._quadBuffer[0] = n2;
        return this.parseEscapedName(this._quadBuffer, 1, n3, n4, n5);
    }

    private final String parseName(int n2, int n3, int n4, int n5, int n6) throws IOException {
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        return this.parseEscapedName(this._quadBuffer, 2, n4, n5, n6);
    }

    protected final String parseEscapedName(int[] nArray, int n2, int n3, int n4, int n5) throws IOException {
        String string;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (nArray2[n4] != 0) {
                if (n4 == 34) break;
                if (n4 != 92) {
                    this._throwUnquotedSpace(n4, "name");
                } else {
                    n4 = this._decodeEscaped();
                }
                if (n4 > 127) {
                    if (n5 >= 4) {
                        if (n2 >= nArray.length) {
                            nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n5 = 0;
                    }
                    if (n4 < 2048) {
                        n3 = n3 << 8 | (0xC0 | n4 >> 6);
                        ++n5;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n4 >> 12);
                        if (++n5 >= 4) {
                            if (n2 >= nArray.length) {
                                nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n5 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n4 >> 6 & 0x3F);
                        ++n5;
                    }
                    n4 = 0x80 | n4 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n3 = n3 << 8 | n4;
            } else {
                if (n2 >= nArray.length) {
                    nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n2++] = n3;
                n3 = n4;
                n5 = 1;
            }
            n4 = this._inputData.readUnsignedByte();
        }
        if (n5 > 0) {
            if (n2 >= nArray.length) {
                nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n2++] = UTF8DataInputJsonParser.pad(n3, n5);
        }
        if ((string = this._symbols.findName(nArray, n2)) == null) {
            string = this.addName(nArray, n2, n5);
        }
        return string;
    }

    protected String _handleOddName(int n2) throws IOException {
        String string;
        int[] nArray;
        if (n2 == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            char c2 = (char)this._decodeCharForError(n2);
            this._reportUnexpectedChar(c2, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
                continue;
            }
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser._growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n3++] = n4;
            n4 = n2;
            n5 = 1;
        } while (nArray[n2 = this._inputData.readUnsignedByte()] == 0);
        this._nextByte = n2;
        if (n5 > 0) {
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser._growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n3++] = n4;
        }
        if ((string = this._symbols.findName(nArray2, n3)) == null) {
            string = this.addName(nArray2, n3, n5);
        }
        return string;
    }

    protected String _parseAposName() throws IOException {
        String string;
        int n2 = this._inputData.readUnsignedByte();
        if (n2 == 39) {
            return "";
        }
        int[] nArray = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = _icLatin1;
        while (n2 != 39) {
            if (n2 != 34 && nArray2[n2] != 0) {
                if (n2 != 92) {
                    this._throwUnquotedSpace(n2, "name");
                } else {
                    n2 = this._decodeEscaped();
                }
                if (n2 > 127) {
                    if (n5 >= 4) {
                        if (n3 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                        }
                        nArray[n3++] = n4;
                        n4 = 0;
                        n5 = 0;
                    }
                    if (n2 < 2048) {
                        n4 = n4 << 8 | (0xC0 | n2 >> 6);
                        ++n5;
                    } else {
                        n4 = n4 << 8 | (0xE0 | n2 >> 12);
                        if (++n5 >= 4) {
                            if (n3 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                            }
                            nArray[n3++] = n4;
                            n4 = 0;
                            n5 = 0;
                        }
                        n4 = n4 << 8 | (0x80 | n2 >> 6 & 0x3F);
                        ++n5;
                    }
                    n2 = 0x80 | n2 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                }
                nArray[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            n2 = this._inputData.readUnsignedByte();
        }
        if (n5 > 0) {
            if (n3 >= nArray.length) {
                this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
            }
            nArray[n3++] = UTF8DataInputJsonParser.pad(n4, n5);
        }
        if ((string = this._symbols.findName(nArray, n3)) == null) {
            string = this.addName(nArray, n3, n5);
        }
        return string;
    }

    private final String findName(int n2, int n3) throws JsonParseException {
        String string = this._symbols.findName(n2 = UTF8DataInputJsonParser.pad(n2, n3));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        return this.addName(this._quadBuffer, 1, n3);
    }

    private final String findName(int n2, int n3, int n4) throws JsonParseException {
        String string = this._symbols.findName(n2, n3 = UTF8DataInputJsonParser.pad(n3, n4));
        if (string != null) {
            return string;
        }
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        return this.addName(this._quadBuffer, 2, n4);
    }

    private final String findName(int n2, int n3, int n4, int n5) throws JsonParseException {
        String string = this._symbols.findName(n2, n3, n4 = UTF8DataInputJsonParser.pad(n4, n5));
        if (string != null) {
            return string;
        }
        int[] nArray = this._quadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = UTF8DataInputJsonParser.pad(n4, n5);
        return this.addName(nArray, 3, n5);
    }

    private final String findName(int[] nArray, int n2, int n3, int n4) throws JsonParseException {
        if (n2 >= nArray.length) {
            nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n2++] = UTF8DataInputJsonParser.pad(n3, n4);
        String string = this._symbols.findName(nArray, n2);
        if (string == null) {
            return this.addName(nArray, n2, n4);
        }
        return string;
    }

    private final String addName(int[] nArray, int n2, int n3) throws JsonParseException {
        int n4;
        int n5 = (n2 << 2) - 4 + n3;
        if (n3 < 4) {
            n4 = nArray[n2 - 1];
            nArray[n2 - 1] = n4 << (4 - n3 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = nArray[n7 >> 2];
            int n9 = n7 & 3;
            n8 = n8 >> (3 - n9 << 3) & 0xFF;
            ++n7;
            if (n8 > 127) {
                int n10;
                if ((n8 & 0xE0) == 192) {
                    n8 &= 0x1F;
                    n10 = 1;
                } else if ((n8 & 0xF0) == 224) {
                    n8 &= 0xF;
                    n10 = 2;
                } else if ((n8 & 0xF8) == 240) {
                    n8 &= 7;
                    n10 = 3;
                } else {
                    this._reportInvalidInitial(n8);
                    n8 = 1;
                    n10 = 1;
                }
                if (n7 + n10 > n5) {
                    this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                }
                int n11 = nArray[n7 >> 2];
                n9 = n7 & 3;
                ++n7;
                if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n11);
                }
                n8 = n8 << 6 | n11 & 0x3F;
                if (n10 > 1) {
                    n11 = nArray[n7 >> 2];
                    n9 = n7 & 3;
                    ++n7;
                    if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n11);
                    }
                    n8 = n8 << 6 | n11 & 0x3F;
                    if (n10 > 2) {
                        n11 = nArray[n7 >> 2];
                        n9 = n7 & 3;
                        ++n7;
                        if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n11 & 0xFF);
                        }
                        n8 = n8 << 6 | n11 & 0x3F;
                    }
                }
                if (n10 > 2) {
                    n8 -= 65536;
                    if (n6 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n6++] = (char)(55296 + (n8 >> 10));
                    n8 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n6++] = (char)n8;
        }
        String string = new String(cArray, 0, n6);
        if (n3 < 4) {
            nArray[n2 - 1] = n4;
        }
        return this._symbols.addName(string, nArray, n2);
    }

    @Override
    protected void _finishString() throws IOException {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = cArray.length;
        do {
            int n4;
            if (nArray[n4 = this._inputData.readUnsignedByte()] != 0) {
                if (n4 == 34) {
                    this._textBuffer.setCurrentLength(n2);
                    return;
                }
                this._finishString2(cArray, n2, n4);
                return;
            }
            cArray[n2++] = (char)n4;
        } while (n2 < n3);
        this._finishString2(cArray, n2, this._inputData.readUnsignedByte());
    }

    private String _finishAndReturnString() throws IOException {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = cArray.length;
        do {
            int n4;
            if (nArray[n4 = this._inputData.readUnsignedByte()] != 0) {
                if (n4 == 34) {
                    return this._textBuffer.setCurrentAndReturn(n2);
                }
                this._finishString2(cArray, n2, n4);
                return this._textBuffer.contentsAsString();
            }
            cArray[n2++] = (char)n4;
        } while (n2 < n3);
        this._finishString2(cArray, n2, this._inputData.readUnsignedByte());
        return this._textBuffer.contentsAsString();
    }

    private final void _finishString2(char[] cArray, int n2, int n3) throws IOException {
        int[] nArray = _icUTF8;
        int n4 = cArray.length;
        while (true) {
            if (nArray[n3] == 0) {
                if (n2 >= n4) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                    n4 = cArray.length;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
                continue;
            }
            if (n3 == 34) break;
            switch (nArray[n3]) {
                case 1: {
                    n3 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n3 = this._decodeUtf8_2(n3);
                    break;
                }
                case 3: {
                    n3 = this._decodeUtf8_3(n3);
                    break;
                }
                case 4: {
                    n3 = this._decodeUtf8_4(n3);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                        n4 = cArray.length;
                    }
                    cArray[n2++] = (char)(0xD800 | n3 >> 10);
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                        break;
                    }
                    this._reportInvalidChar(n3);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
                n4 = cArray.length;
            }
            cArray[n2++] = (char)n3;
            n3 = this._inputData.readUnsignedByte();
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected void _skipString() throws IOException {
        this._tokenIncomplete = false;
        int[] nArray = _icUTF8;
        block6: while (true) {
            int n2;
            if (nArray[n2 = this._inputData.readUnsignedByte()] == 0) {
                continue;
            }
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4();
                    continue block6;
                }
            }
            if (n2 < 32) {
                this._throwUnquotedSpace(n2, "string value");
                continue;
            }
            this._reportInvalidChar(n2);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n2) throws IOException {
        switch (n2) {
            case 93: {
                if (!this._parsingContext.inArray()) break;
            }
            case 44: {
                if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                    this._nextByte = n2;
                    return JsonToken.VALUE_NULL;
                }
            }
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 39: {
                if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) == 0) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                return this._handleInvalidNumberStart(this._inputData.readUnsignedByte(), false);
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            this._reportInvalidToken(n2, "" + (char)n2, this._validJsonTokenList());
        }
        this._reportUnexpectedChar(n2, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    protected JsonToken _handleApos() throws IOException {
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        block6: while (true) {
            int n4 = cArray.length;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
                n4 = cArray.length;
            }
            while ((n2 = this._inputData.readUnsignedByte()) != 39) {
                if (nArray[n2] == 0) {
                    cArray[n3++] = (char)n2;
                    if (n3 < n4) continue;
                    continue block6;
                }
                switch (nArray[n2]) {
                    case 1: {
                        n2 = this._decodeEscaped();
                        break;
                    }
                    case 2: {
                        n2 = this._decodeUtf8_2(n2);
                        break;
                    }
                    case 3: {
                        n2 = this._decodeUtf8_3(n2);
                        break;
                    }
                    case 4: {
                        n2 = this._decodeUtf8_4(n2);
                        cArray[n3++] = (char)(0xD800 | n2 >> 10);
                        if (n3 >= cArray.length) {
                            cArray = this._textBuffer.finishCurrentSegment();
                            n3 = 0;
                        }
                        n2 = 0xDC00 | n2 & 0x3FF;
                        break;
                    }
                    default: {
                        if (n2 < 32) {
                            this._throwUnquotedSpace(n2, "string value");
                        }
                        this._reportInvalidChar(n2);
                    }
                }
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n3 = 0;
                }
                cArray[n3++] = (char)n2;
                continue block6;
            }
            break;
        }
        this._textBuffer.setCurrentLength(n3);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl2) throws IOException {
        while (n2 == 73) {
            String string;
            n2 = this._inputData.readUnsignedByte();
            if (n2 == 78) {
                string = bl2 ? "-INF" : "+INF";
            } else {
                if (n2 != 110) break;
                string = bl2 ? "-Infinity" : "+Infinity";
            }
            this._matchToken(string, 3);
            if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                return this.resetAsNaN(string, bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
            this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
        }
        this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected final void _matchToken(String string, int n2) throws IOException {
        int n3;
        int n4 = string.length();
        do {
            if ((n3 = this._inputData.readUnsignedByte()) == string.charAt(n2)) continue;
            this._reportInvalidToken(n3, string.substring(0, n2));
        } while (++n2 < n4);
        n3 = this._inputData.readUnsignedByte();
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            this._checkMatchEnd(string, n2, n3);
        }
        this._nextByte = n3;
    }

    private final void _checkMatchEnd(String string, int n2, int n3) throws IOException {
        char c2 = (char)this._decodeCharForError(n3);
        if (Character.isJavaIdentifierPart(c2)) {
            this._reportInvalidToken(c2, string.substring(0, n2));
        }
    }

    private final int _skipWS() throws IOException {
        int n2 = this._nextByte;
        if (n2 < 0) {
            n2 = this._inputData.readUnsignedByte();
        } else {
            this._nextByte = -1;
        }
        while (true) {
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this._skipWSComment(n2);
                }
                return n2;
            }
            if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final int _skipWSOrEnd() throws IOException {
        int n2 = this._nextByte;
        if (n2 < 0) {
            try {
                n2 = this._inputData.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                return this._eofAsNextChar();
            }
        } else {
            this._nextByte = -1;
        }
        while (true) {
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this._skipWSComment(n2);
                }
                return n2;
            }
            if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            try {
                n2 = this._inputData.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                return this._eofAsNextChar();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int _skipWSComment(int n2) throws IOException {
        while (true) {
            if (n2 > 32) {
                if (n2 == 47) {
                    this._skipComment();
                } else {
                    if (n2 != 35) return n2;
                    if (!this._skipYAMLComment()) {
                        return n2;
                    }
                }
            } else if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final int _skipColon() throws IOException {
        int n2 = this._nextByte;
        if (n2 < 0) {
            n2 = this._inputData.readUnsignedByte();
        } else {
            this._nextByte = -1;
        }
        if (n2 == 58) {
            n2 = this._inputData.readUnsignedByte();
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this._skipColon2(n2, true);
                }
                return n2;
            }
            if ((n2 == 32 || n2 == 9) && (n2 = this._inputData.readUnsignedByte()) > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this._skipColon2(n2, true);
                }
                return n2;
            }
            return this._skipColon2(n2, true);
        }
        if (n2 == 32 || n2 == 9) {
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 58) {
            n2 = this._inputData.readUnsignedByte();
            if (n2 > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this._skipColon2(n2, true);
                }
                return n2;
            }
            if ((n2 == 32 || n2 == 9) && (n2 = this._inputData.readUnsignedByte()) > 32) {
                if (n2 == 47 || n2 == 35) {
                    return this._skipColon2(n2, true);
                }
                return n2;
            }
            return this._skipColon2(n2, true);
        }
        return this._skipColon2(n2, false);
    }

    private final int _skipColon2(int n2, boolean bl2) throws IOException {
        while (true) {
            if (n2 > 32) {
                if (n2 == 47) {
                    this._skipComment();
                } else if (n2 != 35 || !this._skipYAMLComment()) {
                    if (bl2) {
                        return n2;
                    }
                    if (n2 != 58) {
                        this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
                    }
                    bl2 = true;
                }
            } else if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final void _skipComment() throws IOException {
        int n2;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if ((n2 = this._inputData.readUnsignedByte()) == 47) {
            this._skipLine();
        } else if (n2 == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n2, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        int n2 = this._inputData.readUnsignedByte();
        block7: while (true) {
            int n3;
            if ((n3 = nArray[n2]) != 0) {
                switch (n3) {
                    case 42: {
                        n2 = this._inputData.readUnsignedByte();
                        if (n2 != 47) continue block7;
                        return;
                    }
                    case 10: 
                    case 13: {
                        ++this._currInputRow;
                        break;
                    }
                    case 2: {
                        this._skipUtf8_2();
                        break;
                    }
                    case 3: {
                        this._skipUtf8_3();
                        break;
                    }
                    case 4: {
                        this._skipUtf8_4();
                        break;
                    }
                    default: {
                        this._reportInvalidChar(n2);
                    }
                }
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final boolean _skipYAMLComment() throws IOException {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private final void _skipLine() throws IOException {
        int[] nArray = CharTypes.getInputCodeComment();
        block7: while (true) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputData.readUnsignedByte()]) == 0) {
                continue;
            }
            switch (n3) {
                case 10: 
                case 13: {
                    ++this._currInputRow;
                    return;
                }
                case 42: {
                    continue block7;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block7;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block7;
                }
                case 4: {
                    this._skipUtf8_4();
                    continue block7;
                }
            }
            if (n3 >= 0) continue;
            this._reportInvalidChar(n2);
        }
    }

    @Override
    protected char _decodeEscaped() throws IOException {
        int n2 = this._inputData.readUnsignedByte();
        switch (n2) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)n2;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(n2));
            }
        }
        int n3 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n4 = this._inputData.readUnsignedByte();
            int n5 = CharTypes.charToHex(n4);
            if (n5 < 0) {
                this._reportUnexpectedChar(n4, "expected a hex-digit for character escape sequence");
            }
            n3 = n3 << 4 | n5;
        }
        return (char)n3;
    }

    protected int _decodeCharForError(int n2) throws IOException {
        int n3 = n2 & 0xFF;
        if (n3 > 127) {
            int n4;
            if ((n3 & 0xE0) == 192) {
                n3 &= 0x1F;
                n4 = 1;
            } else if ((n3 & 0xF0) == 224) {
                n3 &= 0xF;
                n4 = 2;
            } else if ((n3 & 0xF8) == 240) {
                n3 &= 7;
                n4 = 3;
            } else {
                this._reportInvalidInitial(n3 & 0xFF);
                n4 = 1;
            }
            int n5 = this._inputData.readUnsignedByte();
            if ((n5 & 0xC0) != 128) {
                this._reportInvalidOther(n5 & 0xFF);
            }
            n3 = n3 << 6 | n5 & 0x3F;
            if (n4 > 1) {
                n5 = this._inputData.readUnsignedByte();
                if ((n5 & 0xC0) != 128) {
                    this._reportInvalidOther(n5 & 0xFF);
                }
                n3 = n3 << 6 | n5 & 0x3F;
                if (n4 > 2) {
                    n5 = this._inputData.readUnsignedByte();
                    if ((n5 & 0xC0) != 128) {
                        this._reportInvalidOther(n5 & 0xFF);
                    }
                    n3 = n3 << 6 | n5 & 0x3F;
                }
            }
        }
        return n3;
    }

    private final int _decodeUtf8_2(int n2) throws IOException {
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        return (n2 & 0x1F) << 6 | n3 & 0x3F;
    }

    private final int _decodeUtf8_3(int n2) throws IOException {
        n2 &= 0xF;
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        int n4 = n2 << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        n4 = n4 << 6 | n3 & 0x3F;
        return n4;
    }

    private final int _decodeUtf8_4(int n2) throws IOException {
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        n2 = (n2 & 7) << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        return (n2 << 6 | n3 & 0x3F) - 65536;
    }

    private final void _skipUtf8_2() throws IOException {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
    }

    private final void _skipUtf8_3() throws IOException {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
    }

    private final void _skipUtf8_4() throws IOException {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
    }

    protected void _reportInvalidToken(int n2, String string) throws IOException {
        this._reportInvalidToken(n2, string, this._validJsonTokenList());
    }

    protected void _reportInvalidToken(int n2, String string, String string2) throws IOException {
        char c2;
        StringBuilder stringBuilder = new StringBuilder(string);
        while (Character.isJavaIdentifierPart(c2 = (char)this._decodeCharForError(n2))) {
            stringBuilder.append(c2);
            n2 = this._inputData.readUnsignedByte();
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting " + string2);
    }

    protected void _reportInvalidChar(int n2) throws JsonParseException {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    private void _reportInvalidOther(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    private static int[] _growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        return Arrays.copyOf(nArray, nArray.length + n2);
    }

    protected final byte[] _decodeBase64(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n2;
            if ((n2 = this._inputData.readUnsignedByte()) <= 32) {
                continue;
            }
            int n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n2 == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n3 = this._decodeBase64Escape(base64Variant, n2, 0);
                if (n3 < 0) continue;
            }
            int n4 = n3;
            n2 = this._inputData.readUnsignedByte();
            n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                n3 = this._decodeBase64Escape(base64Variant, n2, 1);
            }
            n4 = n4 << 6 | n3;
            n2 = this._inputData.readUnsignedByte();
            n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n3 != -2) {
                    if (n2 == 34) {
                        byteArrayBuilder.append(n4 >>= 4);
                        if (base64Variant.usesPadding()) {
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 2);
                }
                if (n3 == -2) {
                    n2 = this._inputData.readUnsignedByte();
                    if (!(base64Variant.usesPaddingChar(n2) || n2 == 92 && this._decodeBase64Escape(base64Variant, n2, 3) == -2)) {
                        throw this.reportInvalidBase64Char(base64Variant, n2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n4 >>= 4);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            n2 = this._inputData.readUnsignedByte();
            n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n3 != -2) {
                    if (n2 == 34) {
                        byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                        if (base64Variant.usesPadding()) {
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 3);
                }
                if (n3 == -2) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._getSourceReference(), -1L, -1L, this._tokenInputRow, -1);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n2 = -1;
        return new JsonLocation(this._getSourceReference(), -1L, -1L, this._currInputRow, -1);
    }

    private void _closeScope(int n2) throws JsonParseException {
        if (n2 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (n2 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }

    private static final int pad(int n2, int n3) {
        return n3 == 4 ? n2 : n2 | -1 << (n3 << 3);
    }
}

