/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.PropertyNamingStrategy;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.MapperConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedField;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedMethod;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public abstract class PropertyNamingStrategies
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new LowerCamelCaseStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    public static final PropertyNamingStrategy LOWER_DOT_CASE = new LowerDotCaseStrategy();

    public static class LowerDotCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return this.translateLowerCaseWithSeparator(string, '.');
        }
    }

    public static class KebabCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return this.translateLowerCaseWithSeparator(string, '-');
        }
    }

    public static class LowerCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return string.toLowerCase();
        }
    }

    public static class UpperCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            char c2;
            if (string == null || string.isEmpty()) {
                return string;
            }
            char c3 = string.charAt(0);
            if (c3 == (c2 = Character.toUpperCase(c3))) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(0, c2);
            return stringBuilder.toString();
        }
    }

    public static class LowerCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            return string;
        }
    }

    public static class SnakeCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String string) {
            if (string == null) {
                return string;
            }
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2 * 2);
            int n3 = 0;
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (i2 <= 0 && c2 == '_') continue;
                if (Character.isUpperCase(c2)) {
                    if (!bl2 && n3 > 0 && stringBuilder.charAt(n3 - 1) != '_') {
                        stringBuilder.append('_');
                        ++n3;
                    }
                    c2 = Character.toLowerCase(c2);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                stringBuilder.append(c2);
                ++n3;
            }
            return n3 > 0 ? stringBuilder.toString() : string;
        }
    }

    public static abstract class NamingBase
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = 2L;

        @Override
        public String nameForField(MapperConfig<?> mapperConfig, AnnotatedField annotatedField, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> mapperConfig, AnnotatedMethod annotatedMethod, String string) {
            return this.translate(string);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> mapperConfig, AnnotatedParameter annotatedParameter, String string) {
            return this.translate(string);
        }

        public abstract String translate(String var1);

        protected String translateLowerCaseWithSeparator(String string, char c2) {
            if (string == null) {
                return string;
            }
            int n2 = string.length();
            if (n2 == 0) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(n2 + (n2 >> 1));
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                char c4 = Character.toLowerCase(c3);
                if (c4 == c3) {
                    if (n3 > 1) {
                        stringBuilder.insert(stringBuilder.length() - 1, c2);
                    }
                    n3 = 0;
                } else {
                    if (n3 == 0 && i2 > 0) {
                        stringBuilder.append(c2);
                    }
                    ++n3;
                }
                stringBuilder.append(c4);
            }
            return stringBuilder.toString();
        }
    }
}

