/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.ObjectIdGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.ObjectIdGenerators;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.ObjectIdResolver;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.AnnotationIntrospector;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanDescription;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.PropertyName;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.BeanDeserializerBuilder;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ContextualDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.SettableBeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.UnresolvedForwardReference;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ValueInstantiator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.impl.ObjectIdReader;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.impl.PropertyBasedObjectIdGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.impl.ReadableObjectId;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedMember;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.ObjectIdInfo;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.LogicalType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class AbstractDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final JavaType _baseType;
    protected final ObjectIdReader _objectIdReader;
    protected final Map<String, SettableBeanProperty> _backRefProperties;
    protected transient Map<String, SettableBeanProperty> _properties;
    protected final boolean _acceptString;
    protected final boolean _acceptBoolean;
    protected final boolean _acceptInt;
    protected final boolean _acceptDouble;

    public AbstractDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, Map<String, SettableBeanProperty> map, Map<String, SettableBeanProperty> map2) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = beanDeserializerBuilder.getObjectIdReader();
        this._backRefProperties = map;
        this._properties = map2;
        Class<Object> clazz = this._baseType.getRawClass();
        this._acceptString = clazz.isAssignableFrom(String.class);
        this._acceptBoolean = clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class);
        this._acceptInt = clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class);
        this._acceptDouble = clazz == Double.TYPE || clazz.isAssignableFrom(Double.class);
    }

    @Deprecated
    public AbstractDeserializer(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, Map<String, SettableBeanProperty> map) {
        this(beanDeserializerBuilder, beanDescription, map, null);
    }

    protected AbstractDeserializer(BeanDescription beanDescription) {
        this._baseType = beanDescription.getType();
        this._objectIdReader = null;
        this._backRefProperties = null;
        Class<Object> clazz = this._baseType.getRawClass();
        this._acceptString = clazz.isAssignableFrom(String.class);
        this._acceptBoolean = clazz == Boolean.TYPE || clazz.isAssignableFrom(Boolean.class);
        this._acceptInt = clazz == Integer.TYPE || clazz.isAssignableFrom(Integer.class);
        this._acceptDouble = clazz == Double.TYPE || clazz.isAssignableFrom(Double.class);
    }

    protected AbstractDeserializer(AbstractDeserializer abstractDeserializer, ObjectIdReader objectIdReader, Map<String, SettableBeanProperty> map) {
        this._baseType = abstractDeserializer._baseType;
        this._backRefProperties = abstractDeserializer._backRefProperties;
        this._acceptString = abstractDeserializer._acceptString;
        this._acceptBoolean = abstractDeserializer._acceptBoolean;
        this._acceptInt = abstractDeserializer._acceptInt;
        this._acceptDouble = abstractDeserializer._acceptDouble;
        this._objectIdReader = objectIdReader;
        this._properties = map;
    }

    public static AbstractDeserializer constructForNonPOJO(BeanDescription beanDescription) {
        return new AbstractDeserializer(beanDescription);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        ObjectIdInfo objectIdInfo;
        AnnotatedMember annotatedMember;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (beanProperty != null && annotationIntrospector != null && (annotatedMember = beanProperty.getMember()) != null && (objectIdInfo = annotationIntrospector.findObjectIdInfo(annotatedMember)) != null) {
            ObjectIdGenerator objectIdGenerator;
            JavaType javaType;
            Object object;
            SettableBeanProperty settableBeanProperty = null;
            ObjectIdResolver objectIdResolver = deserializationContext.objectIdResolverInstance(annotatedMember, objectIdInfo);
            Class<? extends ObjectIdGenerator<?>> clazz = (objectIdInfo = annotationIntrospector.findObjectReferenceInfo(annotatedMember, objectIdInfo)).getGeneratorType();
            if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
                object = objectIdInfo.getPropertyName();
                SettableBeanProperty settableBeanProperty2 = settableBeanProperty = this._properties == null ? null : this._properties.get(((PropertyName)object).getSimpleName());
                if (settableBeanProperty == null) {
                    deserializationContext.reportBadDefinition(this._baseType, String.format("Invalid Object Id definition for %s: cannot find property with name %s", ClassUtil.nameOf(this.handledType()), ClassUtil.name((PropertyName)object)));
                }
                javaType = settableBeanProperty.getType();
                objectIdGenerator = new PropertyBasedObjectIdGenerator(objectIdInfo.getScope());
            } else {
                objectIdResolver = deserializationContext.objectIdResolverInstance(annotatedMember, objectIdInfo);
                object = deserializationContext.constructType(clazz);
                javaType = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object, ObjectIdGenerator.class)[0];
                objectIdGenerator = deserializationContext.objectIdGeneratorInstance(annotatedMember, objectIdInfo);
            }
            object = deserializationContext.findRootValueDeserializer(javaType);
            ObjectIdReader objectIdReader = ObjectIdReader.construct(javaType, objectIdInfo.getPropertyName(), objectIdGenerator, object, settableBeanProperty, objectIdResolver);
            return new AbstractDeserializer(this, objectIdReader, null);
        }
        if (this._properties == null) {
            return this;
        }
        return new AbstractDeserializer(this, this._objectIdReader, null);
    }

    @Override
    public Class<?> handledType() {
        return this._baseType.getRawClass();
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return null;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        return this._backRefProperties == null ? null : this._backRefProperties.get(string);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        Object object;
        if (this._objectIdReader != null && (object = jsonParser.currentToken()) != null) {
            if (object.isScalarValue()) {
                return this._deserializeFromObjectId(jsonParser, deserializationContext);
            }
            if (object == JsonToken.START_OBJECT) {
                object = jsonParser.nextToken();
            }
            if (object == JsonToken.FIELD_NAME && this._objectIdReader.maySerializeAsObject() && this._objectIdReader.isValidReferencePropertyName(jsonParser.currentName(), jsonParser)) {
                return this._deserializeFromObjectId(jsonParser, deserializationContext);
            }
        }
        if ((object = this._deserializeIfNatural(jsonParser, deserializationContext)) != null) {
            return object;
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ValueInstantiator.Base base = new ValueInstantiator.Base(this._baseType);
        return deserializationContext.handleMissingInstantiator(this._baseType.getRawClass(), base, jsonParser, "abstract types either need to be mapped to concrete types, have custom deserializer, or contain additional type information", new Object[0]);
    }

    protected Object _deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 6: {
                if (!this._acceptString) break;
                return jsonParser.getText();
            }
            case 7: {
                if (!this._acceptInt) break;
                return jsonParser.getIntValue();
            }
            case 8: {
                if (!this._acceptDouble) break;
                return jsonParser.getDoubleValue();
            }
            case 9: {
                if (!this._acceptBoolean) break;
                return Boolean.TRUE;
            }
            case 10: {
                if (!this._acceptBoolean) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected Object _deserializeFromObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object = this._objectIdReader.readObjectReference(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(object, this._objectIdReader.generator, this._objectIdReader.resolver);
        Object object2 = readableObjectId.resolve();
        if (object2 == null) {
            throw new UnresolvedForwardReference(jsonParser, "Could not resolve Object Id [" + object + "] -- unresolved forward-reference?", jsonParser.getCurrentLocation(), readableObjectId);
        }
        return object2;
    }
}

