/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.StdScalarDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.LogicalType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ByteBufferBackedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Binary;
    }

    @Override
    public ByteBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        byte[] byArray = jsonParser.getBinaryValue();
        return ByteBuffer.wrap(byArray);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, ByteBuffer byteBuffer) throws IOException {
        ByteBufferBackedOutputStream byteBufferBackedOutputStream = new ByteBufferBackedOutputStream(byteBuffer);
        jsonParser.readBinaryValue(deserializationContext.getBase64Variant(), byteBufferBackedOutputStream);
        byteBufferBackedOutputStream.close();
        return byteBuffer;
    }
}

