/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.JsonFormat;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.MapperFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.annotation.JacksonStdImpl;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.CoercionAction;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.CoercionInputShape;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ContextualDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.SettableBeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ValueInstantiator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.FactoryBasedEnumDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.StdScalarDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedMethod;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.LogicalType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.CompactStringObjectMap;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.EnumResolver;
import java.io.IOException;
import java.util.Objects;

@JacksonStdImpl
public class EnumDeserializer
extends StdScalarDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected Object[] _enumsByIndex;
    private final Enum<?> _enumDefaultValue;
    protected final CompactStringObjectMap _lookupByName;
    protected CompactStringObjectMap _lookupByToString;
    protected final Boolean _caseInsensitive;

    public EnumDeserializer(EnumResolver enumResolver, Boolean bl2) {
        super(enumResolver.getEnumClass());
        this._lookupByName = enumResolver.constructLookup();
        this._enumsByIndex = enumResolver.getRawEnums();
        this._enumDefaultValue = enumResolver.getDefaultValue();
        this._caseInsensitive = bl2;
    }

    protected EnumDeserializer(EnumDeserializer enumDeserializer, Boolean bl2) {
        super(enumDeserializer);
        this._lookupByName = enumDeserializer._lookupByName;
        this._enumsByIndex = enumDeserializer._enumsByIndex;
        this._enumDefaultValue = enumDeserializer._enumDefaultValue;
        this._caseInsensitive = bl2;
    }

    @Deprecated
    public EnumDeserializer(EnumResolver enumResolver) {
        this(enumResolver, null);
    }

    @Deprecated
    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        return EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, null, null);
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod, annotatedMethod.getParameterType(0), valueInstantiator, settableBeanPropertyArray);
    }

    public static JsonDeserializer<?> deserializerForNoArgsCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod);
    }

    public EnumDeserializer withResolved(Boolean bl2) {
        if (Objects.equals(this._caseInsensitive, bl2)) {
            return this;
        }
        return new EnumDeserializer(this, bl2);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl2 = this.findFormatFeature(deserializationContext, beanProperty, this.handledType(), JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        if (bl2 == null) {
            bl2 = this._caseInsensitive;
        }
        return this.withResolved(bl2);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return this._enumDefaultValue;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return this._fromInteger(jsonParser, deserializationContext, jsonParser.getIntValue());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass));
        }
        return this._deserializeOther(jsonParser, deserializationContext);
    }

    protected Object _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2;
        CompactStringObjectMap compactStringObjectMap = deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING) ? this._getToStringLookup(deserializationContext) : this._lookupByName;
        Object object = compactStringObjectMap.find(string);
        if (object == null && ((string2 = string.trim()) == string || (object = compactStringObjectMap.find(string2)) == null)) {
            return this._deserializeAltString(jsonParser, deserializationContext, compactStringObjectMap, string2);
        }
        return object;
    }

    protected Object _fromInteger(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) throws IOException {
        CoercionAction coercionAction = deserializationContext.findCoercionAction(this.logicalType(), this.handledType(), CoercionInputShape.Integer);
        if (coercionAction == CoercionAction.Fail) {
            if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "not allowed to deserialize Enum value out of number: disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow", new Object[0]);
            }
            this._checkCoercionFail(deserializationContext, coercionAction, this.handledType(), n2, "Integer value (" + n2 + ")");
        }
        switch (coercionAction) {
            case AsNull: {
                return null;
            }
            case AsEmpty: {
                return this.getEmptyValue(deserializationContext);
            }
        }
        if (n2 >= 0 && n2 < this._enumsByIndex.length) {
            return this._enumsByIndex[n2];
        }
        if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
            return this._enumDefaultValue;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "index value outside legal index range [0..%s]", this._enumsByIndex.length - 1);
        }
        return null;
    }

    private final Object _deserializeAltString(JsonParser jsonParser, DeserializationContext deserializationContext, CompactStringObjectMap compactStringObjectMap, String string) throws IOException {
        char c2;
        String string2 = string.trim();
        if (string2.isEmpty()) {
            CoercionAction coercionAction;
            if (string.isEmpty()) {
                coercionAction = this._findCoercionFromEmptyString(deserializationContext);
                coercionAction = this._checkCoercionFail(deserializationContext, coercionAction, this.handledType(), string, "empty String (\"\")");
            } else {
                coercionAction = this._findCoercionFromBlankString(deserializationContext);
                coercionAction = this._checkCoercionFail(deserializationContext, coercionAction, this.handledType(), string, "blank String (all whitespace)");
            }
            switch (coercionAction) {
                case AsEmpty: 
                case TryConvert: {
                    return this.getEmptyValue(deserializationContext);
                }
            }
            return null;
        }
        if (Boolean.TRUE.equals(this._caseInsensitive)) {
            Object object = compactStringObjectMap.findCaseInsensitive(string2);
            if (object != null) {
                return object;
            }
        } else if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS) && (c2 = string2.charAt(0)) >= '0' && c2 <= '9') {
            try {
                int n2 = Integer.parseInt(string2);
                if (!deserializationContext.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                    return deserializationContext.handleWeirdStringValue(this._enumClass(), string2, "value looks like quoted Enum index, but `MapperFeature.ALLOW_COERCION_OF_SCALARS` prevents use", new Object[0]);
                }
                if (n2 >= 0 && n2 < this._enumsByIndex.length) {
                    return this._enumsByIndex[n2];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
            return this._enumDefaultValue;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return deserializationContext.handleWeirdStringValue(this._enumClass(), string2, "not one of the values accepted for Enum class: %s", compactStringObjectMap.keys());
        }
        return null;
    }

    protected Object _deserializeOther(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._enumClass(), jsonParser);
    }

    protected Class<?> _enumClass() {
        return this.handledType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompactStringObjectMap _getToStringLookup(DeserializationContext deserializationContext) {
        CompactStringObjectMap compactStringObjectMap = this._lookupByToString;
        if (compactStringObjectMap == null) {
            EnumDeserializer enumDeserializer = this;
            synchronized (enumDeserializer) {
                compactStringObjectMap = EnumResolver.constructUsingToString(deserializationContext.getConfig(), this._enumClass()).constructLookup();
            }
            this._lookupByToString = compactStringObjectMap;
        }
        return compactStringObjectMap;
    }
}

