/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanDescription;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.KeyDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.MapperFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.KeyDeserializers;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.StdKeyDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedMethod;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod annotatedMethod) {
        return new StdKeyDeserializer.EnumKD(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        return new StdKeyDeserializer.DelegatingKD(javaType.getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        BeanDescription beanDescription = deserializationConfig.introspect(javaType);
        Constructor<?> constructor = beanDescription.findSingleArgConstructor(String.class);
        if (constructor != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(constructor, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(constructor);
        }
        Method method = beanDescription.findFactoryMethod(String.class);
        if (method != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(method);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        return StdKeyDeserializer.forType(clazz);
    }
}

