/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ext;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.type.WritableTypeId;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.SerializerProvider;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.annotation.JacksonStdImpl;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsonFormatVisitors.JsonFormatTypes;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeSerializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

@JacksonStdImpl
public class SqlBlobSerializer
extends StdScalarSerializer<Blob> {
    public SqlBlobSerializer() {
        super(Blob.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Blob blob) {
        return blob == null;
    }

    @Override
    public void serialize(Blob blob, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this._writeValue(blob, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(Blob blob, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(blob, JsonToken.VALUE_EMBEDDED_OBJECT));
        this._writeValue(blob, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void _writeValue(Blob blob, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = blob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            serializerProvider.reportMappingProblem(sQLException, "Failed to access `java.sql.Blob` value to write as binary value", new Object[0]);
        }
        jsonGenerator.writeBinary(serializerProvider.getConfig().getBase64Variant(), inputStream, -1);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonArrayFormatVisitor jsonArrayFormatVisitor = jsonFormatVisitorWrapper.expectArrayFormat(javaType);
        if (jsonArrayFormatVisitor != null) {
            jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

