/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.AnnotationIntrospector;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotatedField;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.AnnotationCollector;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.ClassIntrospector;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.CollectorBase;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.introspect.TypeResolutionContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.TypeFactory;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnotatedFieldCollector
extends CollectorBase {
    private final TypeFactory _typeFactory;
    private final ClassIntrospector.MixInResolver _mixInResolver;
    private final boolean _collectAnnotations;

    AnnotatedFieldCollector(AnnotationIntrospector annotationIntrospector, TypeFactory typeFactory, ClassIntrospector.MixInResolver mixInResolver, boolean bl2) {
        super(annotationIntrospector);
        this._typeFactory = typeFactory;
        this._mixInResolver = annotationIntrospector == null ? null : mixInResolver;
        this._collectAnnotations = bl2;
    }

    public static List<AnnotatedField> collectFields(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, JavaType javaType, boolean bl2) {
        return new AnnotatedFieldCollector(annotationIntrospector, typeFactory, mixInResolver, bl2).collect(typeResolutionContext, javaType);
    }

    List<AnnotatedField> collect(TypeResolutionContext typeResolutionContext, JavaType javaType) {
        Map<String, FieldBuilder> map = this._findFields(typeResolutionContext, javaType, null);
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedField> arrayList = new ArrayList<AnnotatedField>(map.size());
        for (FieldBuilder fieldBuilder : map.values()) {
            arrayList.add(fieldBuilder.build());
        }
        return arrayList;
    }

    private Map<String, FieldBuilder> _findFields(TypeResolutionContext typeResolutionContext, JavaType javaType, Map<String, FieldBuilder> map) {
        JavaType javaType2 = javaType.getSuperClass();
        if (javaType2 == null) {
            return map;
        }
        Class<?> clazz = javaType.getRawClass();
        map = this._findFields(new TypeResolutionContext.Basic(this._typeFactory, javaType2.getBindings()), javaType2, map);
        Object object = clazz.getDeclaredFields();
        int n2 = ((Field[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = object[i2];
            if (!this._isIncludableField(field)) continue;
            if (map == null) {
                map = new LinkedHashMap<String, FieldBuilder>();
            }
            FieldBuilder fieldBuilder = new FieldBuilder(typeResolutionContext, field);
            if (this._collectAnnotations) {
                fieldBuilder.annotations = this.collectAnnotations(fieldBuilder.annotations, field.getDeclaredAnnotations());
            }
            map.put(field.getName(), fieldBuilder);
        }
        if (map != null && this._mixInResolver != null && (object = this._mixInResolver.findMixInClassFor(clazz)) != null) {
            this._addFieldMixIns((Class<?>)object, clazz, map);
        }
        return map;
    }

    private void _addFieldMixIns(Class<?> clazz, Class<?> clazz2, Map<String, FieldBuilder> map) {
        List<Class<?>> list = ClassUtil.findSuperClasses(clazz, clazz2, true);
        for (Class<?> clazz3 : list) {
            for (Field field : clazz3.getDeclaredFields()) {
                String string;
                FieldBuilder fieldBuilder;
                if (!this._isIncludableField(field) || (fieldBuilder = map.get(string = field.getName())) == null) continue;
                fieldBuilder.annotations = this.collectAnnotations(fieldBuilder.annotations, field.getDeclaredAnnotations());
            }
        }
    }

    private boolean _isIncludableField(Field field) {
        if (field.isSynthetic()) {
            return false;
        }
        int n2 = field.getModifiers();
        return !Modifier.isStatic(n2);
    }

    private static final class FieldBuilder {
        public final TypeResolutionContext typeContext;
        public final Field field;
        public AnnotationCollector annotations;

        public FieldBuilder(TypeResolutionContext typeResolutionContext, Field field) {
            this.typeContext = typeResolutionContext;
            this.field = field;
            this.annotations = AnnotationCollector.emptyCollector();
        }

        public AnnotatedField build() {
            return new AnnotatedField(this.typeContext, this.field, this.annotations.asAnnotationMap());
        }
    }
}

