/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ser.impl;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonSerializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.SerializerProvider;
import java.util.Arrays;

public abstract class PropertySerializerMap {
    protected final boolean _resetWhenFull;

    protected PropertySerializerMap(boolean bl2) {
        this._resetWhenFull = bl2;
    }

    protected PropertySerializerMap(PropertySerializerMap propertySerializerMap) {
        this._resetWhenFull = propertySerializerMap._resetWhenFull;
    }

    public abstract JsonSerializer<Object> serializerFor(Class<?> var1);

    public final SerializerAndMapResult findAndAddPrimarySerializer(Class<?> clazz, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findPrimaryPropertySerializer(clazz, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(clazz, jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddPrimarySerializer(JavaType javaType, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findPrimaryPropertySerializer(javaType, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(javaType.getRawClass(), jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(Class<?> clazz, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findContentValueSerializer(clazz, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(clazz, jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddSecondarySerializer(JavaType javaType, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findContentValueSerializer(javaType, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(javaType.getRawClass(), jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddRootValueSerializer(Class<?> clazz, SerializerProvider serializerProvider) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findTypedValueSerializer(clazz, false, null);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(clazz, jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddRootValueSerializer(JavaType javaType, SerializerProvider serializerProvider) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findTypedValueSerializer(javaType, false, null);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(javaType.getRawClass(), jsonSerializer));
    }

    public final SerializerAndMapResult findAndAddKeySerializer(Class<?> clazz, SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = serializerProvider.findKeySerializer(clazz, beanProperty);
        return new SerializerAndMapResult(jsonSerializer, this.newWith(clazz, jsonSerializer));
    }

    public final SerializerAndMapResult addSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
        return new SerializerAndMapResult(jsonSerializer, this.newWith(clazz, jsonSerializer));
    }

    public final SerializerAndMapResult addSerializer(JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        return new SerializerAndMapResult(jsonSerializer, this.newWith(javaType.getRawClass(), jsonSerializer));
    }

    public abstract PropertySerializerMap newWith(Class<?> var1, JsonSerializer<Object> var2);

    public static PropertySerializerMap emptyForProperties() {
        return Empty.FOR_PROPERTIES;
    }

    public static PropertySerializerMap emptyForRootValues() {
        return Empty.FOR_ROOT_VALUES;
    }

    private static final class Multi
    extends PropertySerializerMap {
        private static final int MAX_ENTRIES = 8;
        private final TypeAndSerializer[] _entries;

        public Multi(PropertySerializerMap propertySerializerMap, TypeAndSerializer[] typeAndSerializerArray) {
            super(propertySerializerMap);
            this._entries = typeAndSerializerArray;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            TypeAndSerializer typeAndSerializer = this._entries[0];
            if (typeAndSerializer.type == clazz) {
                return typeAndSerializer.serializer;
            }
            typeAndSerializer = this._entries[1];
            if (typeAndSerializer.type == clazz) {
                return typeAndSerializer.serializer;
            }
            typeAndSerializer = this._entries[2];
            if (typeAndSerializer.type == clazz) {
                return typeAndSerializer.serializer;
            }
            switch (this._entries.length) {
                case 8: {
                    typeAndSerializer = this._entries[7];
                    if (typeAndSerializer.type == clazz) {
                        return typeAndSerializer.serializer;
                    }
                }
                case 7: {
                    typeAndSerializer = this._entries[6];
                    if (typeAndSerializer.type == clazz) {
                        return typeAndSerializer.serializer;
                    }
                }
                case 6: {
                    typeAndSerializer = this._entries[5];
                    if (typeAndSerializer.type == clazz) {
                        return typeAndSerializer.serializer;
                    }
                }
                case 5: {
                    typeAndSerializer = this._entries[4];
                    if (typeAndSerializer.type == clazz) {
                        return typeAndSerializer.serializer;
                    }
                }
                case 4: {
                    typeAndSerializer = this._entries[3];
                    if (typeAndSerializer.type != clazz) break;
                    return typeAndSerializer.serializer;
                }
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            int n2 = this._entries.length;
            if (n2 == 8) {
                if (this._resetWhenFull) {
                    return new Single(this, clazz, jsonSerializer);
                }
                return this;
            }
            TypeAndSerializer[] typeAndSerializerArray = Arrays.copyOf(this._entries, n2 + 1);
            typeAndSerializerArray[n2] = new TypeAndSerializer(clazz, jsonSerializer);
            return new Multi(this, typeAndSerializerArray);
        }
    }

    private static final class Double
    extends PropertySerializerMap {
        private final Class<?> _type1;
        private final Class<?> _type2;
        private final JsonSerializer<Object> _serializer1;
        private final JsonSerializer<Object> _serializer2;

        public Double(PropertySerializerMap propertySerializerMap, Class<?> clazz, JsonSerializer<Object> jsonSerializer, Class<?> clazz2, JsonSerializer<Object> jsonSerializer2) {
            super(propertySerializerMap);
            this._type1 = clazz;
            this._serializer1 = jsonSerializer;
            this._type2 = clazz2;
            this._serializer2 = jsonSerializer2;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            if (clazz == this._type1) {
                return this._serializer1;
            }
            if (clazz == this._type2) {
                return this._serializer2;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            TypeAndSerializer[] typeAndSerializerArray = new TypeAndSerializer[]{new TypeAndSerializer(this._type1, this._serializer1), new TypeAndSerializer(this._type2, this._serializer2), new TypeAndSerializer(clazz, jsonSerializer)};
            return new Multi(this, typeAndSerializerArray);
        }
    }

    private static final class Single
    extends PropertySerializerMap {
        private final Class<?> _type;
        private final JsonSerializer<Object> _serializer;

        public Single(PropertySerializerMap propertySerializerMap, Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            super(propertySerializerMap);
            this._type = clazz;
            this._serializer = jsonSerializer;
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            if (clazz == this._type) {
                return this._serializer;
            }
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            return new Double(this, this._type, this._serializer, clazz, jsonSerializer);
        }
    }

    private static final class Empty
    extends PropertySerializerMap {
        public static final Empty FOR_PROPERTIES = new Empty(false);
        public static final Empty FOR_ROOT_VALUES = new Empty(true);

        protected Empty(boolean bl2) {
            super(bl2);
        }

        @Override
        public JsonSerializer<Object> serializerFor(Class<?> clazz) {
            return null;
        }

        @Override
        public PropertySerializerMap newWith(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            return new Single(this, clazz, jsonSerializer);
        }
    }

    private static final class TypeAndSerializer {
        public final Class<?> type;
        public final JsonSerializer<Object> serializer;

        public TypeAndSerializer(Class<?> clazz, JsonSerializer<Object> jsonSerializer) {
            this.type = clazz;
            this.serializer = jsonSerializer;
        }
    }

    public static final class SerializerAndMapResult {
        public final JsonSerializer<Object> serializer;
        public final PropertySerializerMap map;

        public SerializerAndMapResult(JsonSerializer<Object> jsonSerializer, PropertySerializerMap propertySerializerMap) {
            this.serializer = jsonSerializer;
            this.map = propertySerializerMap;
        }
    }
}

