/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ser.impl;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.type.WritableTypeId;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonNode;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.SerializationFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.SerializerProvider;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeSerializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> clazz) {
        super(clazz, false);
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(serializerProvider, object);
        }
        jsonGenerator.writeStartObject(object, 0);
        jsonGenerator.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(serializerProvider, object);
        }
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.START_OBJECT));
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType);
    }

    protected void failForEmpty(SerializerProvider serializerProvider, Object object) throws JsonMappingException {
        serializerProvider.reportBadDefinition(this.handledType(), String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", object.getClass().getName()));
    }
}

