/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.deser;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.BeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.BeanDeserializerBase;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.SettableBeanProperty;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.ValueInstantiator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.DelegatingDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeDeserializer;
import java.io.IOException;

public class XmlTextDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    protected final int _xmlTextPropertyIndex;
    protected final SettableBeanProperty _xmlTextProperty;
    protected final ValueInstantiator _valueInstantiator;

    public XmlTextDeserializer(BeanDeserializerBase beanDeserializerBase, SettableBeanProperty settableBeanProperty) {
        super(beanDeserializerBase);
        this._xmlTextProperty = settableBeanProperty;
        this._xmlTextPropertyIndex = settableBeanProperty.getPropertyIndex();
        this._valueInstantiator = beanDeserializerBase.getValueInstantiator();
    }

    public XmlTextDeserializer(BeanDeserializerBase beanDeserializerBase, int n2) {
        super(beanDeserializerBase);
        this._xmlTextPropertyIndex = n2;
        this._valueInstantiator = beanDeserializerBase.getValueInstantiator();
        this._xmlTextProperty = beanDeserializerBase.findProperty(n2);
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        return new XmlTextDeserializer(this._verifyDeserType(this._delegatee), this._xmlTextPropertyIndex);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
            this._xmlTextProperty.deserializeAndSet(jsonParser, deserializationContext, object);
            return object;
        }
        return this._delegatee.deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            this._xmlTextProperty.deserializeAndSet(jsonParser, deserializationContext, object);
            return object;
        }
        return this._delegatee.deserialize(jsonParser, deserializationContext, object);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return this._delegatee.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
    }

    protected BeanDeserializerBase _verifyDeserType(JsonDeserializer<?> jsonDeserializer) {
        if (!(jsonDeserializer instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + jsonDeserializer.getClass().getName());
        }
        return (BeanDeserializerBase)jsonDeserializer;
    }
}

