/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.ser;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonSerializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.PropertyName;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.SerializationConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeSerializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ser.DefaultSerializerProvider;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.ser.SerializerFactory;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.TokenBuffer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.ser.ToXmlGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.util.StaxUtil;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.util.TypeUtil;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.util.XmlRootNameLookup;
import java.io.Closeable;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 1L;
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup xmlRootNameLookup) {
        this._rootNameLookup = xmlRootNameLookup;
    }

    public XmlSerializerProvider(XmlSerializerProvider xmlSerializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(xmlSerializerProvider, serializationConfig, serializerFactory);
        this._rootNameLookup = xmlSerializerProvider._rootNameLookup;
    }

    protected XmlSerializerProvider(XmlSerializerProvider xmlSerializerProvider) {
        super(xmlSerializerProvider);
        this._rootNameLookup = new XmlRootNameLookup();
    }

    @Override
    public DefaultSerializerProvider copy() {
        return new XmlSerializerProvider(this);
    }

    @Override
    public DefaultSerializerProvider createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        return new XmlSerializerProvider(this, serializationConfig, serializerFactory);
    }

    @Override
    public void serializeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        Object object2;
        boolean bl2;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        Class<?> clazz = object.getClass();
        ToXmlGenerator toXmlGenerator = this._asXmlGenerator(jsonGenerator);
        if (toXmlGenerator == null) {
            bl2 = false;
        } else {
            object2 = this._rootNameFromConfig();
            if (object2 == null) {
                object2 = this._rootNameLookup.findRootName(clazz, this._config);
            }
            this._initWithRootName(toXmlGenerator, (QName)object2);
            bl2 = TypeUtil.isIndexedType(clazz);
            if (bl2) {
                this._startRootArray(toXmlGenerator, (QName)object2);
            }
        }
        object2 = this.findTypedValueSerializer(clazz, true, null);
        try {
            ((JsonSerializer)object2).serialize(object, jsonGenerator, this);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    @Override
    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) throws IOException {
        this.serializeValue(jsonGenerator, object, javaType, null);
    }

    @Override
    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) throws IOException {
        boolean bl2;
        ToXmlGenerator toXmlGenerator;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if ((toXmlGenerator = this._asXmlGenerator(jsonGenerator)) == null) {
            bl2 = false;
        } else {
            QName qName = this._rootNameFromConfig();
            if (qName == null) {
                qName = this._rootNameLookup.findRootName(javaType, this._config);
            }
            this._initWithRootName(toXmlGenerator, qName);
            bl2 = TypeUtil.isIndexedType(javaType);
            if (bl2) {
                this._startRootArray(toXmlGenerator, qName);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    @Override
    public void serializePolymorphic(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) throws IOException {
        boolean bl2;
        ToXmlGenerator toXmlGenerator;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if ((toXmlGenerator = this._asXmlGenerator(jsonGenerator)) == null) {
            bl2 = false;
        } else {
            QName qName = this._rootNameFromConfig();
            if (qName == null) {
                qName = this._rootNameLookup.findRootName(javaType, this._config);
            }
            this._initWithRootName(toXmlGenerator, qName);
            bl2 = TypeUtil.isIndexedType(javaType);
            if (bl2) {
                this._startRootArray(toXmlGenerator, qName);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = javaType != null && javaType.isContainerType() ? this.findValueSerializer(javaType, null) : this.findValueSerializer(object.getClass(), null);
        }
        try {
            jsonSerializer.serializeWithType(object, jsonGenerator, this, typeSerializer);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    protected void _serializeXmlNull(JsonGenerator jsonGenerator) throws IOException {
        QName qName = this._rootNameFromConfig();
        if (qName == null) {
            qName = XmlRootNameLookup.ROOT_NAME_FOR_NULL;
        }
        if (jsonGenerator instanceof ToXmlGenerator) {
            this._initWithRootName((ToXmlGenerator)jsonGenerator, qName);
        }
        super.serializeValue(jsonGenerator, null);
    }

    protected void _startRootArray(ToXmlGenerator toXmlGenerator, QName qName) throws IOException {
        toXmlGenerator.writeStartObject();
        toXmlGenerator.writeFieldName("item");
    }

    protected void _initWithRootName(ToXmlGenerator toXmlGenerator, QName qName) throws IOException {
        if (!toXmlGenerator.setNextNameIfMissing(qName) && toXmlGenerator.inRoot()) {
            toXmlGenerator.setNextName(qName);
        }
        toXmlGenerator.initGenerator();
        String string = qName.getNamespaceURI();
        if (string != null && string.length() > 0) {
            try {
                toXmlGenerator.getStaxWriter().setDefaultNamespace(string);
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwAsGenerationException(xMLStreamException, toXmlGenerator);
            }
        }
    }

    protected QName _rootNameFromConfig() {
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            return null;
        }
        String string = propertyName.getNamespace();
        if (string == null || string.isEmpty()) {
            return new QName(propertyName.getSimpleName());
        }
        return new QName(string, propertyName.getSimpleName());
    }

    protected ToXmlGenerator _asXmlGenerator(JsonGenerator jsonGenerator) throws JsonMappingException {
        if (!(jsonGenerator instanceof ToXmlGenerator)) {
            if (jsonGenerator instanceof TokenBuffer) {
                return null;
            }
            throw JsonMappingException.from(jsonGenerator, "XmlMapper does not work with generators of type other than `ToXmlGenerator`; got: `" + jsonGenerator.getClass().getName() + "`");
        }
        return (ToXmlGenerator)jsonGenerator;
    }

    protected IOException _wrapAsIOE(JsonGenerator jsonGenerator, Exception exception) {
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        String string = exception.getMessage();
        if (string == null) {
            string = "[no message for " + exception.getClass().getName() + "]";
        }
        return new JsonMappingException((Closeable)jsonGenerator, string, (Throwable)exception);
    }
}

