/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_1_15.codec.language;

import com.ibm.cognos.externals.org.apache.commons_1_15.codec.EncoderException;
import com.ibm.cognos.externals.org.apache.commons_1_15.codec.StringEncoder;
import java.util.Locale;

public class ColognePhonetic
implements StringEncoder {
    private static final char[] AEIJOUY = new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'};
    private static final char[] CSZ = new char[]{'C', 'S', 'Z'};
    private static final char[] FPVW = new char[]{'F', 'P', 'V', 'W'};
    private static final char[] GKQ = new char[]{'G', 'K', 'Q'};
    private static final char[] CKQ = new char[]{'C', 'K', 'Q'};
    private static final char[] AHKLOQRUX = new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'};
    private static final char[] SZ = new char[]{'S', 'Z'};
    private static final char[] AHKOQUX = new char[]{'A', 'H', 'K', 'O', 'Q', 'U', 'X'};
    private static final char[] DTX = new char[]{'D', 'T', 'X'};
    private static final char CHAR_IGNORE = '-';

    private static boolean arrayContains(char[] cArray, char c2) {
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    public String colognePhonetic(String string) {
        if (string == null) {
            return null;
        }
        CologneInputBuffer cologneInputBuffer = new CologneInputBuffer(this.preprocess(string));
        CologneOutputBuffer cologneOutputBuffer = new CologneOutputBuffer(cologneInputBuffer.length() * 2);
        char c2 = '-';
        while (cologneInputBuffer.length() > 0) {
            char c3 = cologneInputBuffer.removeNext();
            char c4 = cologneInputBuffer.length() > 0 ? (char)cologneInputBuffer.getNextChar() : (char)'-';
            if (c3 < 'A' || c3 > 'Z') continue;
            if (ColognePhonetic.arrayContains(AEIJOUY, c3)) {
                cologneOutputBuffer.put('0');
            } else if (c3 == 'B' || c3 == 'P' && c4 != 'H') {
                cologneOutputBuffer.put('1');
            } else if (!(c3 != 'D' && c3 != 'T' || ColognePhonetic.arrayContains(CSZ, c4))) {
                cologneOutputBuffer.put('2');
            } else if (ColognePhonetic.arrayContains(FPVW, c3)) {
                cologneOutputBuffer.put('3');
            } else if (ColognePhonetic.arrayContains(GKQ, c3)) {
                cologneOutputBuffer.put('4');
            } else if (c3 == 'X' && !ColognePhonetic.arrayContains(CKQ, c2)) {
                cologneOutputBuffer.put('4');
                cologneOutputBuffer.put('8');
            } else if (c3 == 'S' || c3 == 'Z') {
                cologneOutputBuffer.put('8');
            } else if (c3 == 'C') {
                if (cologneOutputBuffer.length() == 0) {
                    if (ColognePhonetic.arrayContains(AHKLOQRUX, c4)) {
                        cologneOutputBuffer.put('4');
                    } else {
                        cologneOutputBuffer.put('8');
                    }
                } else if (ColognePhonetic.arrayContains(SZ, c2) || !ColognePhonetic.arrayContains(AHKOQUX, c4)) {
                    cologneOutputBuffer.put('8');
                } else {
                    cologneOutputBuffer.put('4');
                }
            } else if (ColognePhonetic.arrayContains(DTX, c3)) {
                cologneOutputBuffer.put('8');
            } else if (c3 == 'R') {
                cologneOutputBuffer.put('7');
            } else if (c3 == 'L') {
                cologneOutputBuffer.put('5');
            } else if (c3 == 'M' || c3 == 'N') {
                cologneOutputBuffer.put('6');
            } else if (c3 == 'H') {
                cologneOutputBuffer.put('-');
            }
            c2 = c3;
        }
        return cologneOutputBuffer.toString();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("This method's parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + object.getClass().getName() + ".");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        return this.colognePhonetic(string);
    }

    public boolean isEncodeEqual(String string, String string2) {
        return this.colognePhonetic(string).equals(this.colognePhonetic(string2));
    }

    private char[] preprocess(String string) {
        char[] cArray = string.toUpperCase(Locale.GERMAN).toCharArray();
        block5: for (int i2 = 0; i2 < cArray.length; ++i2) {
            switch (cArray[i2]) {
                case '\u00c4': {
                    cArray[i2] = 65;
                    continue block5;
                }
                case '\u00dc': {
                    cArray[i2] = 85;
                    continue block5;
                }
                case '\u00d6': {
                    cArray[i2] = 79;
                    continue block5;
                }
            }
        }
        return cArray;
    }

    private class CologneInputBuffer
    extends CologneBuffer {
        public CologneInputBuffer(char[] cArray) {
            super(cArray);
        }

        @Override
        protected char[] copyData(int n2, int n3) {
            char[] cArray = new char[n3];
            System.arraycopy(this.data, this.data.length - this.length + n2, cArray, 0, n3);
            return cArray;
        }

        public char getNextChar() {
            return this.data[this.getNextPos()];
        }

        protected int getNextPos() {
            return this.data.length - this.length;
        }

        public char removeNext() {
            char c2 = this.getNextChar();
            --this.length;
            return c2;
        }
    }

    private class CologneOutputBuffer
    extends CologneBuffer {
        private char lastCode;

        public CologneOutputBuffer(int n2) {
            super(n2);
            this.lastCode = (char)47;
        }

        public void put(char c2) {
            if (c2 != '-' && this.lastCode != c2 && (c2 != '0' || this.length == 0)) {
                this.data[this.length] = c2;
                ++this.length;
            }
            this.lastCode = c2;
        }

        @Override
        protected char[] copyData(int n2, int n3) {
            char[] cArray = new char[n3];
            System.arraycopy(this.data, n2, cArray, 0, n3);
            return cArray;
        }
    }

    private abstract class CologneBuffer {
        protected final char[] data;
        protected int length = 0;

        public CologneBuffer(char[] cArray) {
            this.data = cArray;
            this.length = cArray.length;
        }

        public CologneBuffer(int n2) {
            this.data = new char[n2];
            this.length = 0;
        }

        protected abstract char[] copyData(int var1, int var2);

        public int length() {
            return this.length;
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }
}

