/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.Charsets;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.LineIterator;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.function.IOConsumer;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output.AppendableWriter;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output.ByteArrayOutputStream;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output.NullOutputStream;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output.StringBuilderWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class IOUtils {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final int EOF = -1;
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    private static final byte[] SKIP_BYTE_BUFFER = new byte[8192];
    private static char[] SKIP_CHAR_BUFFER;

    public static BufferedInputStream buffer(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static BufferedInputStream buffer(InputStream inputStream, int n2) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n2);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream, int n2) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n2);
    }

    public static BufferedReader buffer(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader buffer(Reader reader, int n2) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
    }

    public static BufferedWriter buffer(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static BufferedWriter buffer(Writer writer, int n2) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n2);
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(Closeable ... closeableArray) throws IOException {
        if (closeableArray != null) {
            for (Closeable closeable : closeableArray) {
                IOUtils.close(closeable);
            }
        }
    }

    public static void close(Closeable closeable, IOConsumer<IOException> iOConsumer) throws IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (iOConsumer == null) break block3;
                    iOConsumer.accept(iOException);
                }
            }
        }
    }

    public static void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    @Deprecated
    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, (Consumer<IOException>)null);
    }

    @Deprecated
    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray == null) {
            return;
        }
        for (Closeable closeable : closeableArray) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(Closeable closeable, Consumer<IOException> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (consumer == null) break block3;
                    consumer.accept(iOException);
                }
            }
        }
    }

    @Deprecated
    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    @Deprecated
    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    @Deprecated
    public static void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Closeable)reader);
    }

    @Deprecated
    public static void closeQuietly(Selector selector) {
        IOUtils.closeQuietly((Closeable)selector);
    }

    @Deprecated
    public static void closeQuietly(ServerSocket serverSocket) {
        IOUtils.closeQuietly((Closeable)serverSocket);
    }

    @Deprecated
    public static void closeQuietly(Socket socket) {
        IOUtils.closeQuietly((Closeable)socket);
    }

    @Deprecated
    public static void closeQuietly(Writer writer) {
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static long consume(InputStream inputStream) throws IOException {
        return IOUtils.copyLarge(inputStream, NullOutputStream.NULL_OUTPUT_STREAM, SKIP_BYTE_BUFFER);
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        if (inputStream == inputStream2) {
            return true;
        }
        if (inputStream == null ^ inputStream2 == null) {
            return false;
        }
        BufferedInputStream bufferedInputStream = IOUtils.buffer(inputStream);
        BufferedInputStream bufferedInputStream2 = IOUtils.buffer(inputStream2);
        int n2 = bufferedInputStream.read();
        while (-1 != n2) {
            int n3 = bufferedInputStream2.read();
            if (n2 != n3) {
                return false;
            }
            n2 = bufferedInputStream.read();
        }
        return bufferedInputStream2.read() == -1;
    }

    public static boolean contentEquals(Reader reader, Reader reader2) throws IOException {
        if (reader == reader2) {
            return true;
        }
        if (reader == null ^ reader2 == null) {
            return false;
        }
        BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
        BufferedReader bufferedReader2 = IOUtils.toBufferedReader(reader2);
        int n2 = bufferedReader.read();
        while (-1 != n2) {
            int n3 = bufferedReader2.read();
            if (n2 != n3) {
                return false;
            }
            n2 = bufferedReader.read();
        }
        return bufferedReader2.read() == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) throws IOException {
        if (reader == reader2) {
            return true;
        }
        if (reader == null ^ reader2 == null) {
            return false;
        }
        BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
        BufferedReader bufferedReader2 = IOUtils.toBufferedReader(reader2);
        String string = bufferedReader.readLine();
        String string2 = bufferedReader2.readLine();
        while (string != null && string.equals(string2)) {
            string = bufferedReader.readLine();
            string2 = bufferedReader2.readLine();
        }
        return Objects.equals(string, string2);
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, new byte[n2]);
    }

    @Deprecated
    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        IOUtils.copy(inputStream, writer, Charset.defaultCharset());
    }

    public static void copy(InputStream inputStream, Writer writer, Charset charset) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.toCharset(charset));
        IOUtils.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        IOUtils.copy(inputStream, writer, Charsets.toCharset(string));
    }

    public static long copy(Reader reader, Appendable appendable) throws IOException {
        return IOUtils.copy(reader, appendable, CharBuffer.allocate(8192));
    }

    public static long copy(Reader reader, Appendable appendable, CharBuffer charBuffer) throws IOException {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(charBuffer))) {
            charBuffer.flip();
            appendable.append(charBuffer, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    @Deprecated
    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        IOUtils.copy(reader, outputStream, Charset.defaultCharset());
    }

    public static void copy(Reader reader, OutputStream outputStream, Charset charset) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charsets.toCharset(charset));
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) throws IOException {
        IOUtils.copy(reader, outputStream, Charsets.toCharset(string));
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l2 = 0L;
        if (inputStream != null) {
            int n2;
            while (-1 != (n2 = inputStream.read(byArray))) {
                outputStream.write(byArray, 0, n2);
                l2 += (long)n2;
            }
        }
        return l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, l2, l3, new byte[8192]);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) throws IOException {
        int n2;
        int n3;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n4 = n3 = byArray.length;
        if (l3 > 0L && l3 < (long)n3) {
            n4 = (int)l3;
        }
        long l4 = 0L;
        while (n4 > 0 && -1 != (n2 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n4 = (int)Math.min(l3 - l4, (long)n3);
        }
        return l4;
    }

    public static long copyLarge(Reader reader, Writer writer) throws IOException {
        return IOUtils.copyLarge(reader, writer, new char[8192]);
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) throws IOException {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3) throws IOException {
        return IOUtils.copyLarge(reader, writer, l2, l3, new char[8192]);
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3, char[] cArray) throws IOException {
        int n2;
        if (l2 > 0L) {
            IOUtils.skipFully(reader, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n3 = cArray.length;
        if (l3 > 0L && l3 < (long)cArray.length) {
            n3 = (int)l3;
        }
        long l4 = 0L;
        while (n3 > 0 && -1 != (n2 = reader.read(cArray, 0, n3))) {
            writer.write(cArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n3 = (int)Math.min(l3 - l4, (long)cArray.length);
        }
        return l4;
    }

    public static int length(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int length(char[] cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static int length(Object[] objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static LineIterator lineIterator(InputStream inputStream, Charset charset) throws IOException {
        return new LineIterator(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static LineIterator lineIterator(InputStream inputStream, String string) throws IOException {
        return IOUtils.lineIterator(inputStream, Charsets.toCharset(string));
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n5 = n3; n5 > 0 && -1 != (n6 = inputStream.read(byArray, n2 + (n4 = n3 - n5), n5)); n5 -= n6) {
        }
        return n3 - n5;
    }

    public static int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n2;
        int n3 = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && -1 != (n2 = readableByteChannel.read(byteBuffer))) {
        }
        return n3 - byteBuffer.remaining();
    }

    public static int read(Reader reader, char[] cArray) throws IOException {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static int read(Reader reader, char[] cArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n5 = n3; n5 > 0 && -1 != (n6 = reader.read(cArray, n2 + (n4 = n3 - n5), n5)); n5 -= n6) {
        }
        return n3 - n5;
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = IOUtils.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static byte[] readFully(InputStream inputStream, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
        return byArray;
    }

    public static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        int n3 = IOUtils.read(readableByteChannel, byteBuffer);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    public static void readFully(Reader reader, char[] cArray) throws IOException {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static void readFully(Reader reader, char[] cArray, int n2, int n3) throws IOException {
        int n4 = IOUtils.read(reader, cArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    @Deprecated
    public static List<String> readLines(InputStream inputStream) throws IOException {
        return IOUtils.readLines(inputStream, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.toCharset(charset));
        return IOUtils.readLines(inputStreamReader);
    }

    public static List<String> readLines(InputStream inputStream, String string) throws IOException {
        return IOUtils.readLines(inputStream, Charsets.toCharset(string));
    }

    public static List<String> readLines(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static byte[] resourceToByteArray(String string) throws IOException {
        return IOUtils.resourceToByteArray(string, null);
    }

    public static byte[] resourceToByteArray(String string, ClassLoader classLoader) throws IOException {
        return IOUtils.toByteArray(IOUtils.resourceToURL(string, classLoader));
    }

    public static String resourceToString(String string, Charset charset) throws IOException {
        return IOUtils.resourceToString(string, charset, null);
    }

    public static String resourceToString(String string, Charset charset, ClassLoader classLoader) throws IOException {
        return IOUtils.toString(IOUtils.resourceToURL(string, classLoader), charset);
    }

    public static URL resourceToURL(String string) throws IOException {
        return IOUtils.resourceToURL(string, null);
    }

    public static URL resourceToURL(String string, ClassLoader classLoader) throws IOException {
        URL uRL;
        URL uRL2 = uRL = classLoader == null ? IOUtils.class.getResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("Resource not found: " + string);
        }
        return uRL;
    }

    public static long skip(InputStream inputStream, long l2) throws IOException {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(l3, (long)SKIP_BYTE_BUFFER.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static long skip(ReadableByteChannel readableByteChannel, long l2) throws IOException {
        long l3;
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(l2, (long)SKIP_BYTE_BUFFER.length));
        for (l3 = l2; l3 > 0L; l3 -= (long)n2) {
            byteBuffer.position(0);
            byteBuffer.limit((int)Math.min(l3, (long)SKIP_BYTE_BUFFER.length));
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 == -1) break;
        }
        return l2 - l3;
    }

    public static long skip(Reader reader, long l2) throws IOException {
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        if (SKIP_CHAR_BUFFER == null) {
            SKIP_CHAR_BUFFER = new char[SKIP_BYTE_BUFFER.length];
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)reader.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(l3, (long)SKIP_BYTE_BUFFER.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(inputStream, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(ReadableByteChannel readableByteChannel, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(readableByteChannel, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(Reader reader, long l2) throws IOException {
        long l3 = IOUtils.skip(reader, l2);
        if (l3 != l2) {
            throw new EOFException("Chars to skip: " + l2 + " actual: " + l3);
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, n2);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader toBufferedReader(Reader reader, int n2) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            IOUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) throws IOException {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + n2);
        }
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Unexpected read size. current: " + n3 + ", expected: " + n2);
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream, long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + l2);
        }
        return IOUtils.toByteArray(inputStream, (int)l2);
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader) throws IOException {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader reader, Charset charset) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            IOUtils.copy(reader, (OutputStream)byteArrayOutputStream, charset);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] toByteArray(Reader reader, String string) throws IOException {
        return IOUtils.toByteArray(reader, Charsets.toCharset(string));
    }

    @Deprecated
    public static byte[] toByteArray(String string) throws IOException {
        return string.getBytes(Charset.defaultCharset());
    }

    public static byte[] toByteArray(URI uRI) throws IOException {
        return IOUtils.toByteArray(uRI.toURL());
    }

    public static byte[] toByteArray(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray(uRLConnection);
            return byArray;
        }
        finally {
            IOUtils.close(uRLConnection);
        }
    }

    public static byte[] toByteArray(URLConnection uRLConnection) throws IOException {
        try (InputStream inputStream = uRLConnection.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    @Deprecated
    public static char[] toCharArray(InputStream inputStream) throws IOException {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream inputStream, Charset charset) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter, charset);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) throws IOException {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(string));
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    @Deprecated
    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence charSequence, Charset charset) {
        return IOUtils.toInputStream(charSequence.toString(), charset);
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) throws IOException {
        return IOUtils.toInputStream(charSequence, Charsets.toCharset(string));
    }

    @Deprecated
    public static InputStream toInputStream(String string) {
        return IOUtils.toInputStream(string, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(charset)));
    }

    public static InputStream toInputStream(String string, String string2) throws IOException {
        byte[] byArray = string.getBytes(Charsets.toCharset(string2));
        return new ByteArrayInputStream(byArray);
    }

    @Deprecated
    public static String toString(byte[] byArray) throws IOException {
        return new String(byArray, Charset.defaultCharset());
    }

    public static String toString(byte[] byArray, String string) throws IOException {
        return new String(byArray, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(InputStream inputStream) throws IOException {
        return IOUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static String toString(InputStream inputStream, Charset charset) throws IOException {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy(inputStream, (Writer)stringBuilderWriter, charset);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        return IOUtils.toString(inputStream, Charsets.toCharset(string));
    }

    public static String toString(Reader reader) throws IOException {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy(reader, (Writer)stringBuilderWriter);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }

    @Deprecated
    public static String toString(URI uRI) throws IOException {
        return IOUtils.toString(uRI, Charset.defaultCharset());
    }

    public static String toString(URI uRI, Charset charset) throws IOException {
        return IOUtils.toString(uRI.toURL(), Charsets.toCharset(charset));
    }

    public static String toString(URI uRI, String string) throws IOException {
        return IOUtils.toString(uRI, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(URL uRL) throws IOException {
        return IOUtils.toString(uRL, Charset.defaultCharset());
    }

    public static String toString(URL uRL, Charset charset) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            String string = IOUtils.toString(inputStream, charset);
            return string;
        }
    }

    public static String toString(URL uRL, String string) throws IOException {
        return IOUtils.toString(uRL, Charsets.toCharset(string));
    }

    public static void write(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    @Deprecated
    public static void write(byte[] byArray, Writer writer) throws IOException {
        IOUtils.write(byArray, writer, Charset.defaultCharset());
    }

    public static void write(byte[] byArray, Writer writer, Charset charset) throws IOException {
        if (byArray != null) {
            writer.write(new String(byArray, Charsets.toCharset(charset)));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) throws IOException {
        IOUtils.write(byArray, writer, Charsets.toCharset(string));
    }

    @Deprecated
    public static void write(char[] cArray, OutputStream outputStream) throws IOException {
        IOUtils.write(cArray, outputStream, Charset.defaultCharset());
    }

    public static void write(char[] cArray, OutputStream outputStream, Charset charset) throws IOException {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) throws IOException {
        IOUtils.write(cArray, outputStream, Charsets.toCharset(string));
    }

    public static void write(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    @Deprecated
    public static void write(CharSequence charSequence, OutputStream outputStream) throws IOException {
        IOUtils.write(charSequence, outputStream, Charset.defaultCharset());
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, Charset charset) throws IOException {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), outputStream, charset);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) throws IOException {
        IOUtils.write(charSequence, outputStream, Charsets.toCharset(string));
    }

    public static void write(CharSequence charSequence, Writer writer) throws IOException {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), writer);
        }
    }

    @Deprecated
    public static void write(String string, OutputStream outputStream) throws IOException {
        IOUtils.write(string, outputStream, Charset.defaultCharset());
    }

    public static void write(String string, OutputStream outputStream, Charset charset) throws IOException {
        if (string != null) {
            outputStream.write(string.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) throws IOException {
        IOUtils.write(string, outputStream, Charsets.toCharset(string2));
    }

    public static void write(String string, Writer writer) throws IOException {
        if (string != null) {
            writer.write(string);
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream) throws IOException {
        IOUtils.write(stringBuffer, outputStream, (String)null);
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) throws IOException {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes(Charsets.toCharset(string)));
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, Writer writer) throws IOException {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void writeChunked(byte[] byArray, OutputStream outputStream) throws IOException {
        if (byArray != null) {
            int n2 = byArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 8192);
                outputStream.write(byArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    public static void writeChunked(char[] cArray, Writer writer) throws IOException {
        if (cArray != null) {
            int n2 = cArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 8192);
                writer.write(cArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    @Deprecated
    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream) throws IOException {
        IOUtils.writeLines(collection, string, outputStream, Charset.defaultCharset());
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, Charset charset) throws IOException {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = System.lineSeparator();
        }
        Charset charset2 = Charsets.toCharset(charset);
        for (Object obj : collection) {
            if (obj != null) {
                outputStream.write(obj.toString().getBytes(charset2));
            }
            outputStream.write(string.getBytes(charset2));
        }
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, String string2) throws IOException {
        IOUtils.writeLines(collection, string, outputStream, Charsets.toCharset(string2));
    }

    public static void writeLines(Collection<?> collection, String string, Writer writer) throws IOException {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = System.lineSeparator();
        }
        for (Object obj : collection) {
            if (obj != null) {
                writer.write(obj.toString());
            }
            writer.write(string);
        }
    }

    public static Writer writer(Appendable appendable) {
        Objects.requireNonNull(appendable, "appendable");
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        if (appendable instanceof StringBuilder) {
            return new StringBuilderWriter((StringBuilder)appendable);
        }
        return new AppendableWriter<Appendable>(appendable);
    }
}

