/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.comparator;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FilenameUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.IOCase;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.comparator.AbstractFileComparator;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.comparator.ReverseFileComparator;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;

public class ExtensionFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final long serialVersionUID = 1928235200184222815L;
    public static final Comparator<File> EXTENSION_COMPARATOR = new ExtensionFileComparator();
    public static final Comparator<File> EXTENSION_REVERSE = new ReverseFileComparator(EXTENSION_COMPARATOR);
    public static final Comparator<File> EXTENSION_INSENSITIVE_COMPARATOR = new ExtensionFileComparator(IOCase.INSENSITIVE);
    public static final Comparator<File> EXTENSION_INSENSITIVE_REVERSE = new ReverseFileComparator(EXTENSION_INSENSITIVE_COMPARATOR);
    public static final Comparator<File> EXTENSION_SYSTEM_COMPARATOR = new ExtensionFileComparator(IOCase.SYSTEM);
    public static final Comparator<File> EXTENSION_SYSTEM_REVERSE = new ReverseFileComparator(EXTENSION_SYSTEM_COMPARATOR);
    private final IOCase caseSensitivity;

    public ExtensionFileComparator() {
        this.caseSensitivity = IOCase.SENSITIVE;
    }

    public ExtensionFileComparator(IOCase iOCase) {
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public int compare(File file, File file2) {
        String string = FilenameUtils.getExtension(file.getName());
        String string2 = FilenameUtils.getExtension(file2.getName());
        return this.caseSensitivity.checkCompareTo(string, string2);
    }

    @Override
    public String toString() {
        return super.toString() + "[caseSensitivity=" + (Object)((Object)this.caseSensitivity) + "]";
    }
}

