/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ObservableInputStream
extends ProxyInputStream {
    private final List<Observer> observers = new ArrayList<Observer>();

    public ObservableInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void add(Observer observer) {
        this.observers.add(observer);
    }

    public void remove(Observer observer) {
        this.observers.remove(observer);
    }

    public void removeAllObservers() {
        this.observers.clear();
    }

    @Override
    public int read() throws IOException {
        int n2 = 0;
        IOException iOException = null;
        try {
            n2 = super.read();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n2 == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = 0;
        IOException iOException = null;
        try {
            n2 = super.read(byArray);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n2 == -1) {
            this.noteFinished();
        } else if (n2 > 0) {
            this.noteDataBytes(byArray, 0, n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        IOException iOException = null;
        try {
            n4 = super.read(byArray, n2, n3);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
        } else if (n4 == -1) {
            this.noteFinished();
        } else if (n4 > 0) {
            this.noteDataBytes(byArray, n2, n4);
        }
        return n4;
    }

    protected void noteDataBytes(byte[] byArray, int n2, int n3) throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.data(byArray, n2, n3);
        }
    }

    protected void noteFinished() throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.finished();
        }
    }

    protected void noteDataByte(int n2) throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.data(n2);
        }
    }

    protected void noteError(IOException iOException) throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.error(iOException);
        }
    }

    protected void noteClosed() throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.closed();
        }
    }

    protected List<Observer> getObservers() {
        return this.observers;
    }

    @Override
    public void close() throws IOException {
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException == null) {
            this.noteClosed();
        } else {
            this.noteError(iOException);
        }
    }

    public void consume() throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        while ((n2 = this.read(byArray)) != -1) {
        }
    }

    public static abstract class Observer {
        public void data(int n2) throws IOException {
        }

        public void data(byte[] byArray, int n2, int n3) throws IOException {
        }

        public void finished() throws IOException {
        }

        public void closed() throws IOException {
        }

        public void error(IOException iOException) throws IOException {
            throw iOException;
        }
    }
}

