/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FileUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;

public class FileWriterWithEncoding
extends Writer {
    private final Writer out;

    public FileWriterWithEncoding(String string, String string2) throws IOException {
        this(new File(string), string2, false);
    }

    public FileWriterWithEncoding(String string, String string2, boolean bl2) throws IOException {
        this(new File(string), string2, bl2);
    }

    public FileWriterWithEncoding(String string, Charset charset) throws IOException {
        this(new File(string), charset, false);
    }

    public FileWriterWithEncoding(String string, Charset charset, boolean bl2) throws IOException {
        this(new File(string), charset, bl2);
    }

    public FileWriterWithEncoding(String string, CharsetEncoder charsetEncoder) throws IOException {
        this(new File(string), charsetEncoder, false);
    }

    public FileWriterWithEncoding(String string, CharsetEncoder charsetEncoder, boolean bl2) throws IOException {
        this(new File(string), charsetEncoder, bl2);
    }

    public FileWriterWithEncoding(File file, String string) throws IOException {
        this(file, string, false);
    }

    public FileWriterWithEncoding(File file, String string, boolean bl2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file, string, bl2);
    }

    public FileWriterWithEncoding(File file, Charset charset) throws IOException {
        this(file, charset, false);
    }

    public FileWriterWithEncoding(File file, Charset charset, boolean bl2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file, charset, bl2);
    }

    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder) throws IOException {
        this(file, charsetEncoder, false);
    }

    public FileWriterWithEncoding(File file, CharsetEncoder charsetEncoder, boolean bl2) throws IOException {
        this.out = FileWriterWithEncoding.initWriter(file, charsetEncoder, bl2);
    }

    private static Writer initWriter(File file, Object object, boolean bl2) throws IOException {
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(object, "encoding");
        FileOutputStream fileOutputStream = null;
        boolean bl3 = file.exists();
        try {
            fileOutputStream = new FileOutputStream(file, bl2);
            if (object instanceof Charset) {
                return new OutputStreamWriter((OutputStream)fileOutputStream, (Charset)object);
            }
            if (object instanceof CharsetEncoder) {
                return new OutputStreamWriter((OutputStream)fileOutputStream, (CharsetEncoder)object);
            }
            return new OutputStreamWriter((OutputStream)fileOutputStream, (String)object);
        }
        catch (IOException | RuntimeException exception) {
            try {
                IOUtils.close(fileOutputStream);
            }
            catch (IOException iOException) {
                exception.addSuppressed(iOException);
            }
            if (!bl3) {
                FileUtils.deleteQuietly(file);
            }
            throw exception;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.out.write(n2);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.out.write(cArray);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.out.write(cArray, n2, n3);
    }

    @Override
    public void write(String string) throws IOException {
        this.out.write(string);
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this.out.write(string, n2, n3);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

