/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.IOUtils;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ProxyOutputStream
extends FilterOutputStream {
    public ProxyOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n2) throws IOException {
        try {
            this.beforeWrite(1);
            this.out.write(n2);
            this.afterWrite(1);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            int n2 = IOUtils.length(byArray);
            this.beforeWrite(n2);
            this.out.write(byArray);
            this.afterWrite(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.beforeWrite(n3);
            this.out.write(byArray, n2, n3);
            this.afterWrite(n3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    protected void beforeWrite(int n2) throws IOException {
    }

    protected void afterWrite(int n2) throws IOException {
    }

    protected void handleIOException(IOException iOException) throws IOException {
        throw iOException;
    }
}

