/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntityEnclosingRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.MessageConstraints;
import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.ContentLengthStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.BHttpConnectionBase;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.DefaultHttpRequestWriterFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.DefaultHttpResponseParserFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpMessageParser;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpMessageParserFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpMessageWriter;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpMessageWriterFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class DefaultBHttpClientConnection
extends BHttpConnectionBase
implements HttpClientConnection {
    private final HttpMessageParser<HttpResponse> responseParser;
    private final HttpMessageWriter<HttpRequest> requestWriter;

    public DefaultBHttpClientConnection(int n2, int n3, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, HttpMessageWriterFactory<HttpRequest> defaultHttpRequestWriterFactory, HttpMessageParserFactory<HttpResponse> defaultHttpResponseParserFactory) {
        super(n2, n3, charsetDecoder, charsetEncoder, messageConstraints, contentLengthStrategy, contentLengthStrategy2);
        this.requestWriter = (defaultHttpRequestWriterFactory != null ? defaultHttpRequestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE).create(this.getSessionOutputBuffer());
        this.responseParser = (defaultHttpResponseParserFactory != null ? defaultHttpResponseParserFactory : DefaultHttpResponseParserFactory.INSTANCE).create(this.getSessionInputBuffer(), messageConstraints);
    }

    public DefaultBHttpClientConnection(int n2, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints) {
        this(n2, n2, charsetDecoder, charsetEncoder, messageConstraints, null, null, null, null);
    }

    public DefaultBHttpClientConnection(int n2) {
        this(n2, n2, null, null, null, null, null, null, null);
    }

    protected void onResponseReceived(HttpResponse httpResponse) {
    }

    protected void onRequestSubmitted(HttpRequest httpRequest) {
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind(socket);
    }

    @Override
    public boolean isResponseAvailable(int n2) throws IOException {
        this.ensureOpen();
        try {
            return this.awaitInput(n2);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
    }

    @Override
    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        this.ensureOpen();
        this.requestWriter.write(httpRequest);
        this.onRequestSubmitted(httpRequest);
        this.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest httpEntityEnclosingRequest) throws HttpException, IOException {
        Args.notNull(httpEntityEnclosingRequest, "HTTP request");
        this.ensureOpen();
        HttpEntity httpEntity = httpEntityEnclosingRequest.getEntity();
        if (httpEntity == null) {
            return;
        }
        OutputStream outputStream = this.prepareOutput(httpEntityEnclosingRequest);
        httpEntity.writeTo(outputStream);
        outputStream.close();
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.ensureOpen();
        HttpResponse httpResponse = this.responseParser.parse();
        this.onResponseReceived(httpResponse);
        if (httpResponse.getStatusLine().getStatusCode() >= 200) {
            this.incrementResponseCount();
        }
        return httpResponse;
    }

    @Override
    public void receiveResponseEntity(HttpResponse httpResponse) throws HttpException, IOException {
        Args.notNull(httpResponse, "HTTP response");
        this.ensureOpen();
        HttpEntity httpEntity = this.prepareInput(httpResponse);
        httpResponse.setEntity(httpEntity);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.doFlush();
    }
}

