/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io;

import com.ibm.cognos.externals.org.apache.http_4_4_14.ConnectionClosedException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.MalformedChunkCodingException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.TruncatedChunkException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.MessageConstraints;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.AbstractMessageParser;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.BufferInfo;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.SessionInputBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private static final int CHUNK_LEN = 1;
    private static final int CHUNK_DATA = 2;
    private static final int CHUNK_CRLF = 3;
    private static final int CHUNK_INVALID = Integer.MAX_VALUE;
    private static final int BUFFER_SIZE = 2048;
    private final SessionInputBuffer in;
    private final CharArrayBuffer buffer;
    private final MessageConstraints constraints;
    private int state;
    private long chunkSize;
    private long pos;
    private boolean eof = false;
    private boolean closed = false;
    private Header[] footers = new Header[0];

    public ChunkedInputStream(SessionInputBuffer sessionInputBuffer, MessageConstraints messageConstraints) {
        this.in = Args.notNull(sessionInputBuffer, "Session input buffer");
        this.pos = 0L;
        this.buffer = new CharArrayBuffer(16);
        this.constraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.state = 1;
    }

    public ChunkedInputStream(SessionInputBuffer sessionInputBuffer) {
        this(sessionInputBuffer, null);
    }

    @Override
    public int available() throws IOException {
        if (this.in instanceof BufferInfo) {
            int n2 = ((BufferInfo)((Object)this.in)).length();
            return (int)Math.min((long)n2, this.chunkSize - this.pos);
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        int n2;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != 2) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((n2 = this.in.read()) != -1) {
            ++this.pos;
            if (this.pos >= this.chunkSize) {
                this.state = 3;
            }
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != 2) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((n4 = this.in.read(byArray, n2, (int)Math.min((long)n3, this.chunkSize - this.pos))) != -1) {
            this.pos += (long)n4;
            if (this.pos >= this.chunkSize) {
                this.state = 3;
            }
            return n4;
        }
        this.eof = true;
        throw new TruncatedChunkException("Truncated chunk (expected size: %,d; actual size: %,d)", this.chunkSize, this.pos);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private void nextChunk() throws IOException {
        if (this.state == Integer.MAX_VALUE) {
            throw new MalformedChunkCodingException("Corrupt data stream");
        }
        try {
            this.chunkSize = this.getChunkSize();
            if (this.chunkSize < 0L) {
                throw new MalformedChunkCodingException("Negative chunk size");
            }
            this.state = 2;
            this.pos = 0L;
            if (this.chunkSize == 0L) {
                this.eof = true;
                this.parseTrailerHeaders();
            }
        }
        catch (MalformedChunkCodingException malformedChunkCodingException) {
            this.state = Integer.MAX_VALUE;
            throw malformedChunkCodingException;
        }
    }

    private long getChunkSize() throws IOException {
        int n2 = this.state;
        switch (n2) {
            case 3: {
                this.buffer.clear();
                int n3 = this.in.readLine(this.buffer);
                if (n3 == -1) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
                if (!this.buffer.isEmpty()) {
                    throw new MalformedChunkCodingException("Unexpected content at the end of chunk");
                }
                this.state = 1;
            }
            case 1: {
                this.buffer.clear();
                int n4 = this.in.readLine(this.buffer);
                if (n4 == -1) {
                    throw new ConnectionClosedException("Premature end of chunk coded message body: closing chunk expected");
                }
                int n5 = this.buffer.indexOf(59);
                if (n5 < 0) {
                    n5 = this.buffer.length();
                }
                String string = this.buffer.substringTrimmed(0, n5);
                try {
                    return Long.parseLong(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedChunkCodingException("Bad chunk header: " + string);
                }
            }
        }
        throw new IllegalStateException("Inconsistent codec state");
    }

    private void parseTrailerHeaders() throws IOException {
        try {
            this.footers = AbstractMessageParser.parseHeaders(this.in, this.constraints.getMaxHeaderCount(), this.constraints.getMaxLineLength(), null);
        }
        catch (HttpException httpException) {
            MalformedChunkCodingException malformedChunkCodingException = new MalformedChunkCodingException("Invalid footer: " + httpException.getMessage());
            malformedChunkCodingException.initCause(httpException);
            throw malformedChunkCodingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof && this.state != Integer.MAX_VALUE) {
                    byte[] byArray = new byte[2048];
                    while (this.read(byArray) >= 0) {
                    }
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    public Header[] getFooters() {
        return (Header[])this.footers.clone();
    }
}

