/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io;

import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.HttpTransportMetricsImpl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.BufferInfo;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpTransportMetrics;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.SessionOutputBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Asserts;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.ByteArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class SessionOutputBufferImpl
implements BufferInfo,
SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final HttpTransportMetricsImpl metrics;
    private final ByteArrayBuffer buffer;
    private final int fragementSizeHint;
    private final CharsetEncoder encoder;
    private OutputStream outStream;
    private ByteBuffer bbuf;

    public SessionOutputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2, int n3, CharsetEncoder charsetEncoder) {
        Args.positive(n2, "Buffer size");
        Args.notNull(httpTransportMetricsImpl, "HTTP transport metrcis");
        this.metrics = httpTransportMetricsImpl;
        this.buffer = new ByteArrayBuffer(n2);
        this.fragementSizeHint = n3 >= 0 ? n3 : 0;
        this.encoder = charsetEncoder;
    }

    public SessionOutputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2) {
        this(httpTransportMetricsImpl, n2, n2, null);
    }

    public void bind(OutputStream outputStream) {
        this.outStream = outputStream;
    }

    public boolean isBound() {
        return this.outStream != null;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int length() {
        return this.buffer.length();
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    private void streamWrite(byte[] byArray, int n2, int n3) throws IOException {
        Asserts.notNull(this.outStream, "Output stream");
        this.outStream.write(byArray, n2, n3);
    }

    private void flushStream() throws IOException {
        if (this.outStream != null) {
            this.outStream.flush();
        }
    }

    private void flushBuffer() throws IOException {
        int n2 = this.buffer.length();
        if (n2 > 0) {
            this.streamWrite(this.buffer.buffer(), 0, n2);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(n2);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.flushStream();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            return;
        }
        if (n3 > this.fragementSizeHint || n3 > this.buffer.capacity()) {
            this.flushBuffer();
            this.streamWrite(byArray, n2, n3);
            this.metrics.incrementBytesTransferred(n3);
        } else {
            int n4 = this.buffer.capacity() - this.buffer.length();
            if (n3 > n4) {
                this.flushBuffer();
            }
            this.buffer.append(byArray, n2, n3);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.fragementSizeHint > 0) {
            if (this.buffer.isFull()) {
                this.flushBuffer();
            }
            this.buffer.append(n2);
        } else {
            this.flushBuffer();
            this.outStream.write(n2);
        }
    }

    @Override
    public void writeLine(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (string.length() > 0) {
            if (this.encoder == null) {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    this.write(string.charAt(i2));
                }
            } else {
                CharBuffer charBuffer = CharBuffer.wrap(string);
                this.writeEncoded(charBuffer);
            }
        }
        this.write(CRLF);
    }

    @Override
    public void writeLine(CharArrayBuffer charArrayBuffer) throws IOException {
        if (charArrayBuffer == null) {
            return;
        }
        if (this.encoder == null) {
            int n2;
            int n3 = 0;
            for (int i2 = charArrayBuffer.length(); i2 > 0; i2 -= n2) {
                n2 = this.buffer.capacity() - this.buffer.length();
                if ((n2 = Math.min(n2, i2)) > 0) {
                    this.buffer.append(charArrayBuffer, n3, n2);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                n3 += n2;
            }
        } else {
            CharBuffer charBuffer = CharBuffer.wrap(charArrayBuffer.buffer(), 0, charArrayBuffer.length());
            this.writeEncoded(charBuffer);
        }
        this.write(CRLF);
    }

    private void writeEncoded(CharBuffer charBuffer) throws IOException {
        CoderResult coderResult;
        if (!charBuffer.hasRemaining()) {
            return;
        }
        if (this.bbuf == null) {
            this.bbuf = ByteBuffer.allocate(1024);
        }
        this.encoder.reset();
        while (charBuffer.hasRemaining()) {
            coderResult = this.encoder.encode(charBuffer, this.bbuf, true);
            this.handleEncodingResult(coderResult);
        }
        coderResult = this.encoder.flush(this.bbuf);
        this.handleEncodingResult(coderResult);
        this.bbuf.clear();
    }

    private void handleEncodingResult(CoderResult coderResult) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.bbuf.flip();
        while (this.bbuf.hasRemaining()) {
            this.write(this.bbuf.get());
        }
        this.bbuf.compact();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

