/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.pool;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.ConnectionConfig;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.SocketConfig;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.pool.BasicConnFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.pool.BasicPoolEntry;
import com.ibm.cognos.externals.org.apache.http_4_4_14.params.HttpParams;
import com.ibm.cognos.externals.org.apache.http_4_4_14.pool.AbstractConnPool;
import com.ibm.cognos.externals.org.apache.http_4_4_14.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams httpParams) {
        super(new BasicConnFactory(httpParams), 2, 20);
    }

    public BasicConnPool(SocketConfig socketConfig, ConnectionConfig connectionConfig) {
        super(new BasicConnFactory(socketConfig, connectionConfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost httpHost, HttpClientConnection httpClientConnection) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), httpHost, httpClientConnection);
    }

    @Override
    protected boolean validate(BasicPoolEntry basicPoolEntry) {
        return !((HttpClientConnection)basicPoolEntry.getConnection()).isStale();
    }
}

