/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.protocol;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpRequestHandler;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpRequestHandlerMapper;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.UriPatternMatcher;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriHttpRequestHandlerMapper
implements HttpRequestHandlerMapper {
    private final UriPatternMatcher<HttpRequestHandler> matcher;

    protected UriHttpRequestHandlerMapper(UriPatternMatcher<HttpRequestHandler> uriPatternMatcher) {
        this.matcher = Args.notNull(uriPatternMatcher, "Pattern matcher");
    }

    public UriHttpRequestHandlerMapper() {
        this(new UriPatternMatcher<HttpRequestHandler>());
    }

    public void register(String string, HttpRequestHandler httpRequestHandler) {
        Args.notNull(string, "Pattern");
        Args.notNull(httpRequestHandler, "Handler");
        this.matcher.register(string, httpRequestHandler);
    }

    public void unregister(String string) {
        this.matcher.unregister(string);
    }

    protected String getRequestPath(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getUri();
        int n2 = string.indexOf(63);
        if (n2 != -1) {
            string = string.substring(0, n2);
        } else {
            n2 = string.indexOf(35);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    @Override
    public HttpRequestHandler lookup(HttpRequest httpRequest) {
        Args.notNull(httpRequest, "HTTP request");
        return this.matcher.lookup(this.getRequestPath(httpRequest));
    }
}

