/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.auth;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.LangUtils;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class AuthScope {
    public static final String ANY_HOST = null;
    public static final int ANY_PORT = -1;
    public static final String ANY_REALM = null;
    public static final String ANY_SCHEME = null;
    public static final AuthScope ANY = new AuthScope(ANY_HOST, -1, ANY_REALM, ANY_SCHEME);
    private final String scheme;
    private final String realm;
    private final String host;
    private final int port;
    private final HttpHost origin;

    public AuthScope(String string, int n2, String string2, String string3) {
        this.host = string == null ? ANY_HOST : string.toLowerCase(Locale.ROOT);
        this.port = n2 < 0 ? -1 : n2;
        this.realm = string2 == null ? ANY_REALM : string2;
        this.scheme = string3 == null ? ANY_SCHEME : string3.toUpperCase(Locale.ROOT);
        this.origin = null;
    }

    public AuthScope(HttpHost httpHost, String string, String string2) {
        Args.notNull(httpHost, "Host");
        this.host = httpHost.getHostName().toLowerCase(Locale.ROOT);
        this.port = httpHost.getPort() < 0 ? -1 : httpHost.getPort();
        this.realm = string == null ? ANY_REALM : string;
        this.scheme = string2 == null ? ANY_SCHEME : string2.toUpperCase(Locale.ROOT);
        this.origin = httpHost;
    }

    public AuthScope(HttpHost httpHost) {
        this(httpHost, ANY_REALM, ANY_SCHEME);
    }

    public AuthScope(String string, int n2, String string2) {
        this(string, n2, string2, ANY_SCHEME);
    }

    public AuthScope(String string, int n2) {
        this(string, n2, ANY_REALM, ANY_SCHEME);
    }

    public AuthScope(AuthScope authScope) {
        Args.notNull(authScope, "Scope");
        this.host = authScope.getHost();
        this.port = authScope.getPort();
        this.realm = authScope.getRealm();
        this.scheme = authScope.getScheme();
        this.origin = authScope.getOrigin();
    }

    public HttpHost getOrigin() {
        return this.origin;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int match(AuthScope authScope) {
        int n2 = 0;
        if (LangUtils.equals(this.scheme, authScope.scheme)) {
            ++n2;
        } else if (this.scheme != ANY_SCHEME && authScope.scheme != ANY_SCHEME) {
            return -1;
        }
        if (LangUtils.equals(this.realm, authScope.realm)) {
            n2 += 2;
        } else if (this.realm != ANY_REALM && authScope.realm != ANY_REALM) {
            return -1;
        }
        if (this.port == authScope.port) {
            n2 += 4;
        } else if (this.port != -1 && authScope.port != -1) {
            return -1;
        }
        if (LangUtils.equals(this.host, authScope.host)) {
            n2 += 8;
        } else if (this.host != ANY_HOST && authScope.host != ANY_HOST) {
            return -1;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AuthScope)) {
            return super.equals(object);
        }
        AuthScope authScope = (AuthScope)object;
        return LangUtils.equals(this.host, authScope.host) && this.port == authScope.port && LangUtils.equals(this.realm, authScope.realm) && LangUtils.equals(this.scheme, authScope.scheme);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheme != null) {
            stringBuilder.append(this.scheme.toUpperCase(Locale.ROOT));
            stringBuilder.append(' ');
        }
        if (this.realm != null) {
            stringBuilder.append('\'');
            stringBuilder.append(this.realm);
            stringBuilder.append('\'');
        } else {
            stringBuilder.append("<any realm>");
        }
        if (this.host != null) {
            stringBuilder.append('@');
            stringBuilder.append(this.host);
            if (this.port >= 0) {
                stringBuilder.append(':');
                stringBuilder.append(this.port);
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.host);
        n2 = LangUtils.hashCode(n2, this.port);
        n2 = LangUtils.hashCode(n2, this.realm);
        n2 = LangUtils.hashCode(n2, this.scheme);
        return n2;
    }
}

