/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequestInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthProtocolState;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthScheme;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthScope;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthState;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.Credentials;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.AuthCache;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.CredentialsProvider;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.routing.RouteInfo;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        AuthScheme authScheme;
        Object object;
        AuthState authState;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        AuthCache authCache = httpClientContext.getAuthCache();
        if (authCache == null) {
            this.log.debug("Auth cache not set in the context");
            return;
        }
        CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
        if (credentialsProvider == null) {
            this.log.debug("Credentials provider not set in the context");
            return;
        }
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug("Route info not set in the context");
            return;
        }
        HttpHost httpHost = httpClientContext.getTargetHost();
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        if (httpHost.getPort() < 0) {
            httpHost = new HttpHost(httpHost.getHostName(), routeInfo.getTargetHost().getPort(), httpHost.getSchemeName());
        }
        if ((authState = httpClientContext.getTargetAuthState()) != null && authState.getState() == AuthProtocolState.UNCHALLENGED && (object = authCache.get(httpHost)) != null) {
            this.doPreemptiveAuth(httpHost, (AuthScheme)object, authState, credentialsProvider);
        }
        object = routeInfo.getProxyHost();
        AuthState authState2 = httpClientContext.getProxyAuthState();
        if (object != null && authState2 != null && authState2.getState() == AuthProtocolState.UNCHALLENGED && (authScheme = authCache.get((HttpHost)object)) != null) {
            this.doPreemptiveAuth((HttpHost)object, authScheme, authState2, credentialsProvider);
        }
    }

    private void doPreemptiveAuth(HttpHost httpHost, AuthScheme authScheme, AuthState authState, CredentialsProvider credentialsProvider) {
        AuthScope authScope;
        Credentials credentials;
        String string = authScheme.getSchemeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Re-using cached '" + string + "' auth scheme for " + httpHost);
        }
        if ((credentials = credentialsProvider.getCredentials(authScope = new AuthScope(httpHost, AuthScope.ANY_REALM, string))) != null) {
            authState.update(authScheme, credentials);
        } else {
            this.log.debug("No credentials for preemptive authentication");
        }
    }
}

