/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol;

import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HeaderElement;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponseInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.Lookup;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.RegistryBuilder;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.config.RequestConfig;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.entity.DecompressingEntity;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.entity.DeflateInputStreamFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.entity.GZIPInputStreamFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.entity.InputStreamFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import java.io.IOException;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ResponseContentEncoding(Lookup<InputStreamFactory> lookup, boolean bl2) {
        this.decoderRegistry = lookup != null ? lookup : RegistryBuilder.create().register("gzip", GZIPInputStreamFactory.getInstance()).register("x-gzip", GZIPInputStreamFactory.getInstance()).register("deflate", (GZIPInputStreamFactory)((Object)DeflateInputStreamFactory.getInstance())).build();
        this.ignoreUnknown = bl2;
    }

    public ResponseContentEncoding(boolean bl2) {
        this(null, bl2);
    }

    public ResponseContentEncoding(Lookup<InputStreamFactory> lookup) {
        this(lookup, true);
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Header header;
        HttpEntity httpEntity = httpResponse.getEntity();
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        if (requestConfig.isContentCompressionEnabled() && httpEntity != null && httpEntity.getContentLength() != 0L && (header = httpEntity.getContentEncoding()) != null) {
            HeaderElement[] headerElementArray;
            for (HeaderElement headerElement : headerElementArray = header.getElements()) {
                String string = headerElement.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory inputStreamFactory = this.decoderRegistry.lookup(string);
                if (inputStreamFactory != null) {
                    httpResponse.setEntity(new DecompressingEntity(httpResponse.getEntity(), inputStreamFactory));
                    httpResponse.removeHeaders("Content-Length");
                    httpResponse.removeHeaders("Content-Encoding");
                    httpResponse.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(string) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + headerElement.getName());
            }
        }
    }
}

