/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime;

import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.ContentType;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.Header;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.MinimalField;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.AbstractContentBody;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.ContentBody;

public class FormBodyPart {
    private final String name;
    private final Header header;
    private final ContentBody body;

    FormBodyPart(String string, ContentBody contentBody, Header header) {
        Args.notNull(string, "Name");
        Args.notNull(contentBody, "Body");
        this.name = string;
        this.body = contentBody;
        this.header = header != null ? header : new Header();
    }

    @Deprecated
    public FormBodyPart(String string, ContentBody contentBody) {
        Args.notNull(string, "Name");
        Args.notNull(contentBody, "Body");
        this.name = string;
        this.body = contentBody;
        this.header = new Header();
        this.generateContentDisp(contentBody);
        this.generateContentType(contentBody);
        this.generateTransferEncoding(contentBody);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addField(String string, String string2) {
        Args.notNull(string, "Field name");
        this.header.addField(new MinimalField(string, string2));
    }

    @Deprecated
    protected void generateContentDisp(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("form-data; name=\"");
        stringBuilder.append(this.getName());
        stringBuilder.append("\"");
        if (contentBody.getFilename() != null) {
            stringBuilder.append("; filename=\"");
            stringBuilder.append(contentBody.getFilename());
            stringBuilder.append("\"");
        }
        this.addField("Content-Disposition", stringBuilder.toString());
    }

    @Deprecated
    protected void generateContentType(ContentBody contentBody) {
        ContentType contentType = contentBody instanceof AbstractContentBody ? ((AbstractContentBody)contentBody).getContentType() : null;
        if (contentType != null) {
            this.addField("Content-Type", contentType.toString());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(contentBody.getMimeType());
            if (contentBody.getCharset() != null) {
                stringBuilder.append("; charset=");
                stringBuilder.append(contentBody.getCharset());
            }
            this.addField("Content-Type", stringBuilder.toString());
        }
    }

    @Deprecated
    protected void generateTransferEncoding(ContentBody contentBody) {
        this.addField("Content-Transfer-Encoding", contentBody.getTransferEncoding());
    }
}

