/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime;

import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.ContentType;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Asserts;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.FormBodyPart;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.Header;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.MinimalField;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.AbstractContentBody;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.ContentBody;
import java.util.List;

public class FormBodyPartBuilder {
    private String name;
    private ContentBody body;
    private final Header header = new Header();

    public static FormBodyPartBuilder create(String string, ContentBody contentBody) {
        return new FormBodyPartBuilder(string, contentBody);
    }

    public static FormBodyPartBuilder create() {
        return new FormBodyPartBuilder();
    }

    FormBodyPartBuilder(String string, ContentBody contentBody) {
        this();
        this.name = string;
        this.body = contentBody;
    }

    FormBodyPartBuilder() {
    }

    public FormBodyPartBuilder setName(String string) {
        this.name = string;
        return this;
    }

    public FormBodyPartBuilder setBody(ContentBody contentBody) {
        this.body = contentBody;
        return this;
    }

    public FormBodyPartBuilder addField(String string, String string2) {
        Args.notNull(string, "Field name");
        this.header.addField(new MinimalField(string, string2));
        return this;
    }

    public FormBodyPartBuilder setField(String string, String string2) {
        Args.notNull(string, "Field name");
        this.header.setField(new MinimalField(string, string2));
        return this;
    }

    public FormBodyPartBuilder removeFields(String string) {
        Args.notNull(string, "Field name");
        this.header.removeFields(string);
        return this;
    }

    public FormBodyPart build() {
        Object object;
        Asserts.notBlank(this.name, "Name");
        Asserts.notNull(this.body, "Content body");
        Header header = new Header();
        List<MinimalField> list = this.header.getFields();
        for (MinimalField object2 : list) {
            header.addField(object2);
        }
        if (header.getField("Content-Disposition") == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("form-data; name=\"");
            ((StringBuilder)object).append(FormBodyPartBuilder.encodeForHeader(this.name));
            ((StringBuilder)object).append("\"");
            if (this.body.getFilename() != null) {
                ((StringBuilder)object).append("; filename=\"");
                ((StringBuilder)object).append(FormBodyPartBuilder.encodeForHeader(this.body.getFilename()));
                ((StringBuilder)object).append("\"");
            }
            header.addField(new MinimalField("Content-Disposition", ((StringBuilder)object).toString()));
        }
        if (header.getField("Content-Type") == null) {
            object = this.body instanceof AbstractContentBody ? ((AbstractContentBody)this.body).getContentType() : null;
            if (object != null) {
                header.addField(new MinimalField("Content-Type", ((ContentType)object).toString()));
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.body.getMimeType());
                if (this.body.getCharset() != null) {
                    stringBuilder.append("; charset=");
                    stringBuilder.append(this.body.getCharset());
                }
                header.addField(new MinimalField("Content-Type", stringBuilder.toString()));
            }
        }
        if (header.getField("Content-Transfer-Encoding") == null) {
            header.addField(new MinimalField("Content-Transfer-Encoding", this.body.getTransferEncoding()));
        }
        return new FormBodyPart(this.name, this.body, header);
    }

    private static String encodeForHeader(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"' || c2 == '\\' || c2 == '\r') {
                stringBuilder.append("\\");
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

