/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.NameValuePair;
import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.ContentType;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.BasicNameValuePair;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.AbstractMultipartForm;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.FormBodyPart;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.FormBodyPartBuilder;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.HttpBrowserCompatibleMultipart;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.HttpMultipartMode;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.HttpRFC6532Multipart;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.HttpStrictMultipart;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.MultipartFormEntity;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.ByteArrayBody;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.ContentBody;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.FileBody;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.InputStreamBody;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.StringBody;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class MultipartEntityBuilder {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final String DEFAULT_SUBTYPE = "form-data";
    private ContentType contentType;
    private HttpMultipartMode mode = HttpMultipartMode.STRICT;
    private String boundary = null;
    private Charset charset = null;
    private List<FormBodyPart> bodyParts = null;

    public static MultipartEntityBuilder create() {
        return new MultipartEntityBuilder();
    }

    MultipartEntityBuilder() {
    }

    public MultipartEntityBuilder setMode(HttpMultipartMode httpMultipartMode) {
        this.mode = httpMultipartMode;
        return this;
    }

    public MultipartEntityBuilder setLaxMode() {
        this.mode = HttpMultipartMode.BROWSER_COMPATIBLE;
        return this;
    }

    public MultipartEntityBuilder setStrictMode() {
        this.mode = HttpMultipartMode.STRICT;
        return this;
    }

    public MultipartEntityBuilder setBoundary(String string) {
        this.boundary = string;
        return this;
    }

    public MultipartEntityBuilder setMimeSubtype(String string) {
        Args.notBlank(string, "MIME subtype");
        this.contentType = ContentType.create("multipart/" + string);
        return this;
    }

    @Deprecated
    public MultipartEntityBuilder seContentType(ContentType contentType) {
        return this.setContentType(contentType);
    }

    public MultipartEntityBuilder setContentType(ContentType contentType) {
        Args.notNull(contentType, "Content type");
        this.contentType = contentType;
        return this;
    }

    public MultipartEntityBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public MultipartEntityBuilder addPart(FormBodyPart formBodyPart) {
        if (formBodyPart == null) {
            return this;
        }
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<FormBodyPart>();
        }
        this.bodyParts.add(formBodyPart);
        return this;
    }

    public MultipartEntityBuilder addPart(String string, ContentBody contentBody) {
        Args.notNull(string, "Name");
        Args.notNull(contentBody, "Content body");
        return this.addPart(FormBodyPartBuilder.create(string, contentBody).build());
    }

    public MultipartEntityBuilder addTextBody(String string, String string2, ContentType contentType) {
        return this.addPart(string, new StringBody(string2, contentType));
    }

    public MultipartEntityBuilder addTextBody(String string, String string2) {
        return this.addTextBody(string, string2, ContentType.DEFAULT_TEXT);
    }

    public MultipartEntityBuilder addBinaryBody(String string, byte[] byArray, ContentType contentType, String string2) {
        return this.addPart(string, new ByteArrayBody(byArray, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, byte[] byArray) {
        return this.addBinaryBody(string, byArray, ContentType.DEFAULT_BINARY, null);
    }

    public MultipartEntityBuilder addBinaryBody(String string, File file, ContentType contentType, String string2) {
        return this.addPart(string, new FileBody(file, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, File file) {
        return this.addBinaryBody(string, file, ContentType.DEFAULT_BINARY, file != null ? file.getName() : null);
    }

    public MultipartEntityBuilder addBinaryBody(String string, InputStream inputStream, ContentType contentType, String string2) {
        return this.addPart(string, new InputStreamBody(inputStream, contentType, string2));
    }

    public MultipartEntityBuilder addBinaryBody(String string, InputStream inputStream) {
        return this.addBinaryBody(string, inputStream, ContentType.DEFAULT_BINARY, null);
    }

    private String generateBoundary() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        int n2 = random.nextInt(11) + 30;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)]);
        }
        return stringBuilder.toString();
    }

    MultipartFormEntity buildEntity() {
        AbstractMultipartForm abstractMultipartForm;
        Charset charset;
        String string = this.boundary;
        if (string == null && this.contentType != null) {
            string = this.contentType.getParameter("boundary");
        }
        if (string == null) {
            string = this.generateBoundary();
        }
        if ((charset = this.charset) == null && this.contentType != null) {
            charset = this.contentType.getCharset();
        }
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        arrayList.add(new BasicNameValuePair("boundary", string));
        if (charset != null) {
            arrayList.add(new BasicNameValuePair("charset", charset.name()));
        }
        NameValuePair[] nameValuePairArray = arrayList.toArray(new NameValuePair[arrayList.size()]);
        ContentType contentType = this.contentType != null ? this.contentType.withParameters(nameValuePairArray) : ContentType.create("multipart/form-data", nameValuePairArray);
        ArrayList<FormBodyPart> arrayList2 = this.bodyParts != null ? new ArrayList<FormBodyPart>(this.bodyParts) : Collections.emptyList();
        HttpMultipartMode httpMultipartMode = this.mode != null ? this.mode : HttpMultipartMode.STRICT;
        switch (httpMultipartMode) {
            case BROWSER_COMPATIBLE: {
                abstractMultipartForm = new HttpBrowserCompatibleMultipart(charset, string, arrayList2);
                break;
            }
            case RFC6532: {
                abstractMultipartForm = new HttpRFC6532Multipart(charset, string, arrayList2);
                break;
            }
            default: {
                abstractMultipartForm = new HttpStrictMultipart(charset, string, arrayList2);
            }
        }
        return new MultipartFormEntity(abstractMultipartForm, contentType, abstractMultipartForm.getTotalLength());
    }

    public HttpEntity build() {
        return this.buildEntity();
    }
}

