/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Asserts;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.CircularRedirectException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.RedirectStrategy;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.config.RequestConfig;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpGet;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpHead;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpUriRequest;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.RequestBuilder;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.utils.URIUtils;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client.RedirectLocations;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultRedirectStrategy
implements RedirectStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final int SC_PERMANENT_REDIRECT = 308;
    @Deprecated
    public static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    public static final DefaultRedirectStrategy INSTANCE = new DefaultRedirectStrategy();
    private final String[] redirectMethods;

    public DefaultRedirectStrategy() {
        this(new String[]{"GET", "HEAD"});
    }

    public DefaultRedirectStrategy(String[] stringArray) {
        Object[] objectArray = (String[])stringArray.clone();
        Arrays.sort(objectArray);
        this.redirectMethods = objectArray;
    }

    @Override
    public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpResponse, "HTTP response");
        int n2 = httpResponse.getStatusLine().getStatusCode();
        String string = httpRequest.getRequestLine().getMethod();
        Header header = httpResponse.getFirstHeader("location");
        switch (n2) {
            case 302: {
                return this.isRedirectable(string) && header != null;
            }
            case 301: 
            case 307: 
            case 308: {
                return this.isRedirectable(string);
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        Object object;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpResponse, "HTTP response");
        Args.notNull(httpContext, "HTTP context");
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        Header header = httpResponse.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        String string = header.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redirect requested to location '" + string + "'");
        }
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        URI uRI = this.createLocationURI(string);
        try {
            if (requestConfig.isNormalizeUri()) {
                uRI = URIUtils.normalizeSyntax(uRI);
            }
            if (!uRI.isAbsolute()) {
                if (!requestConfig.isRelativeRedirectsAllowed()) {
                    throw new ProtocolException("Relative redirect location '" + uRI + "' not allowed");
                }
                object = httpClientContext.getTargetHost();
                Asserts.notNull(object, "Target host");
                URI uRI2 = new URI(httpRequest.getRequestLine().getUri());
                URI uRI3 = URIUtils.rewriteURI(uRI2, (HttpHost)object, requestConfig.isNormalizeUri() ? URIUtils.NORMALIZE : URIUtils.NO_FLAGS);
                uRI = URIUtils.resolve(uRI3, uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
        object = (RedirectLocations)httpClientContext.getAttribute(REDIRECT_LOCATIONS);
        if (object == null) {
            object = new RedirectLocations();
            httpContext.setAttribute(REDIRECT_LOCATIONS, object);
        }
        if (!requestConfig.isCircularRedirectsAllowed() && ((RedirectLocations)object).contains(uRI)) {
            throw new CircularRedirectException("Circular redirect to '" + uRI + "'");
        }
        ((RedirectLocations)object).add(uRI);
        return uRI;
    }

    protected URI createLocationURI(String string) throws ProtocolException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, uRISyntaxException);
        }
    }

    protected boolean isRedirectable(String string) {
        return Arrays.binarySearch(this.redirectMethods, string) >= 0;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        URI uRI = this.getLocationURI(httpRequest, httpResponse, httpContext);
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uRI);
        }
        if (string.equalsIgnoreCase("GET")) {
            return new HttpGet(uRI);
        }
        int n2 = httpResponse.getStatusLine().getStatusCode();
        return n2 == 307 || n2 == 308 ? RequestBuilder.copy(httpRequest).setUri(uRI).build() : new HttpGet(uRI);
    }
}

