/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.params.HttpConnectionParams;
import com.ibm.cognos.externals.org.apache.http_4_4_14.params.HttpParams;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Asserts;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.ClientConnectionOperator;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.ConnectTimeoutException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.DnsResolver;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.HttpInetSocketAddress;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.OperatedClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.scheme.Scheme;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.scheme.SchemeLayeredSocketFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.scheme.SchemeRegistry;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.scheme.SchemeSocketFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn.DefaultClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn.SystemDefaultDnsResolver;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class DefaultClientConnectionOperator
implements ClientConnectionOperator {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final SchemeRegistry schemeRegistry;
    protected final DnsResolver dnsResolver;

    public DefaultClientConnectionOperator(SchemeRegistry schemeRegistry) {
        Args.notNull(schemeRegistry, "Scheme registry");
        this.schemeRegistry = schemeRegistry;
        this.dnsResolver = new SystemDefaultDnsResolver();
    }

    public DefaultClientConnectionOperator(SchemeRegistry schemeRegistry, DnsResolver dnsResolver) {
        Args.notNull(schemeRegistry, "Scheme registry");
        Args.notNull(dnsResolver, "DNS resolver");
        this.schemeRegistry = schemeRegistry;
        this.dnsResolver = dnsResolver;
    }

    @Override
    public OperatedClientConnection createConnection() {
        return new DefaultClientConnection();
    }

    private SchemeRegistry getSchemeRegistry(HttpContext httpContext) {
        SchemeRegistry schemeRegistry = (SchemeRegistry)httpContext.getAttribute("http.scheme-registry");
        if (schemeRegistry == null) {
            schemeRegistry = this.schemeRegistry;
        }
        return schemeRegistry;
    }

    @Override
    public void openConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, InetAddress inetAddress, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Args.notNull(operatedClientConnection, "Connection");
        Args.notNull(httpHost, "Target host");
        Args.notNull(httpParams, "HTTP parameters");
        Asserts.check(!operatedClientConnection.isOpen(), "Connection must not be open");
        SchemeRegistry schemeRegistry = this.getSchemeRegistry(httpContext);
        Scheme scheme = schemeRegistry.getScheme(httpHost.getSchemeName());
        SchemeSocketFactory schemeSocketFactory = scheme.getSchemeSocketFactory();
        InetAddress[] inetAddressArray = this.resolveHostname(httpHost.getHostName());
        int n2 = scheme.resolvePort(httpHost.getPort());
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            HttpInetSocketAddress httpInetSocketAddress;
            block8: {
                InetAddress inetAddress2 = inetAddressArray[i2];
                boolean bl2 = i2 == inetAddressArray.length - 1;
                Socket socket = schemeSocketFactory.createSocket(httpParams);
                operatedClientConnection.opening(socket, httpHost);
                httpInetSocketAddress = new HttpInetSocketAddress(httpHost, inetAddress2, n2);
                InetSocketAddress inetSocketAddress = null;
                if (inetAddress != null) {
                    inetSocketAddress = new InetSocketAddress(inetAddress, 0);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connecting to " + httpInetSocketAddress);
                }
                try {
                    Socket socket2 = schemeSocketFactory.connectSocket(socket, httpInetSocketAddress, inetSocketAddress, httpParams);
                    if (socket != socket2) {
                        socket = socket2;
                        operatedClientConnection.opening(socket, httpHost);
                    }
                    this.prepareSocket(socket, httpContext, httpParams);
                    operatedClientConnection.openCompleted(schemeSocketFactory.isSecure(socket), httpParams);
                    return;
                }
                catch (ConnectException connectException) {
                    if (bl2) {
                        throw connectException;
                    }
                }
                catch (ConnectTimeoutException connectTimeoutException) {
                    if (!bl2) break block8;
                    throw connectTimeoutException;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Connect to " + httpInetSocketAddress + " timed out. " + "Connection will be retried using another IP address");
        }
    }

    @Override
    public void updateSecureConnection(OperatedClientConnection operatedClientConnection, HttpHost httpHost, HttpContext httpContext, HttpParams httpParams) throws IOException {
        Args.notNull(operatedClientConnection, "Connection");
        Args.notNull(httpHost, "Target host");
        Args.notNull(httpParams, "Parameters");
        Asserts.check(operatedClientConnection.isOpen(), "Connection must be open");
        SchemeRegistry schemeRegistry = this.getSchemeRegistry(httpContext);
        Scheme scheme = schemeRegistry.getScheme(httpHost.getSchemeName());
        Asserts.check(scheme.getSchemeSocketFactory() instanceof SchemeLayeredSocketFactory, "Socket factory must implement SchemeLayeredSocketFactory");
        SchemeLayeredSocketFactory schemeLayeredSocketFactory = (SchemeLayeredSocketFactory)scheme.getSchemeSocketFactory();
        Socket socket = schemeLayeredSocketFactory.createLayeredSocket(operatedClientConnection.getSocket(), httpHost.getHostName(), scheme.resolvePort(httpHost.getPort()), httpParams);
        this.prepareSocket(socket, httpContext, httpParams);
        operatedClientConnection.update(socket, httpHost, schemeLayeredSocketFactory.isSecure(socket), httpParams);
    }

    protected void prepareSocket(Socket socket, HttpContext httpContext, HttpParams httpParams) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(httpParams));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(httpParams));
        int n2 = HttpConnectionParams.getLinger(httpParams);
        if (n2 >= 0) {
            socket.setSoLinger(n2 > 0, n2);
        }
    }

    protected InetAddress[] resolveHostname(String string) throws UnknownHostException {
        return this.dnsResolver.resolve(string);
    }
}

