/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.MessageConstraints;
import com.ibm.cognos.externals.org.apache.http_4_4_14.entity.ContentLengthStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpMessageParserFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpMessageWriterFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn.DefaultManagedHttpClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn.LoggingInputStream;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn.LoggingOutputStream;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

class LoggingManagedHttpClientConnection
extends DefaultManagedHttpClientConnection {
    private final Log log;
    private final Log headerLog;
    private final Wire wire;

    public LoggingManagedHttpClientConnection(String string, Log log, Log log2, Log log3, int n2, int n3, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, MessageConstraints messageConstraints, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, HttpMessageWriterFactory<HttpRequest> httpMessageWriterFactory, HttpMessageParserFactory<HttpResponse> httpMessageParserFactory) {
        super(string, n2, n3, charsetDecoder, charsetEncoder, messageConstraints, contentLengthStrategy, contentLengthStrategy2, httpMessageWriterFactory, httpMessageParserFactory);
        this.log = log;
        this.headerLog = log2;
        this.wire = new Wire(log3, string);
    }

    @Override
    public void close() throws IOException {
        if (super.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getId() + ": Close connection");
            }
            super.close();
        }
    }

    @Override
    public void setSocketTimeout(int n2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ": set socket timeout to " + n2);
        }
        super.setSocketTimeout(n2);
    }

    @Override
    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ": Shutdown connection");
        }
        super.shutdown();
    }

    @Override
    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        InputStream inputStream = super.getSocketInputStream(socket);
        if (this.wire.enabled()) {
            inputStream = new LoggingInputStream(inputStream, this.wire);
        }
        return inputStream;
    }

    @Override
    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        OutputStream outputStream = super.getSocketOutputStream(socket);
        if (this.wire.enabled()) {
            outputStream = new LoggingOutputStream(outputStream, this.wire);
        }
        return outputStream;
    }

    @Override
    protected void onResponseReceived(HttpResponse httpResponse) {
        if (httpResponse != null && this.headerLog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerLog.debug(this.getId() + " << " + httpResponse.getStatusLine().toString());
            for (Header header : headerArray = httpResponse.getAllHeaders()) {
                this.headerLog.debug(this.getId() + " << " + header.toString());
            }
        }
    }

    @Override
    protected void onRequestSubmitted(HttpRequest httpRequest) {
        if (httpRequest != null && this.headerLog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerLog.debug(this.getId() + " >> " + httpRequest.getRequestLine().toString());
            for (Header header : headerArray = httpRequest.getAllHeaders()) {
                this.headerLog.debug(this.getId() + " >> " + header.toString());
            }
        }
    }
}

