/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie;

import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CommonCookieAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.MalformedCookieException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.SetCookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.AbstractCookieAttributeHandler;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        int n2;
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + string);
        }
        if (n2 < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + string);
        }
        setCookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)n2 * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

