/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie;

import com.ibm.cognos.externals.org.apache.http_4_4_14.FormattedHeader;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HeaderElement;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.ParserCursor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CommonCookieAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.Cookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieOrigin;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieSpec;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.MalformedCookieException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.SetCookie2;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicCommentHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicDomainHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicExpiresHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicMaxAgeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicPathHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicSecureHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.NetscapeDraftHeaderParser;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.NetscapeDraftSpec;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2109DomainHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2109Spec;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2109VersionHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965DiscardAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965DomainAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965PortAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965Spec;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965VersionAttributeHandler;
import java.util.List;

@Contract(threading=ThreadingBehavior.SAFE)
public class DefaultCookieSpec
implements CookieSpec {
    private final RFC2965Spec strict;
    private final RFC2109Spec obsoleteStrict;
    private final NetscapeDraftSpec netscapeDraft;

    DefaultCookieSpec(RFC2965Spec rFC2965Spec, RFC2109Spec rFC2109Spec, NetscapeDraftSpec netscapeDraftSpec) {
        this.strict = rFC2965Spec;
        this.obsoleteStrict = rFC2109Spec;
        this.netscapeDraft = netscapeDraftSpec;
    }

    public DefaultCookieSpec(String[] stringArray, boolean bl2) {
        String[] stringArray2;
        this.strict = new RFC2965Spec(bl2, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), new RFC2965DomainAttributeHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
        this.obsoleteStrict = new RFC2109Spec(bl2, new RFC2109VersionHandler(), new BasicPathHandler(), new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler());
        CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
        commonCookieAttributeHandlerArray[0] = new BasicDomainHandler();
        commonCookieAttributeHandlerArray[1] = new BasicPathHandler();
        commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
        commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
        if (stringArray != null) {
            stringArray2 = (String[])stringArray.clone();
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "EEE, dd-MMM-yy HH:mm:ss z";
        }
        commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray2);
        this.netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
    }

    public DefaultCookieSpec() {
        this(null, false);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(cookieOrigin, "Cookie origin");
        HeaderElement[] headerElementArray = header.getElements();
        boolean bl2 = false;
        boolean bl3 = false;
        for (HeaderElement object : headerElementArray) {
            if (object.getParameterByName("version") != null) {
                bl2 = true;
            }
            if (object.getParameterByName("expires") == null) continue;
            bl3 = true;
        }
        if (bl3 || !bl2) {
            ParserCursor parserCursor;
            CharArrayBuffer charArrayBuffer;
            NetscapeDraftHeaderParser netscapeDraftHeaderParser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                charArrayBuffer = ((FormattedHeader)header).getBuffer();
                parserCursor = new ParserCursor(((FormattedHeader)header).getValuePos(), charArrayBuffer.length());
            } else {
                String string = header.getValue();
                if (string == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                charArrayBuffer = new CharArrayBuffer(string.length());
                charArrayBuffer.append(string);
                parserCursor = new ParserCursor(0, charArrayBuffer.length());
            }
            headerElementArray = new HeaderElement[]{netscapeDraftHeaderParser.parseHeader(charArrayBuffer, parserCursor)};
            return this.netscapeDraft.parse(headerElementArray, cookieOrigin);
        }
        return "Set-Cookie2".equals(header.getName()) ? this.strict.parse(headerElementArray, cookieOrigin) : this.obsoleteStrict.parse(headerElementArray, cookieOrigin);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                this.strict.validate(cookie, cookieOrigin);
            } else {
                this.obsoleteStrict.validate(cookie, cookieOrigin);
            }
        } else {
            this.netscapeDraft.validate(cookie, cookieOrigin);
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        if (cookie.getVersion() > 0) {
            return cookie instanceof SetCookie2 ? this.strict.match(cookie, cookieOrigin) : this.obsoleteStrict.match(cookie, cookieOrigin);
        }
        return this.netscapeDraft.match(cookie, cookieOrigin);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> list) {
        Args.notNull(list, "List of cookies");
        int n2 = Integer.MAX_VALUE;
        boolean bl2 = true;
        for (Cookie cookie : list) {
            if (!(cookie instanceof SetCookie2)) {
                bl2 = false;
            }
            if (cookie.getVersion() >= n2) continue;
            n2 = cookie.getVersion();
        }
        if (n2 > 0) {
            return bl2 ? this.strict.formatCookies(list) : this.obsoleteStrict.formatCookies(list);
        }
        return this.netscapeDraft.formatCookies(list);
    }

    @Override
    public int getVersion() {
        return this.strict.getVersion();
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "default";
    }
}

