/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie;

import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.TextUtils;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CommonCookieAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.MalformedCookieException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.SetCookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.AbstractCookieAttributeHandler;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class LaxMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile("^\\-?[0-9]+$");

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (TextUtils.isBlank(string)) {
            return;
        }
        Matcher matcher = MAX_AGE_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n2;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            Date date = n2 >= 0 ? new Date(System.currentTimeMillis() + (long)n2 * 1000L) : new Date(Long.MIN_VALUE);
            setCookie.setExpiryDate(date);
        }
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

