/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie;

import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.TextUtils;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.Cookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieOrigin;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieRestrictionViolationException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.MalformedCookieException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.SetCookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicDomainHandler;
import java.util.Locale;
import java.util.StringTokenizer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class NetscapeDomainHandler
extends BasicDomainHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (TextUtils.isBlank(string)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        setCookie.setDomain(string);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        String string;
        String string2 = cookieOrigin.getHost();
        if (!string2.equals(string = cookie.getDomain()) && !BasicDomainHandler.domainMatch(string, string2)) {
            throw new CookieRestrictionViolationException("Illegal domain attribute \"" + string + "\". Domain of origin: \"" + string2 + "\"");
        }
        if (string2.contains(".")) {
            int n2 = new StringTokenizer(string, ".").countTokens();
            if (NetscapeDomainHandler.isSpecialDomain(string)) {
                if (n2 < 2) {
                    throw new CookieRestrictionViolationException("Domain attribute \"" + string + "\" violates the Netscape cookie specification for " + "special domains");
                }
            } else if (n2 < 3) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + string + "\" violates the Netscape cookie specification");
            }
        }
    }

    private static boolean isSpecialDomain(String string) {
        String string2 = string.toUpperCase(Locale.ROOT);
        return string2.endsWith(".COM") || string2.endsWith(".EDU") || string2.endsWith(".NET") || string2.endsWith(".GOV") || string2.endsWith(".MIL") || string2.endsWith(".ORG") || string2.endsWith(".INT");
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        String string = cookieOrigin.getHost();
        String string2 = cookie.getDomain();
        if (string2 == null) {
            return false;
        }
        return string.endsWith(string2);
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

