/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.BackoffManager;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.ConnectionBackoffStrategy;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.CloseableHttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpExecutionAware;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpRequestWrapper;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.routing.HttpRoute;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.ClientExecChain;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BackoffStrategyExec
implements ClientExecChain {
    private final ClientExecChain requestExecutor;
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ClientExecChain clientExecChain, ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(clientExecChain, "HTTP client request executor");
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.requestExecutor = clientExecChain;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Args.notNull(httpRoute, "HTTP route");
        Args.notNull(httpRequestWrapper, "HTTP request");
        Args.notNull(httpClientContext, "HTTP context");
        Closeable closeable = null;
        try {
            closeable = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
        }
        catch (Exception exception) {
            if (closeable != null) {
                closeable.close();
            }
            if (this.connectionBackoffStrategy.shouldBackoff(exception)) {
                this.backoffManager.backOff(httpRoute);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof HttpException) {
                throw (HttpException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        if (this.connectionBackoffStrategy.shouldBackoff((HttpResponse)((Object)closeable))) {
            this.backoffManager.backOff(httpRoute);
        } else {
            this.backoffManager.probe(httpRoute);
        }
        return closeable;
    }
}

