/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ConnectionReuseStrategy;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpProcessor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpRequestExecutor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.ImmutableHttpProcessor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.RequestContent;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.RequestTargetHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.RequestUserAgent;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.VersionInfo;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.config.RequestConfig;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.CloseableHttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpExecutionAware;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpRequestWrapper;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.methods.HttpUriRequest;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.RequestClientConnControl;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.utils.URIUtils;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.ConnectionKeepAliveStrategy;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.ConnectionRequest;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.HttpClientConnectionManager;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.routing.HttpRoute;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn.ConnectionShutdownException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.ClientExecChain;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.ConnectionHolder;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.HttpResponseProxy;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.execchain.RequestAbortedException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor httpRequestExecutor, HttpClientConnectionManager httpClientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        Args.notNull(httpRequestExecutor, "HTTP request executor");
        Args.notNull(httpClientConnectionManager, "Client connection manager");
        Args.notNull(connectionReuseStrategy, "Connection reuse strategy");
        Args.notNull(connectionKeepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "com.ibm.cognos.externals.org.apache.http_4_4_14.client", this.getClass())));
        this.requestExecutor = httpRequestExecutor;
        this.connManager = httpClientConnectionManager;
        this.reuseStrategy = connectionReuseStrategy;
        this.keepAliveStrategy = connectionKeepAliveStrategy;
    }

    static void rewriteRequestURI(HttpRequestWrapper httpRequestWrapper, HttpRoute httpRoute, boolean bl2) throws ProtocolException {
        try {
            URI uRI = httpRequestWrapper.getURI();
            if (uRI != null) {
                uRI = uRI.isAbsolute() ? URIUtils.rewriteURI(uRI, null, bl2 ? URIUtils.DROP_FRAGMENT_AND_NORMALIZE : URIUtils.DROP_FRAGMENT) : URIUtils.rewriteURI(uRI);
                httpRequestWrapper.setURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + httpRequestWrapper.getRequestLine().getUri(), uRISyntaxException);
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        HttpClientConnection httpClientConnection;
        Args.notNull(httpRoute, "HTTP route");
        Args.notNull(httpRequestWrapper, "HTTP request");
        Args.notNull(httpClientContext, "HTTP context");
        MinimalClientExec.rewriteRequestURI(httpRequestWrapper, httpRoute, httpClientContext.getRequestConfig().isNormalizeUri());
        ConnectionRequest connectionRequest = this.connManager.requestConnection(httpRoute, null);
        if (httpExecutionAware != null) {
            if (httpExecutionAware.isAborted()) {
                connectionRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            httpExecutionAware.setCancellable(connectionRequest);
        }
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        try {
            int n2 = requestConfig.getConnectionRequestTimeout();
            httpClientConnection = connectionRequest.get(n2 > 0 ? (long)n2 : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable == null) {
                throwable = executionException;
            }
            throw new RequestAbortedException("Request execution failed", throwable);
        }
        ConnectionHolder connectionHolder = new ConnectionHolder(this.log, this.connManager, httpClientConnection);
        try {
            Object object;
            int n3;
            if (httpExecutionAware != null) {
                if (httpExecutionAware.isAborted()) {
                    connectionHolder.close();
                    throw new RequestAbortedException("Request aborted");
                }
                httpExecutionAware.setCancellable(connectionHolder);
            }
            if (!httpClientConnection.isOpen()) {
                n3 = requestConfig.getConnectTimeout();
                this.connManager.connect(httpClientConnection, httpRoute, n3 > 0 ? n3 : 0, httpClientContext);
                this.connManager.routeComplete(httpClientConnection, httpRoute, httpClientContext);
            }
            if ((n3 = requestConfig.getSocketTimeout()) >= 0) {
                httpClientConnection.setSocketTimeout(n3);
            }
            HttpHost httpHost = null;
            HttpRequest httpRequest = httpRequestWrapper.getOriginal();
            if (httpRequest instanceof HttpUriRequest && ((URI)(object = ((HttpUriRequest)httpRequest).getURI())).isAbsolute()) {
                httpHost = new HttpHost(((URI)object).getHost(), ((URI)object).getPort(), ((URI)object).getScheme());
            }
            if (httpHost == null) {
                httpHost = httpRoute.getTargetHost();
            }
            httpClientContext.setAttribute("http.target_host", httpHost);
            httpClientContext.setAttribute("http.request", httpRequestWrapper);
            httpClientContext.setAttribute("http.connection", httpClientConnection);
            httpClientContext.setAttribute("http.route", httpRoute);
            this.httpProcessor.process(httpRequestWrapper, (HttpContext)httpClientContext);
            object = this.requestExecutor.execute(httpRequestWrapper, httpClientConnection, httpClientContext);
            this.httpProcessor.process((HttpResponse)object, (HttpContext)httpClientContext);
            if (this.reuseStrategy.keepAlive((HttpResponse)object, httpClientContext)) {
                long l2 = this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)object, httpClientContext);
                connectionHolder.setValidFor(l2, TimeUnit.MILLISECONDS);
                connectionHolder.markReusable();
            } else {
                connectionHolder.markNonReusable();
            }
            HttpEntity httpEntity = object.getEntity();
            if (httpEntity == null || !httpEntity.isStreaming()) {
                connectionHolder.releaseConnection();
                return new HttpResponseProxy((HttpResponse)object, null);
            }
            return new HttpResponseProxy((HttpResponse)object, connectionHolder);
        }
        catch (ConnectionShutdownException connectionShutdownException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("Connection has been shut down");
            interruptedIOException.initCause(connectionShutdownException);
            throw interruptedIOException;
        }
        catch (HttpException httpException) {
            connectionHolder.abortConnection();
            throw httpException;
        }
        catch (IOException iOException) {
            connectionHolder.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            connectionHolder.abortConnection();
            throw runtimeException;
        }
        catch (Error error) {
            this.connManager.shutdown();
            throw error;
        }
    }
}

