/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1;

import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.AttributesImpl;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.AutoDetector;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.Element;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.ElementType;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.HTMLScanner;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.HTMLSchema;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.ScanHandler;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.Scanner;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler
implements ScanHandler,
XMLReader,
LexicalHandler {
    private ContentHandler theContentHandler = this;
    private LexicalHandler theLexicalHandler = this;
    private DTDHandler theDTDHandler = this;
    private ErrorHandler theErrorHandler = this;
    private EntityResolver theEntityResolver = this;
    private Schema theSchema;
    private Scanner theScanner;
    private AutoDetector theAutoDetector;
    private static boolean DEFAULT_NAMESPACES = true;
    private static boolean DEFAULT_IGNORE_BOGONS = false;
    private static boolean DEFAULT_BOGONS_EMPTY = false;
    private static boolean DEFAULT_ROOT_BOGONS = true;
    private static boolean DEFAULT_DEFAULT_ATTRIBUTES = true;
    private static boolean DEFAULT_TRANSLATE_COLONS = false;
    private static boolean DEFAULT_RESTART_ELEMENTS = true;
    private static boolean DEFAULT_IGNORABLE_WHITESPACE = false;
    private static boolean DEFAULT_CDATA_ELEMENTS = true;
    private boolean namespaces = DEFAULT_NAMESPACES;
    private boolean ignoreBogons = DEFAULT_IGNORE_BOGONS;
    private boolean bogonsEmpty = DEFAULT_BOGONS_EMPTY;
    private boolean rootBogons = DEFAULT_ROOT_BOGONS;
    private boolean defaultAttributes = DEFAULT_DEFAULT_ATTRIBUTES;
    private boolean translateColons = DEFAULT_TRANSLATE_COLONS;
    private boolean restartElements = DEFAULT_RESTART_ELEMENTS;
    private boolean ignorableWhitespace = DEFAULT_IGNORABLE_WHITESPACE;
    private boolean CDATAElements = DEFAULT_CDATA_ELEMENTS;
    public static final String namespacesFeature = "http://xml.org/sax/features/namespaces";
    public static final String namespacePrefixesFeature = "http://xml.org/sax/features/namespace-prefixes";
    public static final String externalGeneralEntitiesFeature = "http://xml.org/sax/features/external-general-entities";
    public static final String externalParameterEntitiesFeature = "http://xml.org/sax/features/external-parameter-entities";
    public static final String isStandaloneFeature = "http://xml.org/sax/features/is-standalone";
    public static final String lexicalHandlerParameterEntitiesFeature = "http://xml.org/sax/features/lexical-handler/parameter-entities";
    public static final String resolveDTDURIsFeature = "http://xml.org/sax/features/resolve-dtd-uris";
    public static final String stringInterningFeature = "http://xml.org/sax/features/string-interning";
    public static final String useAttributes2Feature = "http://xml.org/sax/features/use-attributes2";
    public static final String useLocator2Feature = "http://xml.org/sax/features/use-locator2";
    public static final String useEntityResolver2Feature = "http://xml.org/sax/features/use-entity-resolver2";
    public static final String validationFeature = "http://xml.org/sax/features/validation";
    public static final String unicodeNormalizationCheckingFeature = "http://xml.org/sax/features/unicode-normalization-checking";
    public static final String xmlnsURIsFeature = "http://xml.org/sax/features/xmlns-uris";
    public static final String XML11Feature = "http://xml.org/sax/features/xml-1.1";
    public static final String ignoreBogonsFeature = "http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons";
    public static final String bogonsEmptyFeature = "http://www.ccil.org/~cowan/tagsoup/features/bogons-empty";
    public static final String rootBogonsFeature = "http://www.ccil.org/~cowan/tagsoup/features/root-bogons";
    public static final String defaultAttributesFeature = "http://www.ccil.org/~cowan/tagsoup/features/default-attributes";
    public static final String translateColonsFeature = "http://www.ccil.org/~cowan/tagsoup/features/translate-colons";
    public static final String restartElementsFeature = "http://www.ccil.org/~cowan/tagsoup/features/restart-elements";
    public static final String ignorableWhitespaceFeature = "http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace";
    public static final String CDATAElementsFeature = "http://www.ccil.org/~cowan/tagsoup/features/cdata-elements";
    public static final String lexicalHandlerProperty = "http://xml.org/sax/properties/lexical-handler";
    public static final String scannerProperty = "http://www.ccil.org/~cowan/tagsoup/properties/scanner";
    public static final String schemaProperty = "http://www.ccil.org/~cowan/tagsoup/properties/schema";
    public static final String autoDetectorProperty = "http://www.ccil.org/~cowan/tagsoup/properties/auto-detector";
    private HashMap theFeatures = new HashMap();
    private Element theNewElement;
    private String theAttributeName;
    private boolean theDoctypeIsPresent;
    private String theDoctypePublicId;
    private String theDoctypeSystemId;
    private String theDoctypeName;
    private String thePITarget;
    private Element theStack;
    private Element theSaved;
    private Element thePCDATA;
    private int theEntity;
    private static char[] etagchars = new char[]{'<', '/', '>'};
    private boolean virginStack;
    private static String legal = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-'()+,./:=?;!*#@$_%";
    private char[] theCommentBuffer;

    public Parser() {
        this.theFeatures.put(namespacesFeature, Parser.truthValue(DEFAULT_NAMESPACES));
        this.theFeatures.put(namespacePrefixesFeature, Boolean.FALSE);
        this.theFeatures.put(externalGeneralEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put(externalParameterEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put(isStandaloneFeature, Boolean.FALSE);
        this.theFeatures.put(lexicalHandlerParameterEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put(resolveDTDURIsFeature, Boolean.TRUE);
        this.theFeatures.put(stringInterningFeature, Boolean.TRUE);
        this.theFeatures.put(useAttributes2Feature, Boolean.FALSE);
        this.theFeatures.put(useLocator2Feature, Boolean.FALSE);
        this.theFeatures.put(useEntityResolver2Feature, Boolean.FALSE);
        this.theFeatures.put(validationFeature, Boolean.FALSE);
        this.theFeatures.put(xmlnsURIsFeature, Boolean.FALSE);
        this.theFeatures.put(xmlnsURIsFeature, Boolean.FALSE);
        this.theFeatures.put(XML11Feature, Boolean.FALSE);
        this.theFeatures.put(ignoreBogonsFeature, Parser.truthValue(DEFAULT_IGNORE_BOGONS));
        this.theFeatures.put(bogonsEmptyFeature, Parser.truthValue(DEFAULT_BOGONS_EMPTY));
        this.theFeatures.put(rootBogonsFeature, Parser.truthValue(DEFAULT_ROOT_BOGONS));
        this.theFeatures.put(defaultAttributesFeature, Parser.truthValue(DEFAULT_DEFAULT_ATTRIBUTES));
        this.theFeatures.put(translateColonsFeature, Parser.truthValue(DEFAULT_TRANSLATE_COLONS));
        this.theFeatures.put(restartElementsFeature, Parser.truthValue(DEFAULT_RESTART_ELEMENTS));
        this.theFeatures.put(ignorableWhitespaceFeature, Parser.truthValue(DEFAULT_IGNORABLE_WHITESPACE));
        this.theFeatures.put(CDATAElementsFeature, Parser.truthValue(DEFAULT_CDATA_ELEMENTS));
        this.theNewElement = null;
        this.theAttributeName = null;
        this.theDoctypeIsPresent = false;
        this.theDoctypePublicId = null;
        this.theDoctypeSystemId = null;
        this.theDoctypeName = null;
        this.thePITarget = null;
        this.theStack = null;
        this.theSaved = null;
        this.thePCDATA = null;
        this.theEntity = 0;
        this.virginStack = true;
        this.theCommentBuffer = new char[2000];
    }

    private static Boolean truthValue(boolean bl2) {
        return bl2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl2 = (Boolean)this.theFeatures.get(string);
        if (bl2 == null) {
            throw new SAXNotRecognizedException(new StringBuffer().append("Unknown feature ").append(string).toString());
        }
        return bl2;
    }

    @Override
    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl3 = (Boolean)this.theFeatures.get(string);
        if (bl3 == null) {
            throw new SAXNotRecognizedException(new StringBuffer().append("Unknown feature ").append(string).toString());
        }
        if (bl2) {
            this.theFeatures.put(string, Boolean.TRUE);
        } else {
            this.theFeatures.put(string, Boolean.FALSE);
        }
        if (string.equals(namespacesFeature)) {
            this.namespaces = bl2;
        } else if (string.equals(ignoreBogonsFeature)) {
            this.ignoreBogons = bl2;
        } else if (string.equals(bogonsEmptyFeature)) {
            this.bogonsEmpty = bl2;
        } else if (string.equals(rootBogonsFeature)) {
            this.rootBogons = bl2;
        } else if (string.equals(defaultAttributesFeature)) {
            this.defaultAttributes = bl2;
        } else if (string.equals(translateColonsFeature)) {
            this.translateColons = bl2;
        } else if (string.equals(restartElementsFeature)) {
            this.restartElements = bl2;
        } else if (string.equals(ignorableWhitespaceFeature)) {
            this.ignorableWhitespace = bl2;
        } else if (string.equals(CDATAElementsFeature)) {
            this.CDATAElements = bl2;
        }
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(lexicalHandlerProperty)) {
            return this.theLexicalHandler == this ? null : this.theLexicalHandler;
        }
        if (string.equals(scannerProperty)) {
            return this.theScanner;
        }
        if (string.equals(schemaProperty)) {
            return this.theSchema;
        }
        if (string.equals(autoDetectorProperty)) {
            return this.theAutoDetector;
        }
        throw new SAXNotRecognizedException(new StringBuffer().append("Unknown property ").append(string).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(lexicalHandlerProperty)) {
            if (object == null) {
                this.theLexicalHandler = this;
                return;
            } else {
                if (!(object instanceof LexicalHandler)) throw new SAXNotSupportedException("Your lexical handler is not a LexicalHandler");
                this.theLexicalHandler = (LexicalHandler)object;
            }
            return;
        } else if (string.equals(scannerProperty)) {
            if (!(object instanceof Scanner)) throw new SAXNotSupportedException("Your scanner is not a Scanner");
            this.theScanner = (Scanner)object;
            return;
        } else if (string.equals(schemaProperty)) {
            if (!(object instanceof Schema)) throw new SAXNotSupportedException("Your schema is not a Schema");
            this.theSchema = (Schema)object;
            return;
        } else {
            if (!string.equals(autoDetectorProperty)) throw new SAXNotRecognizedException(new StringBuffer().append("Unknown property ").append(string).toString());
            if (!(object instanceof AutoDetector)) throw new SAXNotSupportedException("Your auto-detector is not an AutoDetector");
            this.theAutoDetector = (AutoDetector)object;
        }
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.theEntityResolver = entityResolver == null ? this : entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.theEntityResolver == this ? null : this.theEntityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.theDTDHandler = dTDHandler == null ? this : dTDHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.theDTDHandler == this ? null : this.theDTDHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.theContentHandler = contentHandler == null ? this : contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.theContentHandler == this ? null : this.theContentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.theErrorHandler = errorHandler == null ? this : errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.theErrorHandler == this ? null : this.theErrorHandler;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.setup();
        Reader reader = this.getReader(inputSource);
        this.theContentHandler.startDocument();
        this.theScanner.resetDocumentLocator(inputSource.getPublicId(), inputSource.getSystemId());
        if (this.theScanner instanceof Locator) {
            this.theContentHandler.setDocumentLocator((Locator)((Object)this.theScanner));
        }
        if (!this.theSchema.getURI().equals("")) {
            this.theContentHandler.startPrefixMapping(this.theSchema.getPrefix(), this.theSchema.getURI());
        }
        this.theScanner.scan(reader, this);
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    private void setup() {
        if (this.theSchema == null) {
            this.theSchema = new HTMLSchema();
        }
        if (this.theScanner == null) {
            this.theScanner = new HTMLScanner();
        }
        if (this.theAutoDetector == null) {
            this.theAutoDetector = new AutoDetector(){

                @Override
                public Reader autoDetectingReader(InputStream inputStream) {
                    return new InputStreamReader(inputStream);
                }
            };
        }
        this.theStack = new Element(this.theSchema.getElementType("<root>"), this.defaultAttributes);
        this.thePCDATA = new Element(this.theSchema.getElementType("<pcdata>"), this.defaultAttributes);
        this.theNewElement = null;
        this.theAttributeName = null;
        this.thePITarget = null;
        this.theSaved = null;
        this.theEntity = 0;
        this.virginStack = true;
        this.theDoctypeSystemId = null;
        this.theDoctypePublicId = null;
        this.theDoctypeName = null;
    }

    private Reader getReader(InputSource inputSource) throws SAXException, IOException {
        Reader reader = inputSource.getCharacterStream();
        InputStream inputStream = inputSource.getByteStream();
        String string = inputSource.getEncoding();
        String string2 = inputSource.getPublicId();
        String string3 = inputSource.getSystemId();
        if (reader == null) {
            if (inputStream == null) {
                inputStream = this.getInputStream(string2, string3);
            }
            if (string == null) {
                reader = this.theAutoDetector.autoDetectingReader(inputStream);
            } else {
                try {
                    reader = new InputStreamReader(inputStream, string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    reader = new InputStreamReader(inputStream);
                }
            }
        }
        return reader;
    }

    private InputStream getInputStream(String string, String string2) throws IOException, SAXException {
        URL uRL = new URL("file", "", new StringBuffer().append(System.getProperty("user.dir")).append("/.").toString());
        URL uRL2 = new URL(uRL, string2);
        URLConnection uRLConnection = uRL2.openConnection();
        return uRLConnection.getInputStream();
    }

    @Override
    public void adup(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement == null || this.theAttributeName == null) {
            return;
        }
        this.theNewElement.setAttribute(this.theAttributeName, null, this.theAttributeName);
        this.theAttributeName = null;
    }

    @Override
    public void aname(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.theAttributeName = this.makeName(cArray, n2, n3).toLowerCase();
    }

    @Override
    public void aval(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement == null || this.theAttributeName == null) {
            return;
        }
        String string = new String(cArray, n2, n3);
        string = this.expandEntities(string);
        this.theNewElement.setAttribute(this.theAttributeName, null, string);
        this.theAttributeName = null;
    }

    private String expandEntities(String string) {
        int n2 = -1;
        int n3 = string.length();
        char[] cArray = new char[n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            cArray[n4++] = c2;
            if (c2 == '&' && n2 == -1) {
                n2 = n4;
                continue;
            }
            if (n2 == -1 || Character.isLetter(c2) || Character.isDigit(c2) || c2 == '#') continue;
            if (c2 == ';') {
                int n5 = this.lookupEntity(cArray, n2, n4 - n2 - 1);
                if (n5 > 65535) {
                    cArray[n2 - 1] = (char)(((n5 -= 65536) >> 10) + 55296);
                    cArray[n2] = (char)((n5 & 0x3FF) + 56320);
                    n4 = n2 + 1;
                } else if (n5 != 0) {
                    cArray[n2 - 1] = (char)n5;
                    n4 = n2;
                }
                n2 = -1;
                continue;
            }
            n2 = -1;
        }
        return new String(cArray, 0, n4);
    }

    @Override
    public void entity(char[] cArray, int n2, int n3) throws SAXException {
        this.theEntity = this.lookupEntity(cArray, n2, n3);
    }

    private int lookupEntity(char[] cArray, int n2, int n3) {
        int n4 = 0;
        if (n3 < 1) {
            return n4;
        }
        if (cArray[n2] == '#') {
            if (n3 > 1 && (cArray[n2 + 1] == 'x' || cArray[n2 + 1] == 'X')) {
                try {
                    return Integer.parseInt(new String(cArray, n2 + 2, n3 - 2), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
            try {
                return Integer.parseInt(new String(cArray, n2 + 1, n3 - 1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return this.theSchema.getEntity(new String(cArray, n2, n3));
    }

    @Override
    public void eof(char[] cArray, int n2, int n3) throws SAXException {
        if (this.virginStack) {
            this.rectify(this.thePCDATA);
        }
        while (this.theStack.next() != null) {
            this.pop();
        }
        if (!this.theSchema.getURI().equals("")) {
            this.theContentHandler.endPrefixMapping(this.theSchema.getPrefix());
        }
        this.theContentHandler.endDocument();
    }

    @Override
    public void etag(char[] cArray, int n2, int n3) throws SAXException {
        if (this.etag_cdata(cArray, n2, n3)) {
            return;
        }
        this.etag_basic(cArray, n2, n3);
    }

    public boolean etag_cdata(char[] cArray, int n2, int n3) throws SAXException {
        String string = this.theStack.name();
        if (this.CDATAElements && (this.theStack.flags() & 2) != 0) {
            boolean bl2;
            boolean bl3 = bl2 = n3 == string.length();
            if (bl2) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (Character.toLowerCase(cArray[n2 + i2]) == Character.toLowerCase(string.charAt(i2))) continue;
                    bl2 = false;
                    break;
                }
            }
            if (!bl2) {
                this.theContentHandler.characters(etagchars, 0, 2);
                this.theContentHandler.characters(cArray, n2, n3);
                this.theContentHandler.characters(etagchars, 2, 1);
                this.theScanner.startCDATA();
                return true;
            }
        }
        return false;
    }

    public void etag_basic(char[] cArray, int n2, int n3) throws SAXException {
        Object object;
        String string;
        this.theNewElement = null;
        if (n3 != 0) {
            string = this.makeName(cArray, n2, n3);
            object = this.theSchema.getElementType(string);
            if (object == null) {
                return;
            }
            string = ((ElementType)object).name();
        } else {
            string = this.theStack.name();
        }
        boolean bl2 = false;
        for (object = this.theStack; object != null && !((Element)object).name().equals(string); object = ((Element)object).next()) {
            if ((((Element)object).flags() & 4) == 0) continue;
            bl2 = true;
        }
        if (object == null) {
            return;
        }
        if (((Element)object).next() == null || ((Element)object).next().next() == null) {
            return;
        }
        if (bl2) {
            ((Element)object).preclose();
        } else {
            while (this.theStack != object) {
                this.restartablyPop();
            }
            this.pop();
        }
        while (this.theStack.isPreclosed()) {
            this.pop();
        }
        this.restart(null);
    }

    private void restart(Element element) throws SAXException {
        while (this.theSaved != null && this.theStack.canContain(this.theSaved) && (element == null || this.theSaved.canContain(element))) {
            Element element2 = this.theSaved.next();
            this.push(this.theSaved);
            this.theSaved = element2;
        }
    }

    private void pop() throws SAXException {
        if (this.theStack == null) {
            return;
        }
        String string = this.theStack.name();
        String string2 = this.theStack.localName();
        String string3 = this.theStack.namespace();
        String string4 = this.prefixOf(string);
        if (!this.namespaces) {
            string2 = "";
            string3 = "";
        }
        this.theContentHandler.endElement(string3, string2, string);
        if (this.foreign(string4, string3)) {
            this.theContentHandler.endPrefixMapping(string4);
        }
        AttributesImpl attributesImpl = this.theStack.atts();
        for (int i2 = attributesImpl.getLength() - 1; i2 >= 0; --i2) {
            String string5 = attributesImpl.getURI(i2);
            String string6 = this.prefixOf(attributesImpl.getQName(i2));
            if (!this.foreign(string6, string5)) continue;
            this.theContentHandler.endPrefixMapping(string6);
        }
        this.theStack = this.theStack.next();
    }

    private void restartablyPop() throws SAXException {
        Element element = this.theStack;
        this.pop();
        if (this.restartElements && (element.flags() & 1) != 0) {
            element.anonymize();
            element.setNext(this.theSaved);
            this.theSaved = element;
        }
    }

    private void push(Element element) throws SAXException {
        String string = element.name();
        String string2 = element.localName();
        String string3 = element.namespace();
        String string4 = this.prefixOf(string);
        element.clean();
        if (!this.namespaces) {
            string2 = "";
            string3 = "";
        }
        if (this.virginStack && string2.equalsIgnoreCase(this.theDoctypeName)) {
            try {
                this.theEntityResolver.resolveEntity(this.theDoctypePublicId, this.theDoctypeSystemId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.foreign(string4, string3)) {
            this.theContentHandler.startPrefixMapping(string4, string3);
        }
        AttributesImpl attributesImpl = element.atts();
        int n2 = attributesImpl.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string5 = attributesImpl.getURI(i2);
            String string6 = this.prefixOf(attributesImpl.getQName(i2));
            if (!this.foreign(string6, string5)) continue;
            this.theContentHandler.startPrefixMapping(string6, string5);
        }
        this.theContentHandler.startElement(string3, string2, string, element.atts());
        element.setNext(this.theStack);
        this.theStack = element;
        this.virginStack = false;
        if (this.CDATAElements && (this.theStack.flags() & 2) != 0) {
            this.theScanner.startCDATA();
        }
    }

    private String prefixOf(String string) {
        int n2 = string.indexOf(58);
        String string2 = "";
        if (n2 != -1) {
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    private boolean foreign(String string, String string2) {
        boolean bl2 = !string.equals("") && !string2.equals("") && !string2.equals(this.theSchema.getURI());
        return bl2;
    }

    @Override
    public void decl(char[] cArray, int n2, int n3) throws SAXException {
        String string = new String(cArray, n2, n3);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = Parser.split(string);
        if (stringArray.length > 0 && "DOCTYPE".equalsIgnoreCase(stringArray[0])) {
            if (this.theDoctypeIsPresent) {
                return;
            }
            this.theDoctypeIsPresent = true;
            if (stringArray.length > 1) {
                string2 = stringArray[1];
                if (stringArray.length > 3 && "SYSTEM".equals(stringArray[2])) {
                    string3 = stringArray[3];
                } else if (stringArray.length > 3 && "PUBLIC".equals(stringArray[2])) {
                    string4 = stringArray[3];
                    string3 = stringArray.length > 4 ? stringArray[4] : "";
                }
            }
        }
        string4 = Parser.trimquotes(string4);
        string3 = Parser.trimquotes(string3);
        if (string2 != null) {
            string4 = this.cleanPublicid(string4);
            this.theLexicalHandler.startDTD(string2, string4, string3);
            this.theLexicalHandler.endDTD();
            this.theDoctypeName = string2;
            this.theDoctypePublicId = string4;
            if (this.theScanner instanceof Locator) {
                this.theDoctypeSystemId = ((Locator)((Object)this.theScanner)).getSystemId();
                try {
                    this.theDoctypeSystemId = new URL(new URL(this.theDoctypeSystemId), string3).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String trimquotes(String string) {
        char c2;
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        char c3 = string.charAt(0);
        if (c3 == (c2 = string.charAt(n2 - 1)) && (c3 == '\'' || c3 == '\"')) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String[] split(String string) throws IllegalArgumentException {
        if ((string = string.trim()).length() == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n4 = 0;
        int n5 = string.length();
        for (n3 = 0; n3 < n5; ++n3) {
            char c2 = string.charAt(n3);
            if (!bl3 && c2 == '\'' && n4 != 92) {
                boolean bl4 = bl2 = !bl2;
                if (n2 < 0) {
                    n2 = n3;
                }
            } else if (!bl2 && c2 == '\"' && n4 != 92) {
                boolean bl5 = bl3 = !bl3;
                if (n2 < 0) {
                    n2 = n3;
                }
            } else if (!bl2 && !bl3) {
                if (Character.isWhitespace(c2)) {
                    if (n2 >= 0) {
                        arrayList.add(string.substring(n2, n3));
                    }
                    n2 = -1;
                } else if (n2 < 0 && c2 != ' ') {
                    n2 = n3;
                }
            }
            n4 = c2;
        }
        arrayList.add(string.substring(n2, n3));
        return arrayList.toArray(new String[0]);
    }

    private String cleanPublicid(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (legal.indexOf(c2) != -1) {
                stringBuffer.append(c2);
                bl2 = false;
                continue;
            }
            if (bl2) continue;
            stringBuffer.append(' ');
            bl2 = true;
        }
        return stringBuffer.toString().trim();
    }

    @Override
    public void gi(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement != null) {
            return;
        }
        String string = this.makeName(cArray, n2, n3);
        if (string == null) {
            return;
        }
        ElementType elementType = this.theSchema.getElementType(string);
        if (elementType == null) {
            if (this.ignoreBogons) {
                return;
            }
            int n4 = this.bogonsEmpty ? 0 : -1;
            int n5 = this.rootBogons ? -1 : Integer.MAX_VALUE;
            this.theSchema.elementType(string, n4, n5, 0);
            if (!this.rootBogons) {
                this.theSchema.parent(string, this.theSchema.rootElementType().name());
            }
            elementType = this.theSchema.getElementType(string);
        }
        this.theNewElement = new Element(elementType, this.defaultAttributes);
    }

    @Override
    public void cdsect(char[] cArray, int n2, int n3) throws SAXException {
        this.theLexicalHandler.startCDATA();
        this.pcdata(cArray, n2, n3);
        this.theLexicalHandler.endCDATA();
    }

    @Override
    public void pcdata(char[] cArray, int n2, int n3) throws SAXException {
        if (n3 == 0) {
            return;
        }
        boolean bl2 = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Character.isWhitespace(cArray[n2 + i2])) continue;
            bl2 = false;
        }
        if (bl2 && !this.theStack.canContain(this.thePCDATA)) {
            if (this.ignorableWhitespace) {
                this.theContentHandler.ignorableWhitespace(cArray, n2, n3);
            }
        } else {
            this.rectify(this.thePCDATA);
            this.theContentHandler.characters(cArray, n2, n3);
        }
    }

    @Override
    public void pitarget(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement != null) {
            return;
        }
        this.thePITarget = this.makeName(cArray, n2, n3).replace(':', '_');
    }

    @Override
    public void pi(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement != null || this.thePITarget == null) {
            return;
        }
        if ("xml".equalsIgnoreCase(this.thePITarget)) {
            return;
        }
        if (n3 > 0 && cArray[n3 - 1] == '?') {
            --n3;
        }
        this.theContentHandler.processingInstruction(this.thePITarget, new String(cArray, n2, n3));
        this.thePITarget = null;
    }

    @Override
    public void stagc(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.rectify(this.theNewElement);
        if (this.theStack.model() == 0) {
            this.etag_basic(cArray, n2, n3);
        }
    }

    @Override
    public void stage(char[] cArray, int n2, int n3) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.rectify(this.theNewElement);
        this.etag_basic(cArray, n2, n3);
    }

    @Override
    public void cmnt(char[] cArray, int n2, int n3) throws SAXException {
        this.theLexicalHandler.comment(cArray, n2, n3);
    }

    private void rectify(Element object) throws SAXException {
        Object object2;
        Element element;
        while (true) {
            for (element = this.theStack; element != null && !element.canContain((Element)object); element = element.next()) {
            }
            if (element != null || (object2 = ((Element)object).parent()) == null) break;
            Element element2 = new Element((ElementType)object2, this.defaultAttributes);
            element2.setNext((Element)object);
            object = element2;
        }
        if (element == null) {
            return;
        }
        while (this.theStack != element && this.theStack != null && this.theStack.next() != null && this.theStack.next().next() != null) {
            this.restartablyPop();
        }
        while (object != null) {
            object2 = ((Element)object).next();
            if (!((Element)object).name().equals("<pcdata>")) {
                this.push((Element)object);
            }
            object = object2;
            this.restart((Element)object);
        }
        this.theNewElement = null;
    }

    @Override
    public int getEntity() {
        return this.theEntity;
    }

    private String makeName(char[] cArray, int n2, int n3) {
        int n4;
        StringBuffer stringBuffer = new StringBuffer(n3 + 2);
        boolean bl2 = false;
        boolean bl3 = true;
        while (n3-- > 0) {
            n4 = cArray[n2];
            if (Character.isLetter((char)n4) || n4 == 95) {
                bl3 = false;
                stringBuffer.append((char)n4);
            } else if (Character.isDigit((char)n4) || n4 == 45 || n4 == 46) {
                if (bl3) {
                    stringBuffer.append('_');
                }
                bl3 = false;
                stringBuffer.append((char)n4);
            } else if (n4 == 58 && !bl2) {
                bl2 = true;
                if (bl3) {
                    stringBuffer.append('_');
                }
                bl3 = true;
                stringBuffer.append((char)(this.translateColons ? 95 : n4));
            }
            ++n2;
        }
        n4 = stringBuffer.length();
        if (n4 == 0 || stringBuffer.charAt(n4 - '\u0001') == ':') {
            stringBuffer.append('_');
        }
        return stringBuffer.toString().intern();
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }
}

