/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.evt;

import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.XMLStreamWriter2;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.evt.BaseEventImpl;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;

public class CharactersEventImpl
extends BaseEventImpl
implements Characters {
    final String mContent;
    final boolean mIsCData;
    final boolean mIgnorableWS;
    boolean mWhitespaceChecked = false;
    boolean mIsWhitespace = false;

    public CharactersEventImpl(Location location, String string, boolean bl2) {
        super(location);
        this.mContent = string;
        this.mIsCData = bl2;
        this.mIgnorableWS = false;
    }

    private CharactersEventImpl(Location location, String string, boolean bl2, boolean bl3, boolean bl4) {
        super(location);
        this.mContent = string;
        this.mIsCData = bl2;
        this.mIsWhitespace = bl3;
        if (bl3) {
            this.mWhitespaceChecked = true;
            this.mIgnorableWS = bl4;
        } else {
            this.mWhitespaceChecked = false;
            this.mIgnorableWS = false;
        }
    }

    public static final CharactersEventImpl createIgnorableWS(Location location, String string) {
        return new CharactersEventImpl(location, string, false, true, true);
    }

    public static final CharactersEventImpl createNonIgnorableWS(Location location, String string) {
        return new CharactersEventImpl(location, string, false, true, false);
    }

    @Override
    public Characters asCharacters() {
        return this;
    }

    @Override
    public int getEventType() {
        return this.mIsCData ? 12 : 4;
    }

    @Override
    public boolean isCharacters() {
        return true;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            if (this.mIsCData) {
                writer.write("<![CDATA[");
                writer.write(this.mContent);
                writer.write("]]>");
            } else {
                CharactersEventImpl.writeEscapedXMLText(writer, this.mContent);
            }
        }
        catch (IOException iOException) {
            this.throwFromIOE(iOException);
        }
    }

    @Override
    public void writeUsing(XMLStreamWriter2 xMLStreamWriter2) throws XMLStreamException {
        if (this.mIsCData) {
            xMLStreamWriter2.writeCData(this.mContent);
        } else {
            xMLStreamWriter2.writeCharacters(this.mContent);
        }
    }

    @Override
    public String getData() {
        return this.mContent;
    }

    @Override
    public boolean isCData() {
        return this.mIsCData;
    }

    @Override
    public boolean isIgnorableWhiteSpace() {
        return this.mIgnorableWS;
    }

    @Override
    public boolean isWhiteSpace() {
        if (!this.mWhitespaceChecked) {
            int n2;
            this.mWhitespaceChecked = true;
            String string = this.mContent;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && string.charAt(n2) <= ' '; ++n2) {
            }
            this.mIsWhitespace = n2 == n3;
        }
        return this.mIsWhitespace;
    }

    public void setWhitespaceStatus(boolean bl2) {
        this.mWhitespaceChecked = true;
        this.mIsWhitespace = bl2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Characters)) {
            return false;
        }
        Characters characters = (Characters)object;
        if (this.mContent.equals(characters.getData())) {
            return this.isCData() == characters.isCData();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mContent.hashCode();
    }

    protected static void writeEscapedXMLText(Writer writer, String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            char c2 = '\u0000';
            while (i2 < n2 && (c2 = string.charAt(i2)) != '<' && c2 != '&' && (c2 != '>' || i2 < 2 || string.charAt(i2 - 1) != ']' || string.charAt(i2 - 2) != ']')) {
                ++i2;
            }
            int n4 = i2 - n3;
            if (n4 > 0) {
                writer.write(string, n3, n4);
            }
            if (i2 >= n2) continue;
            if (c2 == '<') {
                writer.write("&lt;");
                continue;
            }
            if (c2 == '&') {
                writer.write("&amp;");
                continue;
            }
            if (c2 != '>') continue;
            writer.write("&gt;");
        }
    }
}

