/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector;

import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.error.YAMLException;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector.BeanAccess;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector.FieldProperty;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector.MethodProperty;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector.MissingProperty;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector.Property;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.util.PlatformFeatureDetector;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private final Map<Class<?>, Set<Property>> readableProperties = new HashMap();
    private BeanAccess beanAccess = BeanAccess.DEFAULT;
    private boolean allowReadOnlyProperties = false;
    private boolean skipMissingProperties = false;
    private PlatformFeatureDetector platformFeatureDetector;
    private static final String TRANSIENT = "transient";

    public PropertyUtils() {
        this(new PlatformFeatureDetector());
    }

    PropertyUtils(PlatformFeatureDetector platformFeatureDetector) {
        this.platformFeatureDetector = platformFeatureDetector;
        if (platformFeatureDetector.isRunningOnAndroid()) {
            this.beanAccess = BeanAccess.FIELD;
        }
    }

    protected Map<String, Property> getPropertiesMap(Class<?> clazz, BeanAccess beanAccess) {
        if (this.propertiesCache.containsKey(clazz)) {
            return this.propertiesCache.get(clazz);
        }
        LinkedHashMap<String, Property> linkedHashMap = new LinkedHashMap<String, Property>();
        boolean bl2 = false;
        switch (beanAccess) {
            case FIELD: {
                for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    for (Field field : clazz2.getDeclaredFields()) {
                        int n2 = field.getModifiers();
                        if (Modifier.isStatic(n2) || Modifier.isTransient(n2) || linkedHashMap.containsKey(field.getName())) continue;
                        linkedHashMap.put(field.getName(), new FieldProperty(field));
                    }
                }
                break;
            }
            default: {
                Object object;
                try {
                    object = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                    int n3 = ((PropertyDescriptor[])object).length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        PropertyDescriptor propertyDescriptor = object[i2];
                        Method accessibleObject = propertyDescriptor.getReadMethod();
                        if (accessibleObject != null && accessibleObject.getName().equals("getClass") || this.isTransient(propertyDescriptor)) continue;
                        linkedHashMap.put(propertyDescriptor.getName(), new MethodProperty(propertyDescriptor));
                    }
                }
                catch (IntrospectionException introspectionException) {
                    throw new YAMLException(introspectionException);
                }
                for (object = clazz; object != null; object = ((Class)object).getSuperclass()) {
                    for (Field field : ((Class)object).getDeclaredFields()) {
                        int n3 = field.getModifiers();
                        if (Modifier.isStatic(n3) || Modifier.isTransient(n3)) continue;
                        if (Modifier.isPublic(n3)) {
                            linkedHashMap.put(field.getName(), new FieldProperty(field));
                            continue;
                        }
                        bl2 = true;
                    }
                }
            }
        }
        if (linkedHashMap.isEmpty() && bl2) {
            throw new YAMLException("No JavaBean properties found in " + clazz.getName());
        }
        this.propertiesCache.put(clazz, linkedHashMap);
        return linkedHashMap;
    }

    private boolean isTransient(FeatureDescriptor featureDescriptor) {
        return Boolean.TRUE.equals(featureDescriptor.getValue(TRANSIENT));
    }

    public Set<Property> getProperties(Class<? extends Object> clazz) {
        return this.getProperties(clazz, this.beanAccess);
    }

    public Set<Property> getProperties(Class<? extends Object> clazz, BeanAccess beanAccess) {
        if (this.readableProperties.containsKey(clazz)) {
            return this.readableProperties.get(clazz);
        }
        Set<Property> set = this.createPropertySet(clazz, beanAccess);
        this.readableProperties.put(clazz, set);
        return set;
    }

    protected Set<Property> createPropertySet(Class<? extends Object> clazz, BeanAccess beanAccess) {
        TreeSet<Property> treeSet = new TreeSet<Property>();
        Collection<Property> collection = this.getPropertiesMap(clazz, beanAccess).values();
        for (Property property : collection) {
            if (!property.isReadable() || !this.allowReadOnlyProperties && !property.isWritable()) continue;
            treeSet.add(property);
        }
        return treeSet;
    }

    public Property getProperty(Class<? extends Object> clazz, String string) {
        return this.getProperty(clazz, string, this.beanAccess);
    }

    public Property getProperty(Class<? extends Object> clazz, String string, BeanAccess beanAccess) {
        Map<String, Property> map = this.getPropertiesMap(clazz, beanAccess);
        Property property = map.get(string);
        if (property == null && this.skipMissingProperties) {
            property = new MissingProperty(string);
        }
        if (property == null) {
            throw new YAMLException("Unable to find property '" + string + "' on class: " + clazz.getName());
        }
        return property;
    }

    public void setBeanAccess(BeanAccess beanAccess) {
        if (this.platformFeatureDetector.isRunningOnAndroid() && beanAccess != BeanAccess.FIELD) {
            throw new IllegalArgumentException("JVM is Android - only BeanAccess.FIELD is available");
        }
        if (this.beanAccess != beanAccess) {
            this.beanAccess = beanAccess;
            this.propertiesCache.clear();
            this.readableProperties.clear();
        }
    }

    public void setAllowReadOnlyProperties(boolean bl2) {
        if (this.allowReadOnlyProperties != bl2) {
            this.allowReadOnlyProperties = bl2;
            this.readableProperties.clear();
        }
    }

    public boolean isAllowReadOnlyProperties() {
        return this.allowReadOnlyProperties;
    }

    public void setSkipMissingProperties(boolean bl2) {
        if (this.skipMissingProperties != bl2) {
            this.skipMissingProperties = bl2;
            this.readableProperties.clear();
        }
    }

    public boolean isSkipMissingProperties() {
        return this.skipMissingProperties;
    }
}

